<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use DB;

class ProcessBulkUpload implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $data;
    public $send_sms;
    public $get_admin_email;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($chunk,$send_sms,$get_admin_email)
    {
        $this->send_sms = $send_sms;
        $this->data = $chunk;
        $this->get_admin_email = $get_admin_email;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        foreach ($this->data as $key => $leads_send) {
            $get_admin_contact = DB::table('company_info')
                ->select('company_info.*', 'users.email as admin', 'users.first_name as admin_name')
                ->leftjoin('users', 'company_info.user_id', 'users.id')
                ->where('users.email', $leads_send['admin_email'])
                ->first();
            if ($get_admin_contact != null) {
                if (empty($leads_send['email'])) {
                    $check_email = null;
                    $leads_send['email'] = null;
                } else {
                    $check_email = DB::table('leads')->where('email', $leads_send['email'])->where('admin_email',$this->get_admin_email)->first();
                }
                if (empty($leads_send['contact'])) {
                    $check_phone = null;
                    $leads_send['contact'] = null;
                } else {
                    $replace = array("_", "-", " ", ",", ".", "+", "`", "'", '"');
                    $lead_contact_numbers = str_replace($replace, "", $leads_send['contact']);
                    $lead_contact_number = preg_replace('/[^0-9\-]/', '', $lead_contact_numbers);
                    $numlength = strlen((string)$lead_contact_number);
                    if ($numlength == 11) {
                        $leads_send['contact'] = '+' . $lead_contact_number;
                    } else {
                        $leads_send['contact'] = '+1' . $lead_contact_number;
                    }
                    $check_phone = DB::table('leads')->where('contact', $leads_send['contact'])->where('admin_email',$this->get_admin_email)->first();
                }
                if ($check_phone == null) {
                    if ($check_email == null) {
                        if (empty($leads_send['sender_first_name'])) {
                            $first_name = "Unknown";
                        } else {
                            $first_name = $leads_send['sender_first_name'];
                        }
                        if (empty($leads_send['sender_last_name'])) {
                            $last_name = "Unknown";
                        } else {
                            $last_name = $leads_send['sender_last_name'];
                        }
                        if ($this->send_sms == 'on') {
//                                    $insert_lead = DB::table('lead_bulk')->insertGetId([
//                                        'title' => null,
//                                        'lead_provider' => $leads_send['lead_provider'],
//                                        'admin_email' => $leads_send['admin_email'],
//                                        'assigned_date' => $leads_send['assigned_date'],
//                                        'email' => $leads_send['email'],
//                                        'contact' => $leads_send['contact'],
//                                        'status' => "unassigned",
//                                        'classification' => "Sales",
//                                        'sender_first_name' => $first_name,
//                                        'sender_last_name' => $last_name,
//                                        'company' => null,
//                                        'address' => $leads_send['address'],
//                                        'city' => $leads_send['city'],
//                                        'state' => $leads_send['state'],
//                                        'zip' => $leads_send['zip'],
//                                        'assigned_user_id' => null,
//                                        'lead_status' => $leads_send['lead_status'],
//                                        'year' =>  $leads_send['year'],
//                                        'make' =>  $leads_send['make'],
//                                        'model' =>  $leads_send['model'],
//                                        'vin' =>  $leads_send['vin'],
//                                        'bulk_status' => 'yes'
//                                    ]);
                            $leads_org = DB::table('leads_testing')->insertGetId([
                                'title' => null,
                                'lead_provider' => $leads_send['lead_provider'],
                                'admin_email' => $leads_send['admin_email'],
                                'assigned_date' => $leads_send['assigned_date'],
                                'email' => $leads_send['email'],
                                'contact' => $leads_send['contact'],
                                'status' => "unassigned",
                                'classification' => "Sales",
                                'sender_first_name' => $first_name,
                                'sender_last_name' => $last_name,
                                'company' => null,
                                'address' => $leads_send['address'],
                                'city' => $leads_send['city'],
                                'state' => $leads_send['state'],
                                'zip' => $leads_send['zip'],
                                'assigned_user_id' => null,
                                'lead_status' => $leads_send['lead_status']
                            ]);
//                                    DB::table('leads_inventory_info')->insert([
//                                        'lead_id' => $leads_org,
//                                        'year' =>  $leads_send['year'],
//                                        'make' =>  $leads_send['make'],
//                                        'model' =>  $leads_send['model'],
//                                        'vin' =>  $leads_send['vin']
//                                    ]);
                            // $insert_lead = DB::table('lead_bulk')->insert($arr);
//                                    toastr()->success('CSV Add Successfully');
//                                    return redirect()->route('text');
                        }
                        else {
//                                    $insert_lead = DB::table('lead_bulk')->insertGetId([
//                                        'title' => null,
//                                        'lead_provider' => $leads_send['lead_provider'],
//                                        'admin_email' => $leads_send['admin_email'],
//                                        'assigned_date' => $leads_send['assigned_date'],
//                                        'email' => $leads_send['email'],
//                                        'contact' => $leads_send['contact'],
//                                        'status' => "unassigned",
//                                        'classification' => "Sales",
//                                        'sender_first_name' => $first_name,
//                                        'sender_last_name' => $last_name,
//                                        'company' => null,
//                                        'address' => $leads_send['address'],
//                                        'city' => $leads_send['city'],
//                                        'state' => $leads_send['state'],
//                                        'zip' => $leads_send['zip'],
//                                        'assigned_user_id' => null,
//                                        'lead_status' => $leads_send['lead_status'],
//                                        'year' =>  $leads_send['year'],
//                                        'make' =>  $leads_send['make'],
//                                        'model' =>  $leads_send['model'],
//                                        'vin' =>  $leads_send['vin']
//                                    ]);
                            // $insert_lead = DB::table('lead_bulk')->insert($arr);
//                                    toastr()->success('CSV Add Successfully');
//                                    return redirect()->route('import_bulk_leads_view');
                        }
                    }
                }
            }
        }
    }

    public function failed()
    {
        // Called when the job is failing...
    }
}
