<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\LeadAppointment;
use App\Companyinfo;
use Illuminate\Support\Facades\Cache;
use DB;

class UnassignedLeadsController extends BaseController
{

    public function unassignedleads(Request $request)
    {

        $user = User::where('id', auth()->user()->id)->with('companyinfo')->first();

        if ($user->usertype_id == 2) {
            $query = Lead::with('leadInventory')
                                    ->select('leads.id', 'leads.sender_first_name as lead_first_name', 'leads.sender_last_name as lead_last_name', 'leads.status', 'leads.assigned_user_id', 'leads.lead_provider', 'leads.lead_type_status' , 'leads.created_at', 'leads.updated_at', 'leads.chat_filter', 'agents.first_name as assign_first_name', 'agents.last_name as assign_last_name', 'leads.contact as leadnumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
                                    ->where('admin_email', $user->email)
                                    ->where('leads.assigned_user_id',null)
                                    ->where('leads.status','unassigned')
                                    ->leftjoin('users', 'leads.admin_email', 'users.email')
                                    ->leftjoin('users as agents', 'agents.id', 'leads.assigned_user_id')
                                    ->orderby('id', 'desc');
                                    
            if($request->search != null){
	            $query->where(DB::raw('CONCAT_WS(" ", leads.sender_first_name, leads.sender_last_name)'), 'like','%' . $request->search . '%');
	        }
	        
            if ($request->lead_status != null) {
                $query->where("leads.lead_status", $request->lead_status);
            }

            if ($request->lead_type_status != null) {
                $query->where("leads.lead_type_status", $request->lead_type_status);
            }

            if ($request->lead_source != null) {
                $query->where("leads.lead_provider", $request->lead_source);
            }

            if (!empty($startdate) || !empty($enddate)) {
                $query->WhereDate('leads.created_at',">=",date("Y-m-d", strtotime($startdate)))->WhereDate('leads.created_at',"<=",date("Y-m-d", strtotime($enddate)));
            }

            $unasign_leads = $query->paginate(10);
            
            $total_leads_provider = Lead::select('leads.lead_provider')
                                    ->selectRaw('count(*) as count, lead_provider')
                                    ->where('leads.lead_provider','!=','')
                                    ->groupBy('lead_provider')
                                    ->where('admin_email',$user->email)
                                    ->having('count','>=','1')
                                    ->orderby('lead_provider','asc')
                                    ->get()->toArray();
                                    
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
                                    ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                                    ->where('parent_user_id',$user->id)
                                    ->where('users.approval','approve')
                                    ->where('users.is_deleted',0)
                                    ->orderby('id','desc')
                                    ->get();
                
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);
    
            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];
    
                array_push($agents,$data);
    
            }
            
            
        } elseif ($user->usertype_id == 4) {

            $getUser = User::where('id', $user->id)->first();
            $admin = User::where('id', $getUser->parent_user_id)->first();

            $query = Lead::with('leadInventory')
                                    ->select('leads.id', 'leads.sender_first_name as lead_first_name', 'leads.sender_last_name as lead_last_name','leads.status', 'leads.assigned_user_id', 'leads.lead_provider','leads.lead_type_status' ,'leads.created_at', 'leads.updated_at', 'leads.chat_filter', 'agents.first_name as assign_first_name', 'agents.last_name as assign_last_name', 'leads.contact as leadnumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
                                    ->where('admin_email', $admin->email)
                                    ->where('leads.assigned_user_id',null)
                                    ->where('leads.status','unassigned')
                                    ->leftjoin('users', 'leads.admin_email', 'users.email')
                                    ->leftjoin('users as agents', 'agents.id', 'leads.assigned_user_id')
                                    ->orderby('id', 'desc');
                                    
            
            if($request->search != null){
	            $query->where(DB::raw('CONCAT_WS(" ", leads.sender_first_name, leads.sender_last_name)'), 'like','%' . $request->search . '%');
	        }
	        
            if ($request->lead_status != null) {
                $query->where("leads.lead_status", $request->lead_status);
            }

            if ($request->lead_type_status != null) {
                $query->where("leads.lead_type_status", $request->lead_type_status);
            }

            if ($request->lead_source != null) {
                $query->where("leads.lead_provider", $request->lead_source);
            }

            if (!empty($startdate) || !empty($enddate)) {
                $query->WhereDate('leads.created_at',">=",date("Y-m-d", strtotime($startdate)))->WhereDate('leads.created_at',"<=",date("Y-m-d", strtotime($enddate)));
            }
            
            $unasign_leads  = $query->paginate(10);
            
            
            $total_leads_provider = Lead::select('leads.lead_provider')
                                            ->selectRaw('count(*) as count, lead_provider')
                                            ->where('leads.lead_provider','!=','')
                                            ->groupBy('lead_provider')
                                            ->where('admin_email',$admin->email)
                                            ->having('count','>=','1')
                                            ->orderby('lead_provider','asc')
                                            ->get()->toArray();
                                            
        }
        
        
        //   return $this->sendResponse($data, 'leads');

        return response()->json([
            'success'  => true,
            'leadsData' => $unasign_leads,
            'agents' => [],
            'lead_providers' => $total_leads_provider,
            'message' => 'Unassigned Leads Data',
        ]);
    }

    public function filterUnassignedLeads(Request $request)
    {
        
        $startdate = $request->start_date;
        $enddate = $request->end_date;


        $user = User::where('id', auth()->user()->id)->with('companyinfo')->first();


        if ($user->usertype_id == 2) {

            $query = new Lead();

            $query      =    $query->with('leadInventory')->select('leads.id', 'leads.sender_first_name as lead_first_name', 'leads.sender_last_name as lead_last_name','leads.status', 'leads.assigned_user_id', 'leads.lead_provider','leads.lead_type_status' ,'leads.created_at', 'leads.updated_at', 'leads.chat_filter','leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
                                    ->leftjoin('users', 'leads.admin_email', 'users.email')
                                    ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                    ->where('leads.assigned_user_id',null)
                                    ->where('leads.status', 'unassigned')
                                    ->where("leads.admin_email", $user->email)
                                    ->orderby('leads.updated_at', 'desc');
            
            if($request->search != null){
	            $query->where(DB::raw('CONCAT_WS(" ", leads.sender_first_name, leads.sender_last_name)'), 'like','%' . $request->search . '%');
	        }
	        
	        if($request->agent_id != null){
	            $query->where("leads.assigned_user_id" ,$request->agent_id);
	        }
            
            if ($request->lead_status != null) {
                $query->where("leads.lead_status", $request->lead_status);
            }

            if ($request->lead_type_status != null) {
                $query->where("leads.lead_type_status", $request->lead_type_status);
            }

            if ($request->lead_source != null) {
                $query->where("leads.lead_provider", $request->lead_source);
            }

            if (!empty($startdate) || !empty($enddate)) {
                $query->WhereDate('leads.created_at',">=",date("Y-m-d", strtotime($startdate)))->WhereDate('leads.created_at',"<=",date("Y-m-d", strtotime($enddate)));
            }

            $leads = $query->paginate(10);

            $leadCount = number_format($leads->total()) . " results found.";

        } elseif ($user->usertype_id == 4) {
            $getUser = DB::table('users')->where('id', $user->id)->first();
            $user = DB::table('users')->where('id', $getUser->parent_user_id)->first();
            $admin_email = $user->email;

            $query = new Lead();

            $query      =   $query->with('leadInventory')->select('leads.id', 'leads.sender_first_name as lead_first_name', 'leads.sender_last_name as lead_last_name','leads.status', 'leads.assigned_user_id', 'leads.lead_provider','leads.lead_type_status' ,'leads.created_at', 'leads.updated_at', 'leads.chat_filter', 'leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
                                    ->leftjoin('users', 'leads.admin_email', 'users.email')
                                    ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                    ->where('leads.assigned_user_id',null)
                                    ->where('leads.status', 'unassigned')
                                    ->where("leads.admin_email", $admin_email)
                                    ->orderby('leads.updated_at', 'desc');
            
            if($request->search != null){
	            $query->where(DB::raw('CONCAT_WS(" ", leads.sender_first_name, leads.sender_last_name)'), 'like','%' . $request->search . '%');
	        }
	        
	        if($request->agent_id != null){
	            $query->where("leads.assigned_user_id" ,$request->agent_id);
	        }
            
            if ($request->lead_status != null) {
                $query->where("leads.lead_status", $request->lead_status);
            }
            

            if ($request->lead_type_status != null) {
                $query->where("leads.lead_type_status", $request->lead_type_status);
            }

            if ($request->lead_source != null) {
                $query->where("leads.lead_provider", $request->lead_source);
            }

            if (!empty($startdate) || !empty($enddate)) {
                $query->WhereDate('leads.created_at',">=",date("Y-m-d", strtotime($startdate)))->WhereDate('leads.created_at',"<=",date("Y-m-d", strtotime($enddate)));
            }

            $leads = $query->paginate(10);

            $leadCount = number_format($leads->total()) . " results found.";

        }
        
        return response()->json([
            'success'  => true,
            'unassignleadList' => $leads,
            'count' => $leadCount,
            'message' => 'Filtered Unassigned Leads Data',
        ]);
        
        // return $this->sendResponse([
        //     'unassignleadList' => $leads,
        //     'count' => $leadCount
        // ], 'unassignleadList');

    }

}