<?php

namespace App\Http\Controllers\Api;

use App\Models\ApiToken;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\User;
use Carbon\Carbon;
use Hash;
use App\Lead;
use DB;
use App\Forgotpassword;
use App\Companyinfo;
use App\LeadAppointment;
Use App\Userimportlimit;
Use App\Userreportingdetail;
use App\NinjaAssign;
use Validator;
use Illuminate\Support\Facades\Cache;

class AuthController extends BaseController{

    public function __construct(){
       
    }



    /**

     * Login user and create token

     *

     * @param  [string] email

     * @param  [string] password

     * @param  [boolean] remember_me

     * @return [string] access_token

     * @return [string] token_type

     * @return [string] expires_at

     */

    public function login(Request $request)
    {
        
        $validator = Validator::make($request->all(), [
            'email' => 'required|string|email',

            'password' => 'required|string',

            'remember_me' => 'boolean',
            
            'device_token' => 'required|string',
        ]);
        if ($validator->fails()) {
            return $this->sendError($validator->messages()->all());
        }

        $arr = [

            'email' => $request->email,

            'password' => sha1($request->password),

        ];
        $user = User::where($arr)->first(); 
        if($user != null) {
            if ($user->approval == 'approve'){
                
                Auth::user($user);
                DB::table('users')->where('email',$request->email)->update(['device_token' => $request->device_token]);
                if($user->usertype_id == 2){
                    $companyinfo = Companyinfo::where('user_id',$user->id)->first(['name','phone_number']);
                    $userData = [
                        'id' => $user->id,
                        'first_name' => $user->first_name,
                        'last_name' => $user->last_name,
                        'admin_email' => $user->email,
                        'phone_number' => $user->phone_number,
                        'usertype_id' => $user->usertype_id,
                    ];
                    $companyData = [
                        'company_name' => $companyinfo->name,
                        'company_number' => $companyinfo->phone_number,
                    ];

                }
                elseif($user->usertype_id == 4){
                    $adminId = $user->parent_user_id;
                    $adminEmail = User::where('id', $adminId)->value('email');
                    $adminCompany = Companyinfo::where('user_id', $adminId)->first(['name','phone_number']);

                    $userData = [
                        'id' => $user->id,
                        'first_name' => $user->first_name,
                        'last_name' => $user->last_name,
                        'admin_email' => $adminEmail,
                        'phone_number' => $user->phone_number,
                        'usertype_id' => $user->usertype_id,
                    ];
                    $companyData = [
                        'company_name' => $adminCompany->name,
                        'company_number' => $adminCompany->phone_number,
                    ];
                }

                $tokenResult = $user->createToken('Personal Access Token');
                $token = $tokenResult->token;
                $token->expires_at = Carbon::now()->addDays(5);
                $token->save();
                DB::table('oauth_api_token')->insert(['api_token_id'=>$token->id,'user_id'=>$user->id,'access_token'=>$tokenResult->accessToken]);
                $data = [
                    'user' => $userData,
                    'company' => $companyData,
                    'access_token' => $tokenResult->accessToken,
                    'token_type' => 'Bearer',
                    'expires_at' => Carbon::parse(
                        $tokenResult->token->expires_at
                    )->toDateTimeString(),
                ];
                return $this->sendResponse($data,'Log in successfully!.');
            }
            else{
                return $this->sendError('Your account has been locked!.');
            }
        }
        else{
            return response()->json([
                'success'  => false,
                'message' => 'Invalid credentials, Please try again!.',
            ],403);
        }
    }

    public function longLife(Request $request){
        // return $request;
        $validator = Validator::make($request->all(), [
            'device_name' => 'required|string',
            'device_plateform' => 'required|string',
            'device_token' => 'required|string',
        ]);
        if ($validator->fails()) {
            return $this->sendError($validator->messages()->all());
        }
        $user = DB::table('oauth_api_token')->where('access_token',$request->bearerToken())->first();
        
        
        if ($user){
            $time = DB::table('oauth_access_tokens')->where('id',$user->api_token_id)->where('user_id',$user->user_id)->whereDate('expires_at', '<', Carbon::now()->format('Y-m-d H:i:s'))->first();
            // dd($time);
            if ($time){
                
                DB::table('oauth_access_tokens')->where('id',$user->api_token_id)->where('user_id',$user->user_id)->where('expires_at', '<', Carbon::now())->delete();
                DB::table('oauth_api_token')->where('access_token',$request->bearerToken())->update(['status'=>'Token expired']);
                Cache::flush();
                return $this->sendError('Token has been expired please login to continue');
            }
            else{
                
                DB::table('oauth_access_tokens')->where('id',$user->api_token_id)->where('user_id',$user->user_id)->where('expires_at', '<', Carbon::now())->delete();
                $user1 = User::where('id',$user->user_id)->first();
                $tokenResult = $user1->createToken('Personal Access Token');
                $token = $tokenResult->token;
                $token->expires_at = Carbon::now()->addDays(5);
                $token->save();
                $device_name = $request->device_name;
                $device_platform = $request->device_plateform;
                DB::table('oauth_api_token')->where('id',$user->id)->update(['api_token_id'=>$token->id,'access_token'=>$tokenResult->accessToken,'status'=>'Token regenerated','device_name'=>$device_name,'device_plateform'=>$device_platform,'update_at'=>date('Y-m-d H:i:s')]);
                $data = [
                    'access_token' => $tokenResult->accessToken,
                    'token_type' => 'Bearer',
                    'expires_at' => Carbon::parse(
                        $tokenResult->token->expires_at
                    )->toDateTimeString(),    
                ];
                return $this->sendResponse($data,'Token regenerated successfully!.');
            }
        }
        return $this->sendError('Token has been expired please login to continue');
    }


    /**

     * Logout user (Revoke the token)

     *

     * @return [string] message

     */

    public function logout(Request $request)
    {
//        $ab = \App\Lead::where('id',70531)->update(['chat_filter'=>1]);
//        dd($ab);
        $request->user()->token()->revoke();
        $request->user()->token()->delete();
        DB::table('users')->where('email',$request->email)->update(['device_token' => null]);
        DB::table('oauth_api_token')->where('api_token_id',$request->user()->token()->id)->update(['status'=>'logout']);
        return $this->sendResponse([],'Successfully logged out');
    }

    /**

     * Get the authenticated User

     *

     * @return [json] user object

     */

    public function getuser()
    {
        return $this->sendResponse(auth::user(),'User Detail');

    }


    public function forgotPasswordPost(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required',
        ]);
        if ($validator->fails()) {
            return $this->sendError($validator->messages()->all()[0]);
        }
        
        $check_user = User::where('email',$request->email)->first();

        if($check_user)
        {
            $arr = [
                'user_id' => $check_user->id,
                'encrypt_id' => sha1($check_user->id),
                'status' => 'pending',
            ];

            $insert = Forgotpassword::insert($arr);

            if($insert)
            {
                return $this->sendResponse(['user_id' => $check_user->id],'forgot_password');
            }
        }
        else{
            return $this->sendError('The email you entered does not exist');
        }
    }


    public function resetPasswordPost(Request $request){
        
        $validator = Validator::make($request->all(), [
            'otp' => 'required',
            'userid' => 'required',
            'password' => 'required',
        ]);
        if ($validator->fails()) {
            return $this->sendError($validator->messages()->all()[0]);
        }
        
        $otp = $request->otp;

        $check_forgot = Forgotpassword::where('user_id',$request->userid)->where('status','pending')->first();

        if($check_forgot != null)
        {
            $update = User::where('id',$request->userid)->update(['password' => sha1($request->password)]);

            $update_forgot = Forgotpassword::where('id',$check_forgot->id)->update(['status' => 'set']);

            return $this->sendResponse([],'Your password has been reset successfully!');
        }
        else{
            return $this->sendError('Something Went Wrong');
        }

    }

    

}

