<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Supersim\V1;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class UsageRecordOptions {
    /**
     * @param string $sim SID of a Sim resource. Only show UsageRecords
     *                    representing usage incurred by this Super SIM.
     * @param string $granularity Time-based grouping that UsageRecords should be
     *                            aggregated by. Can be: `hour`, `day`, or `all`.
     *                            Default is `all`.
     * @param \DateTime $startTime Only include usage that occurred at or after
     *                             this time.
     * @param \DateTime $endTime Only include usage that occurred before this time.
     * @return ReadUsageRecordOptions Options builder
     */
    public static function read(string $sim = Values::NONE, string $granularity = Values::NONE, \DateTime $startTime = Values::NONE, \DateTime $endTime = Values::NONE): ReadUsageRecordOptions {
        return new ReadUsageRecordOptions($sim, $granularity, $startTime, $endTime);
    }
}

class ReadUsageRecordOptions extends Options {
    /**
     * @param string $sim SID of a Sim resource. Only show UsageRecords
     *                    representing usage incurred by this Super SIM.
     * @param string $granularity Time-based grouping that UsageRecords should be
     *                            aggregated by. Can be: `hour`, `day`, or `all`.
     *                            Default is `all`.
     * @param \DateTime $startTime Only include usage that occurred at or after
     *                             this time.
     * @param \DateTime $endTime Only include usage that occurred before this time.
     */
    public function __construct(string $sim = Values::NONE, string $granularity = Values::NONE, \DateTime $startTime = Values::NONE, \DateTime $endTime = Values::NONE) {
        $this->options['sim'] = $sim;
        $this->options['granularity'] = $granularity;
        $this->options['startTime'] = $startTime;
        $this->options['endTime'] = $endTime;
    }

    /**
     * SID of a Sim resource. Only show UsageRecords representing usage incurred by this Super SIM.
     *
     * @param string $sim SID of a Sim resource. Only show UsageRecords
     *                    representing usage incurred by this Super SIM.
     * @return $this Fluent Builder
     */
    public function setSim(string $sim): self {
        $this->options['sim'] = $sim;
        return $this;
    }

    /**
     * Time-based grouping that UsageRecords should be aggregated by. Can be: `hour`, `day`, or `all`. Default is `all`. `all` returns one UsageRecord that describes the usage for the entire period.
     *
     * @param string $granularity Time-based grouping that UsageRecords should be
     *                            aggregated by. Can be: `hour`, `day`, or `all`.
     *                            Default is `all`.
     * @return $this Fluent Builder
     */
    public function setGranularity(string $granularity): self {
        $this->options['granularity'] = $granularity;
        return $this;
    }

    /**
     * Only include usage that occurred at or after this time, specified in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format. Default is one month before the `end_time`.
     *
     * @param \DateTime $startTime Only include usage that occurred at or after
     *                             this time.
     * @return $this Fluent Builder
     */
    public function setStartTime(\DateTime $startTime): self {
        $this->options['startTime'] = $startTime;
        return $this;
    }

    /**
     * Only include usage that occurred before this time, specified in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format. Default is the current time.
     *
     * @param \DateTime $endTime Only include usage that occurred before this time.
     * @return $this Fluent Builder
     */
    public function setEndTime(\DateTime $endTime): self {
        $this->options['endTime'] = $endTime;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = [];
        foreach ($this->options as $key => $value) {
            if ($value !== Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Supersim.V1.ReadUsageRecordOptions ' . \implode(' ', $options) . ']';
    }
}