<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Studio\V2\Flow;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 */
abstract class ExecutionOptions {
    /**
     * @param \DateTime $dateCreatedFrom The date_created_from
     * @param \DateTime $dateCreatedTo The date_created_to
     * @return ReadExecutionOptions Options builder
     */
    public static function read(\DateTime $dateCreatedFrom = Values::NONE, \DateTime $dateCreatedTo = Values::NONE): ReadExecutionOptions {
        return new ReadExecutionOptions($dateCreatedFrom, $dateCreatedTo);
    }

    /**
     * @param array $parameters The parameters
     * @return CreateExecutionOptions Options builder
     */
    public static function create(array $parameters = Values::NONE): CreateExecutionOptions {
        return new CreateExecutionOptions($parameters);
    }
}

class ReadExecutionOptions extends Options {
    /**
     * @param \DateTime $dateCreatedFrom The date_created_from
     * @param \DateTime $dateCreatedTo The date_created_to
     */
    public function __construct(\DateTime $dateCreatedFrom = Values::NONE, \DateTime $dateCreatedTo = Values::NONE) {
        $this->options['dateCreatedFrom'] = $dateCreatedFrom;
        $this->options['dateCreatedTo'] = $dateCreatedTo;
    }

    /**
     * The date_created_from
     *
     * @param \DateTime $dateCreatedFrom The date_created_from
     * @return $this Fluent Builder
     */
    public function setDateCreatedFrom(\DateTime $dateCreatedFrom): self {
        $this->options['dateCreatedFrom'] = $dateCreatedFrom;
        return $this;
    }

    /**
     * The date_created_to
     *
     * @param \DateTime $dateCreatedTo The date_created_to
     * @return $this Fluent Builder
     */
    public function setDateCreatedTo(\DateTime $dateCreatedTo): self {
        $this->options['dateCreatedTo'] = $dateCreatedTo;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = [];
        foreach ($this->options as $key => $value) {
            if ($value !== Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Studio.V2.ReadExecutionOptions ' . \implode(' ', $options) . ']';
    }
}

class CreateExecutionOptions extends Options {
    /**
     * @param array $parameters The parameters
     */
    public function __construct(array $parameters = Values::NONE) {
        $this->options['parameters'] = $parameters;
    }

    /**
     * The parameters
     *
     * @param array $parameters The parameters
     * @return $this Fluent Builder
     */
    public function setParameters(array $parameters): self {
        $this->options['parameters'] = $parameters;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $options = [];
        foreach ($this->options as $key => $value) {
            if ($value !== Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Studio.V2.CreateExecutionOptions ' . \implode(' ', $options) . ']';
    }
}