<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms\Business\Insights;

use Twilio\ListResource;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class ImpressionsRateList extends ListResource {
    /**
     * Construct the ImpressionsRateList
     *
     * @param Version $version Version that contains the resource
     * @param string $businessSid A string that uniquely identifies this Business.
     */
    public function __construct(Version $version, string $businessSid) {
        parent::__construct($version);

        // Path Solution
        $this->solution = ['businessSid' => $businessSid, ];
    }

    /**
     * Constructs a ImpressionsRateContext
     */
    public function getContext(): ImpressionsRateContext {
        return new ImpressionsRateContext($this->version, $this->solution['businessSid']);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Preview.TrustedComms.ImpressionsRateList]';
    }
}