# Contributing
Contributions are **welcome** and will be fully **credited**. 

Please read the following contribution guide before creating an issue or a pull request.

## Code Style
- This project follows the PSR-2 code style, please refer to the
<a href="https://www.php-fig.org/psr/psr-2/" target="_blank">PSR-2 documentation</a> for more information.
- This project uses **PHPDoc** for DocBlocking.

## Autoloading
- This project follows the PSR-4 autoloading standards, please refer to the
<a href="https://www.php-fig.org/psr/psr-4/" target="_blank">PSR-4 documentation</a> for more information.

## Pull Request Best Practices
- Create an issue: It is considered a best practice to start a new issue containing the subject of the suggested change,
either it is a bug fix, an optimization or a new feature. Sometimes there may be things that you might not have noticed
or are not clear enough to you, so we strongly recommend you to start a new issue before risking to waste your time on
something that may have been added already
- Create a fork of this project: This will make your own version to work on
- Create a new branch for the code you want to contribute (e.g. `new-feature`)
- Make sure all the existing tests pass, and add new tests for the new code if relevant
- Push your code to your feature branch
- Make a new pull request: As suggested in the first point of this guide, it is strongly recommended to create a new
issue first in all cases, if you have followed the mentioned advice, you can include the issue number in the PR message

## Licensing
All contributions to this project are licensed under the MIT License.
