<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Queue\SerializesModels;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use DB;

class ProcessPodcast implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;
    public $data;
    public $manual_text;
    public $get_admin_email;
    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct($data,$manual_text,$get_admin_email)
    {
        $this->data=$data;
        $this->manual_text=$manual_text;
        $this->get_admin_email=$get_admin_email;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        if ($this->data) {
            $arr = [];
            for ($i=0; $i < $this->data[0]->count() ; $i++) {
                if($i != 0){
                    $source = "";
                    if($this->data[0][$i][0] == null){
                        $source = "Unknown";
                    }
                    else{
                        $source = $this->data[0][$i][0];
                    }

                    $lat = null;
                    $lng = null;

                    if($this->data[0][$i][8] != null)
                    {
                        $zipcode = $this->data[0][$i][8];
                        $url = "https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($zipcode)."&sensor=false&key=AIzaSyDsft6f2XKBV0G42r8fw7PAo-DETqq9iR0";
                        $details=file_get_contents($url);
                        $result = json_decode($details,true);

                        if (isset($result['status']) && ($result['status'] == 'OK'))
                        {
                            $lat = $result['results'][0]['geometry']['location']['lat'];
                            $lng = $result['results'][0]['geometry']['location']['lng'];
                        }
                    }

                    $leads = [
                        'title' => null,
                        'lead_provider' => $source,
                        'admin_email' => $this->get_admin_email,
                        'assigned_date' => date('d-m-Y'),
                        'dob' =>$this->data[0][$i][3],
                        'email' =>$this->data[0][$i][4],
                        'contact' =>$this->data[0][$i][5],
                        'home_contact' =>$this->data[0][$i][6],
                        'work_contact' => $this->data[0][$i][7],
                        'deal_status' => $this->data[0][$i][8],
                        'deal_start_date' =>$this->data[0][$i][9],
                        'status' => "unassigned",
                        'classification' => "Sales",
                        'sender_first_name' => $this->data[0][$i][1],
                        'sender_last_name' => $this->data[0][$i][2],
                        'company' => null,
                        'address' => $this->data[0][$i][10],
                        'city' => $this->data[0][$i][11],
                        'state' => $this->data[0][$i][12],
                        'zip' => $this->data[0][$i][13],
                        'lat' => $lat,
                        'lng' => $lng,
                        'assigned_user_id' => null,
                        'lead_status' => "Active-Fresh",
                        'robo_text' => $this->manual_text,
                        'bank_name' => $this->data[0][$i][14],
                        'loan_start_date' => $this->data[0][$i][15],
                        'loan_end_date' => $this->data[0][$i][16],
                        'drivers_license' => $this->data[0][$i][17],
                        'year' => $this->data[0][$i][18],
                        'make' => $this->data[0][$i][19],
                        'model' => $this->data[0][$i][20],
                        'vin' => $this->data[0][$i][21],
                        'created_at' => $this->data[0][$i][22]
                    ];
                    array_push($arr, $leads);

                }
            }


            if (!empty($arr)) {

                $check = [];

                foreach ($arr as $value) {
                    $check[] = $value['admin_email'];
                }

                $leadarr = [];
                $check = array_unique($check);

                foreach ($arr as $leads_send) {
                    $get_admin_contact = DB::table('company_info')
                        ->select('company_info.*','users.email as admin','users.first_name as admin_name')
                        ->leftjoin('users','company_info.user_id','users.id')
                        ->where('users.email',$leads_send['admin_email'])
                        ->first();

                    if ($get_admin_contact != null) {

                        if(empty($leads_send['email']))
                        {
                            $check_email = null;
                            $leads_send['email'] = null;
                        }else
                        {
                            $check_email = DB::table('leads')->where('email',$leads_send['email'])->where('admin_email',$this->get_admin_email)->first();
                        }

                        if(empty($leads_send['contact']))
                        {
                            $check_phone = null;
                            $leads_send['contact'] = null;
                        }else
                        {
                            $replace = array("_", "-", " ", ",", ".", "+", "`", "'", '"','(',')');
                            $lead_contact_numbers = str_replace($replace, "", $leads_send['contact']);
                            $lead_contact_number = preg_replace('/[^0-9\-]/', '', $lead_contact_numbers);
                            $numlength = strlen((string)$lead_contact_number);

                            if ($numlength == 11) {
                                $leads_send['contact'] = '+' . $lead_contact_number;
                            } else {
                                $leads_send['contact'] = '+1' . $lead_contact_number;
                            }

                            $check_phone = DB::table('leads')->where('contact',$leads_send['contact'])->where('admin_email',$this->get_admin_email)->first();
                        }

                        if($check_phone == null)
                        {
                            if($check_email == null)
                            {
                                $sender_first_name = "Unknown";
                                $sender_last_name = "Unknown";

                                if(!empty($leads_send['sender_first_name']))
                                {
                                    $sender_first_name = $leads_send['sender_first_name'];
                                }

                                if(!empty($leads_send['sender_last_name']))
                                {
                                    $sender_last_name = $leads_send['sender_last_name'];
                                }

                                $created_at = date("Y-m-d H:i:s");

                                if(!empty($leads_send['created_at']))
                                {
                                    $created_at_o = ($leads_send['created_at'] - 25569) * 86400;
                                    $created_at = gmdate("Y-m-d H:i:s", $created_at_o);
                                }
                                $insert_lead = DB::table('leads_testing')->insertGetId([
                                    'title' => null,
                                    'lead_provider' => $leads_send['lead_provider'],
                                    'admin_email' => $leads_send['admin_email'],
                                    'assigned_date' => $leads_send['assigned_date'],
                                    'email' => $leads_send['email'],
                                    'contact' => $leads_send['contact'],
                                    'status' => "unassigned",
                                    'classification' => "Sales",
                                    'sender_first_name' => $sender_first_name,
                                    'sender_last_name' => $sender_last_name,
                                    'company' => null,
                                    'address' => $leads_send['address'],
                                    'city' => $leads_send['city'],
                                    'state' => $leads_send['state'],
                                    'zip' => $leads_send['zip'],
                                    'lat' => $leads_send['lat'],
                                    'lng' => $leads_send['lng'],
                                    'assigned_user_id' => null,
                                    'lead_status' => $leads_send['lead_status'],
                                    'created_at' => $created_at,
                                    'updated_at' => $created_at
                                ]);
                                echo "done";
                            }
                        }
                    }
                }
            }
        }

    }

    public function failed()
    {
        // Called when the job is failing...
    }
}
