<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\Companyinfo;
use App\Companyextranumber;
use App\Carmake;
use App\Carmodel;
use Validator;
use App\Leadinventoryinfo;
use App\Notification;
use Illuminate\Support\Facades\Cache;



class ManualleadsController extends BaseController{

    public function manualLeadView(){

                $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

                if($user->usertype_id == 2){

                    $agents = User::select('users.id','users.first_name','users.last_name')
                        ->where('parent_user_id',$user->id)
                        ->get();
                    

                    $total_leads_provider = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as count, lead_provider')
                        ->where('leads.lead_provider','!=','')
                        ->groupBy('lead_provider')
                        ->where('admin_email',$user->email)
                        ->whereNotIn('lead_provider', ['Referal', 'Walk In'])
                        ->having('count','>=','1')
                        ->orderby('count','desc')
                        ->get();
                    $makers = Carmake::select('id','name')->get();

                    return $this->sendResponse([
                        'total_lead_provider' => $total_leads_provider ,
                        'admin_agents' => $agents,
                        'makers' => $makers
                    ],'manual_lead_view');

                }
                elseif($user->usertype_id == 4){

                    $agents = null;

                    $getUser = User::where('id', $user->id)->first();
                    $getAdmin = User::where('id', $getUser->parent_user_id)->first();

                    $total_leads_provider = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as count, lead_provider')
                        ->where('leads.lead_provider','!=','')
                        ->groupBy('lead_provider')
                        ->where('admin_email',$getAdmin->email)
                        ->having('count','>=','1')
                        ->orderby('count','desc')
                        ->get();
                    $makers = Carmake::select('id','name')->get();

                    return $this->sendResponse([
                        'total_lead_provider' => $total_leads_provider ,
                        'admin_agents' => $agents,
                        'makers' => $makers
                    ],'manual_lead_view');
                }

    }

    public function carModels(Request $request){

            $id = $request->id;

            if ($id != null ){

                $modals =  Carmodel::where('make_id',$id)->get(['id','name']);

                return $this->sendResponse([
                    'models' => $modals ,
                ],'models');

            }
            else{
                return $this->sendResponse([
                    'models' => 'Something Went Wrong' ,
                ],'models');
            }

    }

    public function manualLeadPost(Request $request)
    {
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        
//        $ab = $request->contact;
//        $ab1 = str_replace('(', '', $ab);
//        $ab1 = str_replace(')', '', $ab1);
//        $ab1 = str_replace('-', '', $ab1);
//        $phone_number = str_replace(' ', '', $ab1);



        $validator = Validator::make($request->all(), [
            'contact' => 'required|unique:leads,contact|min:10|max:15',
        ]);
        if ($validator->fails()) {

            return response()->json([
                'success' => false,
                'message'=> 'Invalid Phone Number',
            ],201);
        }
        $phone_number = substr_replace($request->contact,'+1',0,0);
        $lat = null;
        $lng = null;


//        if ($request->zip != null) {
//            $zipcode = $request->zip;
//            $url = "https://maps.googleapis.com/maps/api/geocode/json?address=" . urlencode($zipcode) . "&sensor=false&key=AIzaSyDsft6f2XKBV0G42r8fw7PAo-DETqq9iR0";
//            $details = file_get_contents($url);
//            $result = json_decode($details, true);
//
//            if (isset($result['status']) && ($result['status'] == 'OK')) {
//                $lat = $result['results'][0]['geometry']['location']['lat'];
//                $lng = $result['results'][0]['geometry']['location']['lng'];
//            }
//        }


        $check_email = null;
        $check_number = null;
        if ($user->usertype_id == 2) {
            if (empty($request->email)) {
                $check_email = null;
                $request->email = null;
            } else {
                $check_email = Lead::where('email', $request->email)->where('admin_email', $user->email)->first();
            }

            if (empty($request->contact)) {
                $check_number = null;
            } else {
                $check_number = Lead::where('contact', $phone_number)->where('admin_email', $user->email)->first();
            }
        }
        else {
            $check_admin = User::select('users.*', 'admin.id as adminid', 'admin.email as adminemail')
                ->leftjoin('users as admin', 'users.parent_user_id', 'admin.id')
                ->where('users.id', $user->id)
                ->first();

            if (empty($request->email)) {
                $check_email = null;
            } else {
                $check_email = Lead::where('email', $request->email)->where('admin_email', $check_admin->adminemail)->first();
            }

            if (empty($request->contact)) {
                $check_number = null;
            } else {
                $check_number = Lead::where('contact', $phone_number)->where('admin_email', $check_admin->adminemail)->first();
            }
        }


        if ($check_email != null) {

            return response()->json([
                'success' => false,
                'message'=> 'Email already exist',
            ],201);
        }
        else {
            if ($check_number != null) {

                return response()->json([
                    'success' => false,
                    'message'=> 'Number already exist',
                ],201);

            } else {
                if ($user->usertype_id == 2) {
                    if ($request->assignagent == "null" || $request->assignagent == "") {
                        $arr = [
                            'created_by' => $user->id,
                            'lead_provider' => $request->leadprovider,
                            'admin_email' => $user->email,
                            'assigned_date' => date('d-m-Y'),
                            'email' => $request->email,
                            'contact' => $phone_number,
                            'status' => 'unassigned',
                            'classification' => $request->classification,
                            'sender_first_name' => $request->firstname,
                            'sender_last_name' => $request->lastname,
                            'company' => $request->company,
                            'address' => $request->address,
                            'city' => $request->city,
                            'state' => $request->state,
                            'zip' => $request->zip,
                            'lat' => $lat,
                            'lng' => $lng,
                            'assigned_user_id' => null,
                            'lead_status' => 'Active-Fresh',
                            'archive_status' => 1,
                        ];
                    } else {
                        $arr = [
                            'created_by' => $user->id,
                            'lead_provider' => $request->leadprovider,
                            'admin_email' => $user->email,
                            'assigned_date' => date('d-m-Y'),
                            'email' => $request->email,
                            'contact' => $phone_number,
                            'status' => 'assigned',
                            'classification' => $request->classification,
                            'sender_first_name' => $request->firstname,
                            'sender_last_name' => $request->lastname,
                            'company' => $request->company,
                            'address' => $request->address,
                            'city' => $request->city,
                            'state' => $request->state,
                            'zip' => $request->zip,
                            'lat' => $lat,
                            'lng' => $lng,
                            'assigned_user_id' => $request->assignagent,
                            'lead_status' => 'Active-Fresh',
                            'archive_status' => 1,
                        ];
                    }

                    $insert = Lead::insertGetId($arr);


                    Leadinventoryinfo::insert(['lead_id' => $insert,
                        'year' => $request->year,
                        'make' => $request->make,
                        'model' => $request->mod,
                        'vin' => $request->vin,
                    ]);

                    if ($insert) {

                        $super_admin = User::where('usertype_id', 1)
                            ->get();
                        foreach ($super_admin as $rows) {
                            $notearr = [
                                'lead_id' => $insert,
                                'notification_message' => 'New Lead',
                                'user_id' => $rows->id,
                                'type' => 'lead',
                                'status' => 'new'
                            ];

                            Notification::insert($notearr);
                        }

                        return response()->json([
                            'success' => true,
                            'manual_lead'=> 'Lead add successfully',
                        ],200);

                    } else {
                        return $this->sendResponse([
                            'success' => false,
                            'manual_lead'=> 'Something went wrong',
                        ],201);
                    }
                }
                else {
                    $check_admin = User::select('users.*', 'admin.id as adminid', 'admin.email as adminemail')
                        ->leftjoin('users as admin', 'users.parent_user_id', 'admin.id')
                        ->where('users.id', $user->id)
                        ->first();

                    if ($check_admin != null) {
                        $arr = [
                            'created_by' => $user->id,
                            'lead_provider' => $request->leadprovider,
                            'admin_email' => $check_admin->adminemail,
                            'assigned_date' => date('d-m-Y'),
                            'email' => $request->email,
                            'contact' => $phone_number,
                            'status' => 'assigned',
                            'classification' => $request->classification,
                            'sender_first_name' => $request->firstname,
                            'sender_last_name' => $request->lastname,
                            'company' => $request->company,
                            'address' => $request->address,
                            'city' => $request->city,
                            'state' => $request->state,
                            'zip' => $request->zip,
                            'assigned_user_id' => $check_admin->id,
                            'lead_status' => 'Active-Fresh',
                        ];

                        $insert = Lead::insertGetId($arr);


                        Leadinventoryinfo::insert(['lead_id' => $insert,
                            'year' => $request->year,
                            'make' => $request->make,
                            'model' => $request->mod,
                            'vin' => $request->vin,
                        ]);



                        if ($insert) {

                            $notearr = [
                                'manual_lead_id' => $insert,
                                'notification_message' => 'New Agent Request',
                                'user_id' => $check_admin->adminid,
                                'type' => 'lead',
                                'status' => 'new'
                            ];
                            $notification = Notification::insert($notearr);
                            return response()->json([
                                'success' => true,
                                'message'=> 'Lead insert successfully',
                            ],200);

                        }
                        else {
                            return response()->json([
                                'success' => false,
                                'message'=> 'Something went wrong',
                            ],201);
                        }

                    }
                }
            }
        }
    }
}