<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\Companyinfo;
use DB;
use Illuminate\Support\Facades\Cache;

class FilterleadsController extends BaseController
{
    public function filterleads(Request $request){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $startdate = date("Y-m-d", strtotime($request->start_date));
        $enddate = date("Y-m-d", strtotime($request->end_date));
        $time_from = $request->start_time;
        $time_to = $request->end_time;

    if($user->usertype_id == 2){
        $query = new Lead();

        $query = $query->select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.assigned_user_id','leads.lead_provider','leads.status','leads.created_at','leads.updated_at','leads.chat_filter','company_info.name as companyname','agents.first_name','agents.last_name')
            ->leftjoin('users','leads.admin_email','users.email')
            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
            ->leftjoin('company_info','company_info.user_id','users.id')
            ->where("leads.admin_email",$user->email)
            ->orderby('leads.updated_at', 'desc');

        if($request->agent != null){

            $query=$query->where("leads.assigned_user_id",$request->agent);

        }
        if($request->status != null){
            $query->where("leads.lead_status" ,$request->status);
        }
        if($request->lead_lead_status_type != null){
            $query->where("leads.lead_type_status",$request->lead_status_type);
        }
        if(!empty($time_from) || !empty($time_to))
        {
            $query->whereTime('leads.created_at','>=',date('H:i:s', strtotime($time_from)))
                ->whereTime('leads.created_at','<',date('H:i:s', strtotime("+1 minute",strtotime($time_to))));
        }
        if($request->lead_source != null){
            $query->where("leads.lead_provider",$request->lead_source);
        }
        //date filter
        if(!empty($startdate) || !empty($enddate))
        {
            $query->WhereDate('leads.created_at',">=",$startdate)->WhereDate('leads.created_at',"<=",$enddate);
        }

        $leads = $query->get();


        $leadCount = number_format($leads->count()). " results found.";
    }
    elseif ($user->usertype_id == 4){
        $query = new Lead();

        $getUser = DB::table('users')->where('id',$user->id)->first();
        $getAdmin = DB::table('users')->where('id',$getUser->parent_user_id)->first();

        $query = $query->select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.assigned_user_id','leads.lead_provider','leads.status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name')
            ->leftjoin('users','leads.admin_email','users.email')
            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
            ->where("leads.admin_email",$getAdmin->email)
            ->orderby('leads.updated_at', 'desc');

        if($request->lead_status != null){
            $query->where("leads.lead_status" ,$request->lead_status);
        }
        if($request->lead_status_type != null){
            $query->where("leads.lead_type_status",$request->lead_status_type);
        }
        if(!empty($time_from) || !empty($time_to))
        {
            $query->whereTime('leads.created_at','>=',date('H:i:s', strtotime($time_from)))
                ->whereTime('leads.created_at','<',date('H:i:s', strtotime("+1 minute",strtotime($time_to))));
        }
        if($request->lead_source != null){
            $query->where("leads.lead_provider",$request->lead_source);
        }
        //date filter
        if(!empty($startdate) || !empty($enddate))
        {
            $query->WhereDate('leads.created_at',">=",$startdate)->WhereDate('leads.created_at',"<=",$enddate);
        }


        $leads = $query->get();

        $leadCount = number_format($leads->count()). " results found.";
    }


        return $this->sendResponse([
            'leadList' => $leads,
            'count'=>$leadCount
        ],'leadslist');

    }
}