<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\Leadchat;
use App\Quickanswer;
use App\Leadpause;
use App\Leadcontact;
use App\Leadgeneralinfo;
use App\Leadinventoryinfo;
use App\LeadAppointment;
use App\Permissionallowed;
use App\Leademail;
use App\Voicemailblast;
use App\Notification;
use Illuminate\Support\Facades\Cache;
use Stichoza\GoogleTranslate\GoogleTranslate;
use DB;
class TextController extends BaseController{

    public function textChatView(){

                $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

                $leadCount = null;

                if($user->usertype_id == 1){
                    $leadList = DB::table('customer_leads')
                        ->whereDate('updated_at',date("Y-m-d"))
                        ->orderby('updated_at', 'desc');

                    $leads = $leadList->get();
                    $leadsTodayCount = $leadList->count();
                    $type = null;

                    return $this->sendResponse([
                        'leadlist' => $leads,
                    ],'lead-blast-add');

                }
                elseif($user->usertype_id == 2){
                    $dealers = User::select('users.id','users.first_name','users.last_name')
                        ->where('parent_user_id',$user->id)
                        ->where('approval','approve')
                        ->get();

                    $leadList = Lead::where('admin_email',$user->email)
                        ->select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                        ->leftjoin('users','leads.admin_email','users.email')
                        ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                        ->leftjoin('company_info','company_info.user_id','users.id')
                        ->where('archive_status',1)
                        ->whereDate('leads.updated_at',date("Y-m-d"))
                        ->orderby('updated_at', 'desc');

                    $leads = $leadList->get();
                    $leadsTodayCount = $leadList->count();

                    $total_leads_provider = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as c, lead_provider')
                        ->where('leads.lead_provider','!=','')
                        ->groupBy('lead_provider')
                        ->where('admin_email',$user->email)
                        ->having('c','>=','1')
                        ->orderby('leads.lead_provider','asc')
                        ->get();
                    $leadCount = null;


                    $data =[
                        'dealers' => $dealers,
                        'leadList' => $leads,
                        'providers' => $total_leads_provider,
                    ];
                    return $this->sendResponse($data,'leads');

                    }
                elseif($user->usertype_id == 4){

                    $getUser = User::where('id',$user->id)->first(['parent_user_id']);
                    $getAdmin = User::where('id',$getUser->parent_user_id)->first(['id','email']);

                    $assigned_column = "admin_email";
                    $total_leads = $getAdmin->email;

                    $check_permission = Permissionallowed::where('user_id', $getAdmin->id)->first(['lead_structure']);

                    if($check_permission != null)
                    {
                        if($check_permission->lead_structure == 'assigned')
                        {
                            $assigned_column = "assigned_user_id";
                            $assigned_agents = $user->id;
                        }
                        else
                        {
                            $assigned_column = "admin_email";
                            $assigned_agents =  $getAdmin->email;
                        }
                    }

                    $leadList = Lead::where($assigned_column,$assigned_agents)
                        ->select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname')
                        ->where('archive_status',1)
                        ->whereDate('leads.updated_at',date("Y-m-d"))
                        ->leftjoin('users','leads.admin_email','users.email')
                        ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                        ->leftjoin('company_info','company_info.user_id','users.id')
                        ->orderby('updated_at', 'desc');

                    $leads = $leadList->get();
                    $leadsTodayCount = $leadList->count();

                    $total_leads_provider = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as c, lead_provider')
                        ->where('leads.lead_provider','!=','')
                        ->groupBy('lead_provider')
                        ->where($assigned_column,$assigned_agents)
                        ->having('c','>=','1')
                        ->orderby('leads.lead_provider','asc')
                        ->get();
                    $leadCount = null;


                    $data =[
                        'leadList' => $leads,
                        'providers' => $total_leads_provider,
                    ];

                    return $this->sendResponse($data,'leads');

                   }

    }

    public function totalTextLeads(Request $request){
    
    $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
    
    if($user->usertype_id == 2){

        $leadList = Lead::with(['leadInventory'])
                            ->where('admin_email',$user->email)
                            ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
                            ->where('leads.archive_status',1)
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                            // ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                            ->orderby('leads.updated_at', 'desc');
        
        if($request->search != null){
            $leadList->where(DB::raw('CONCAT_WS(" ", leads.sender_first_name, leads.sender_last_name)'), 'like','%' . $request->search . '%');
        }
        
        if($request->agent_id != null && $request->agent_id != 0){
            $leadList->where("leads.assigned_user_id" ,$request->agent_id);
        }
        
        if ($request->lead_status != null && $request->lead_status != 0) {
            $leadList->where("leads.lead_status", $request->lead_status);
        }
        
        if ($request->lead_type_status != null && $request->lead_type_status != 0) {
            $leadList->where("leads.lead_type_status", $request->lead_type_status);
        }
        
        if ($request->lead_source != null && $request->lead_source != 0) {
            $leadList->where("leads.lead_provider", $request->lead_source);
        }
        
        if (!empty($request->start_date) && !empty($request->end_date)) {
            $leadList->WhereDate('leads.created_at',">=",date("Y-m-d", strtotime($request->start_date)))->WhereDate('leads.created_at',"<=",date("Y-m-d", strtotime($request->end_date)));
        }

        $leads = $leadList->paginate(10);

        $total_leads_provider = Lead::select('leads.lead_provider')
            ->selectRaw('count(*) as count, lead_provider')
            ->where('leads.lead_provider','!=','')
            ->groupBy('lead_provider')
            ->where('admin_email',$user->email)
            ->having('count','>=','1')
            ->orderby('lead_provider','asc')
            ->get()->toArray();
            
        $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
            ->leftjoin('usertypes','usertypes.id','users.usertype_id')
            ->where('parent_user_id',$user->id)
            ->where('users.approval','approve')
            ->where('users.is_deleted',0)
            ->orderby('id','desc')
            ->get();
            
        $agents = array();
        $outsidefor = [
            'id' => 0,
            'first_name' => 'All',
            'last_name' => 'Agents',
        ];
        array_push($agents,$outsidefor);

        foreach ($getagents as $agentData){
            $data = [
                'id' => $agentData->id,
                'first_name' => $agentData->first_name,
                'last_name' => $agentData->last_name,
            ];

            array_push($agents,$data);

        }
        
        $data = $leads;
        $data =[
            'leadList' => $leads,
            'agents' => $agents,
            'lead_providers' => $total_leads_provider,
        ];
        return response()->json([
                'success'  => true,
                'leadsData' => $leads,
                'agents' => $agents,
                'lead_providers' => $total_leads_provider,
                'message' => 'Leads Data',
            ]);
        // $this->sendResponse($data,'leads');
    }
    elseif($user->usertype_id == 4){
        $getUser = User::where('id',$user->id)->first();
        $getAdmin = User::where('id',$getUser->parent_user_id)->first();

        $leadList = Lead::with('leadInventory')->where('admin_email',$getAdmin->email)
            ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
            ->where('leads.archive_status',1)
            ->leftjoin('users','leads.admin_email','users.email')
            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
            // ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
            ->orderby('leads.updated_at', 'desc');
        
        if($request->search != null){
            $leadList->where(DB::raw('CONCAT_WS(" ", leads.sender_first_name, leads.sender_last_name)'), 'like','%' . $request->search . '%');
        }
        
        if($request->agent_id != null && $request->agent_id != 0){
            $leadList->where("leads.assigned_user_id" ,$request->agent_id);
        }
        
        if ($request->lead_status != null && $request->lead_status != 0) {
            $leadList->where("leads.lead_status", $request->lead_status);
        }
        
        if ($request->lead_type_status != null && $request->lead_type_status != 0) {
            $leadList->where("leads.lead_type_status", $request->lead_type_status);
        }
        
        if ($request->lead_source != null && $request->lead_source != 0) {
            $leadList->where("leads.lead_provider", $request->lead_source);
        }
        
        if (!empty($request->start_date) && !empty($request->end_date)) {
            $leadList->WhereDate('leads.created_at',">=",date("Y-m-d", strtotime($request->start_date)))->WhereDate('leads.created_at',"<=",date("Y-m-d", strtotime($request->end_date)));
        }
        
        
        $leads = $leadList->paginate(10);
        $data = $leads;
        
        $total_leads_provider = Lead::select('leads.lead_provider')
            ->selectRaw('count(*) as count, lead_provider')
            ->where('leads.lead_provider','!=','')
            ->groupBy('lead_provider')
            ->where('admin_email',$getAdmin->email)
            ->having('count','>=','1')
            ->orderby('lead_provider','asc')
            ->get()->toArray();
            
            
        $data =[
            'leadList' => $leads,
            'agents' => [],
            'lead_providers' => $total_leads_provider,
        ];
        
        return response()->json([
                'success'  => true,
                'leadsData' => $leads,
                'agents' => [],
                'lead_providers' => $total_leads_provider,
                'message' => 'Leads Data',
            ]);
        // return $this->sendResponse($data,'leads');
    }

    }
    
    public function getLead($id){
        $lead = Lead::with(['leadInventory'])
                            ->where('leads.id',$id)
                            ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
                            ->where('leads.archive_status',1)
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                            ->orderby('leads.updated_at', 'desc')
                            ->first();
                            
        return response()->json([
                'success'  => true,
                'lead' => $lead,
                'message' => 'Leads Data',
            ]);
    }
    
    public function LeadLogs($lead_id){

        $logsList = Lead::with(['chatlogs' => function($chat){
                                        $chat->where('ringless_voicemail',null);
                                    },'rvmlogs' => function($rvm){
                                        $rvm->where('mms_attachments',null)->where('ringless_voicemail','!=',null);
                                    },'phonelogs','emailLogs'
                                ])
                                ->select('leads.id','leads.email','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name')
                                ->where('id',$lead_id)
                                ->first();
        return response()->json([
                'success' => true,
                'data'    => $logsList,
                'message' => 'Lead Logs'
            ]);
    }
    
    public function LeadAppointnments($lead_id){

        $appointmentList = Lead::with('appointment')
                                ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name')
                                ->where('id',$lead_id)
                                ->first();
        return response()->json([
                'success' => true,
                'data'    => $appointmentList,
                'message' => 'Lead Appointments'
            ]);
    }
    
    public function LeadNotes($lead_id){

        $notesList = Lead::with('notes')
                                ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name')
                                ->where('id',$lead_id)
                                ->first();
        return response()->json([
                'success' => true,
                'data'    => $notesList,
                'message' => 'Lead Appointments'
            ]);
    }

    public function check() {

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $get_admin_id = User::where('id',$user->id)->first(['parent_user_id']);
        $admin_name = User::where('id',$get_admin_id->parent_user_id)->first(['id','email']);

        $get_lead_blast = Voicemailblast::select('voicemail_blast.id','voicemail_blast.audio_link','voicemail_blast.blast_created_id','voicemail_blast.is_activated','voicemail_blast.campaign_name','voicemail_blast.campaign_number','voicemail_blast.send_limit','voicemail_blast.send_at','voicemail_blast.lead_provider','voicemail_blast.message_filter','voicemail_blast.message_status','voicemail_blast.type','voicemail_blast.target_status','voicemail_blast.created_at','voicemail_blast.updated_at','voicemail_blast.date_from','voicemail_blast.date_to','voicemail_blast.send_id','voicemail_blast.assigned_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
            ->leftjoin('users as user_assiged','user_assiged.id','voicemail_blast.assigned_id')
            ->leftjoin('users as user_created','user_created.id','voicemail_blast.blast_created_id')
            ->where('voicemail_blast.assigned_id',$user->id)
            ->orderby('id','desc')
            ->get();
        dd($get_lead_blast);

        $number  = '123123';

        $phone = substr_replace($number,'+1',0,0);

        dd($phone);

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $agents = User::select('users.id','users.first_name','users.last_name')
            ->where('parent_user_id',$user->id)
            ->where('usertype_id',4)
            ->get();
        $insidefor = array();
        $outsidefor = [
            'id' => '0',
            'first_name' => 'All',
            'last_name' => 'Agents',
        ];
        array_push($insidefor,$outsidefor);
        foreach ($agents as $agent){
            $data = [
                'id' => $agent->id,
                'first_name' => $agent->first_name,
                'last_name' => $agent->first_name,
            ];

            array_push($insidefor,$data);

        }
        return $this->sendResponse([
            'agents' => $insidefor
        ],'chat-page-view');


    }

    public function leadinfo(Request $request) {
        
        $leadid = $request->id;
        
        $data = Lead::select('leads.*','admin.id as admin_id','admin.first_name as admin_first_name','admin.last_name as admin_last_name','agent.first_name as agent_first_name','agent.last_name as agent_last_name','company_info.name as company_name','company_info.phone_number')
            ->leftjoin('users as admin','admin.email','leads.admin_email')
            ->leftjoin('users as agent','agent.id','leads.assigned_user_id')
            ->leftjoin('company_info','company_info.user_id','admin.id')
            ->where('leads.id',$leadid)
            ->first();
        dd($data);
    }

    public function getAllMessages(Request $request)
    {
        $user = auth()->user()->id;
        $leadid = $request->id;
        
        if (auth()->user()->usertype_id == 4)
        {
            $getUser = User::where('id',$user)->first(['parent_user_id']);
            $user = User::where('id',$getUser->parent_user_id)->value('id');
        }

//        $data = Lead::select('leads.*','admin.id as admin_id','admin.first_name as admin_first_name','admin.last_name as admin_last_name','agent.first_name as agent_first_name','agent.last_name as agent_last_name','company_info.name as company_name','company_info.phone_number')
//            ->leftjoin('users as admin','admin.email','leads.admin_email')
//            ->leftjoin('users as agent','agent.id','leads.assigned_user_id')
//            ->leftjoin('company_info','company_info.user_id','admin.id')
//            ->where('leads.id',$leadid)
//            ->first();
        $data = Lead::select('leads.id','leads.lead_provider','leads.email','leads.contact','leads.status','leads.classification','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.address','leads.city','leads.state','leads.zip','leads.assigned_user_id','leads.lead_status','leads.lead_type_status','agent.first_name as agent_first_name','agent.last_name as agent_last_name')
            ->leftjoin('users as agent','agent.id','leads.assigned_user_id')
            ->where('leads.id',$leadid)
            ->first();
        if($data){
            $get_all = Leadchat::where(function($query) use ($data) {
                $query->where('from',$data->contact)
                    ->orWhere('to',$data->contact);
            })
            ->Where('admin_id',$user)->Where('lead_id',$leadid)
            ->first();
    
            if($get_all != null)
            {
                $get_all_messages = Leadchat::select('lead_chat.*','users.first_name as senderfirstname','users.last_name as senderlastname')
                    ->leftjoin('users','users.id','lead_chat.sender_id')
                    ->where('lead_chat.chat_id',$get_all->chat_id)
                    ->where('lead_chat.admin_id',$user)
                    ->where('lead_chat.ninja_id',7)
                    ->where('lead_chat.lead_id',$leadid)->orderBy('lead_chat.id', 'desc');
                //                ->get();
                $get_all_messages = $get_all_messages->paginate(15);
                return response()->json([
                    'success' => true,
                    'get_all_messages' => $get_all_messages,
                    'message' => ''
                ],200);
               
            }
            else{
                $get_all_messages = "Start Conversation now";
                return response()->json([
                    'success' => true,
                    'get_all_messages' => null,
                    'message' => $get_all_messages,
                ],200);
            }
        }else{
            return response()->json([
                    'success' => false,
                    'get_all_messages' => null,
                    'message' => "This ID ".$request->id." doesn't exist",
                ],404);
        }

    }

    public function textTranslation(Request $request){
        // return $request->text;
        $tr = new GoogleTranslate();
        $result = $tr->setSource()->setTarget($request->code)->translate($request->text);
        return response()->json([
                        'success'  => true, 
                        'result'   => $result,
                        'message'  => 'Text_translation'
                    ]);
    }
    
    public function messageStream($id){
        
        $user = auth()->user()->id;
        $leadid = $id;

        return response()->stream(function () use ($leadid, $user) {
            if (auth()->user()->usertype_id == 4) {
                $getUser = DB::table('users')->where('id', $user)->first(['parent_user_id']);
                $user = DB::table('users')->where('id', $getUser->parent_user_id)->value('id');
            }
            $data = DB::table('leads')
                ->select('leads.*', 'agent.first_name as agent_first_name', 'agent.last_name as agent_last_name')
                ->leftJoin('users as agent', 'agent.id', 'leads.assigned_user_id')
                ->where('leads.id', $leadid)
                ->first();
            if ($data) {
                $chat = DB::table('lead_chat')
                    ->where(function ($query) use ($data) {
                        $query->where('from', $data->contact)->orWhere('to', $data->contact);
                    })
                    ->where('admin_id', $user)
                    ->where('lead_id', $leadid)
                    ->first();
                if ($chat) {
                    $messages = DB::table('lead_chat')
                        ->select('lead_chat.*', 'users.first_name as senderfirstname', 'users.last_name as senderlastname')
                        ->leftJoin('users', 'users.id', 'lead_chat.sender_id')
                        ->where('lead_chat.chat_id', $chat->chat_id)
                        ->where('lead_chat.admin_id', $user)
                        ->where('lead_chat.ninja_id', 7)
                        ->where('lead_chat.lead_id', $leadid)
                        ->orderBy('lead_chat.id', 'desc')
                        ->paginate(15);
                    echo "retry: 5000\n"; // optional: auto-retry in 5 sec
                    echo "data: " . json_encode($messages) . "\n\n";
                    ob_flush();
                    flush();
                }
            }
        }, 200, [
            'Cache-Control' => 'no-cache',
            'Content-Type'  => 'text/event-stream',
            'X-Accel-Buffering' => 'no', // for nginx
        ]);






    }
    
    public function chatview (Request $request){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $leadid = $request->id;

        if($user->usertype_id == 2)
        {
            $ab = \App\Lead::where('id',$leadid)->update(['chat_filter' => 0]);

            $data = Lead::select('leads.*','leads.address','leads.city','leads.state','leads.zip','leads.assigned_user_id','leads.lead_status','leads.lead_type_status','agent.first_name as agent_first_name','agent.last_name as agent_last_name')
                ->leftjoin('users as agent','agent.id','leads.assigned_user_id')
                ->where('leads.id',$leadid)
                ->first();


            $get_all = Leadchat::where(function($query) use ($data) {
                            $query->where('from',$data->contact)
                                ->orWhere('to',$data->contact);
                        })
                        ->where('lead_id',$leadid)
                        ->Where('admin_id',$user->id)
                        ->first();

            if($get_all != null)
            {
                $get_all_messages = Leadchat::select('lead_chat.*','users.first_name as senderfirstname','users.last_name as senderlastname')
                    ->leftjoin('users','users.id','lead_chat.sender_id')
                    ->where('lead_chat.chat_id',$get_all->chat_id)
                    ->where('lead_chat.admin_id',$user->id)
                    ->where('lead_chat.ninja_id',7)
                    ->where('lead_chat.lead_id',$leadid)->orderBy('lead_chat.id', 'desc');
//                    ->get();

                $get_all_messages = $get_all_messages->paginate(15);
            }
            else{
                $get_all_messages = null;
            }

            $getagents = User::select('users.id','users.first_name','users.last_name')
                ->where('parent_user_id',$user->id)
                ->where('usertype_id',4)
                ->get();
            
            
            
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'Unassigned',
                'last_name' => ' ',
            ];
            array_push($agents,$outsidefor);

            foreach ($getagents as $agentData){
                $data1 = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];

                array_push($agents,$data1);
            }

            $leadsourceall = Lead::select('leads.lead_provider')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->where('admin_email', $user->email)
                ->having('count', '>=', '1')
                ->orderby('leads.lead_provider', 'asc')
                ->get();
           
        }
        elseif($user->usertype_id == 4){
            $ab = \App\Lead::where('id',$leadid)->update(['chat_filter'=>0]);
            $data = Lead::select('leads.*','leads.address','leads.city','leads.state','leads.zip','leads.assigned_user_id','leads.lead_status','leads.lead_type_status','agent.first_name as agent_first_name','agent.last_name as agent_last_name')
                ->leftjoin('users as agent','agent.id','leads.assigned_user_id')
                ->where('leads.id',$leadid)
                ->first();

            $users = User::where('id',$user->id)->first();
            $admin = User::where('id',$users->parent_user_id)->first();

            $get_all = Leadchat::where(function($query) use ($data) {
                $query->where('from',$data->contact)
                    ->orWhere('to',$data->contact);
            })
                ->Where('admin_id',$admin->id)->Where('lead_id',$leadid)
                ->first();

            if($get_all != null)
            {
                $get_all_messages = Leadchat::select('lead_chat.id','lead_chat.lead_id','lead_chat.from','lead_chat.to','lead_chat.message','lead_chat.mms_attachments','lead_chat.ringless_voicemail','lead_chat.chat_id','lead_chat.type','lead_chat.sender_id','lead_chat.created_at','users.first_name as senderfirstname','users.last_name as senderlastname')
                    ->leftjoin('users','users.id','lead_chat.sender_id')
                    ->where('lead_chat.chat_id',$get_all->chat_id)
                    ->where('lead_chat.admin_id',$admin->id)
                    ->where('lead_chat.ninja_id',7)
                    ->where('lead_chat.lead_id',$leadid)->orderBy('lead_chat.id', 'desc');

                $get_all_messages = $get_all_messages->paginate(15);
            }
            else{
                $get_all_messages = null;
            }


            $agents = User::select('users.id','users.first_name','users.last_name')
                ->where('parent_user_id',$admin->id)
                ->where('usertype_id',4)
                ->get();

            $leadsourceall = Lead::select('leads.lead_provider')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->where('admin_email', $admin->email)
                ->having('count', '>=', '1')
                ->orderby('leads.lead_provider', 'asc')
                ->get();
        }

        $get_answer = Quickanswer::where('user_id',$user->id)->get();
        // Check Pause Status
        $pause_status = Leadpause::where('lead_id',$leadid)->first();

        // get all number
        $all_numbers = Leadcontact::where('lead_id',$leadid)->get();
        $is_primary = $all_numbers->where('is_primary','yes')->first();

        // get all email
        $all_emails = Leademail::where('lead_id',$leadid)->get();

        // general_info
        $general_info = Leadgeneralinfo::where('lead_id',$leadid)->first();


        $reschedule_appt = LeadAppointment::where('lead_id',$leadid)->orderBy('id','desc')->first();

//        $lead_note = DB::table('lead_notes')->where('lead_id',$leadid)->first();
        return $this->sendResponse([
            'lead_info'=> $data,
            'get_all_messages' => $get_all_messages,
            'agents' => $agents,
            'lead-source' => $leadsourceall,
            'push_messages' => $get_answer,
            'pause_status' => $pause_status,
            'all_numbers' => $all_numbers,
            'is_primary' => $is_primary,
            'all_emails' => $all_emails,
            'general_info' => $general_info,
            'reschedule_appt' => $reschedule_appt,

        ],'chat-page-view');
//        if($get_all_messages){
//
//        }
//        else{
//            return $this->sendResponse([
//                'meesage' => 'Start Conversation Now'
//
//            ],'chat-page-view');
//        }


    }
    public function fetchMessages(Request $request, $leadid)
    {
        $user = auth()->user();
        $admin_id = $user->usertype_id == 4
            ? User::where('id', $user->parent_user_id)->first()->id
            : $user->id;

        // Fetch lead contact
        $lead = Lead::where('id', $leadid)->first();
        if (!$lead) {
            return $this->sendError('Lead not found', 404);
        }

        // Fetch chat
        $get_all = Leadchat::where(function ($query) use ($lead) {
            $query->where('from', $lead->contact)
                ->orWhere('to', $lead->contact);
        })
            ->where('lead_id', $leadid)
            ->where('admin_id', $admin_id)
            ->first();

        if (!$get_all) {
            return $this->sendResponse([
                'data' => [],
                'current_page' => 1,
                'has_more' => false,
                'total' => 0,
            ], 'No messages found');
        }

        // Fetch paginated messages
        $messages = Leadchat::select('lead_chat.*',
            'users.first_name as senderfirstname',
            'users.last_name as senderlastname')
            ->leftJoin('users', 'users.id', 'lead_chat.sender_id')
            ->where('lead_chat.chat_id', $get_all->chat_id)
            ->where('lead_chat.admin_id', $admin_id)
            ->where('lead_chat.ninja_id', 7)
            ->where('lead_chat.lead_id', $leadid)
            ->orderBy('lead_chat.id', 'desc')
            ->paginate(15);

        return $this->sendResponse([
            'data' => $messages->items(),
            'current_page' => $messages->currentPage(),
            'has_more' => $messages->hasMorePages(),
            'total' => $messages->total(),
        ], 'Messages fetched successfully');
    }

    public function archiveChatView(){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        if($user->usertype_id == 2){
//                ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
            $leads = Lead::
                select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber')
                ->where('admin_email',$user->email)
                ->leftjoin('users','leads.admin_email','users.email')
                ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                ->where('archive_status',0)
                ->orderby('updated_at', 'desc')->get();
        }
        elseif($user->usertype_id == 4){
            $leads = Lead::
                select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber')
                ->where('assigned_user_id',$user->id)
                ->leftjoin('users','leads.admin_email','users.email')
                ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                ->where('archive_status',0)
                ->orderby('updated_at', 'desc')->get();
        }

        return $this->sendResponse([
            'archive-lead'=> $leads,
        ],'archive-chat');

    }
    
    
    public function assignedleads(Request $request)
    {

        $user = User::where('id', auth()->user()->id)->with('companyinfo')->first();

        if ($user->usertype_id == 2) {
            
            $query = Lead::with('leadInventory')
                                    ->select('leads.id', 'leads.sender_first_name as lead_first_name', 'leads.sender_last_name as lead_last_name', 'leads.status', 'leads.assigned_user_id', 'leads.lead_provider', 'leads.lead_type_status' , 'leads.created_at', 'leads.updated_at', 'leads.chat_filter', 'agents.first_name as assign_first_name', 'agents.last_name as assign_last_name', 'leads.contact as leadnumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
                                    ->where('admin_email', $user->email)
                                    ->where('leads.assigned_user_id',$user->id)
                                    ->where('leads.status','assigned')
                                    ->leftjoin('users', 'leads.admin_email', 'users.email')
                                    ->leftjoin('users as agents', 'agents.id', 'leads.assigned_user_id')
                                    ->orderby('id', 'desc');
                                    
            if($request->search != null){
	            $query->where(DB::raw('CONCAT_WS(" ", leads.sender_first_name, leads.sender_last_name)'), 'like','%' . $request->search . '%');
	        }
	        
            if ($request->lead_status != null) {
                $query->where("leads.lead_status", $request->lead_status);
            }

            if ($request->lead_type_status != null) {
                $query->where("leads.lead_type_status", $request->lead_type_status);
            }

            if ($request->lead_source != null) {
                $query->where("leads.lead_provider", $request->lead_source);
            }

            if (!empty($startdate) || !empty($enddate)) {
                $query->WhereDate('leads.created_at',">=",date("Y-m-d", strtotime($startdate)))->WhereDate('leads.created_at',"<=",date("Y-m-d", strtotime($enddate)));
            }

            $unasign_leads = $query->paginate(10);
            
            $total_leads_provider = Lead::select('leads.lead_provider')
                                    ->selectRaw('count(*) as count, lead_provider')
                                    ->where('leads.lead_provider','!=','')
                                    ->groupBy('lead_provider')
                                    ->where('admin_email',$user->email)
                                    ->having('count','>=','1')
                                    ->orderby('lead_provider','asc')
                                    ->get()->toArray();
                                    
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
                                    ->leftjoin('usertypes','usertypes.id','users.usertype_id')
                                    ->where('parent_user_id',$user->id)
                                    ->where('users.approval','approve')
                                    ->where('users.is_deleted',0)
                                    ->orderby('id','desc')
                                    ->get();
                
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);
    
            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];
    
                array_push($agents,$data);
    
            }
            
            
        } elseif ($user->usertype_id == 4) {

            $getUser = User::where('id', $user->id)->first();
            $admin = User::where('id', $getUser->parent_user_id)->first();

            $query = Lead::with('leadInventory')
                                    ->select('leads.id', 'leads.sender_first_name as lead_first_name', 'leads.sender_last_name as lead_last_name','leads.status', 'leads.assigned_user_id', 'leads.lead_provider','leads.lead_type_status' ,'leads.created_at', 'leads.updated_at', 'leads.chat_filter', 'agents.first_name as assign_first_name', 'agents.last_name as assign_last_name', 'leads.contact as leadnumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
                                    ->where('admin_email', $admin->email)
                                    ->where('leads.assigned_user_id',$user->id)
                                    ->where('leads.status','assigned')
                                    ->leftjoin('users', 'leads.admin_email', 'users.email')
                                    ->leftjoin('users as agents', 'agents.id', 'leads.assigned_user_id')
                                    ->orderby('id', 'desc');
                                    
            
            if($request->search != null){
	            $query->where(DB::raw('CONCAT_WS(" ", leads.sender_first_name, leads.sender_last_name)'), 'like','%' . $request->search . '%');
	        }
	        
            if ($request->lead_status != null) {
                $query->where("leads.lead_status", $request->lead_status);
            }

            if ($request->lead_type_status != null) {
                $query->where("leads.lead_type_status", $request->lead_type_status);
            }

            if ($request->lead_source != null) {
                $query->where("leads.lead_provider", $request->lead_source);
            }

            if (!empty($startdate) || !empty($enddate)) {
                $query->WhereDate('leads.created_at',">=",date("Y-m-d", strtotime($startdate)))->WhereDate('leads.created_at',"<=",date("Y-m-d", strtotime($enddate)));
            }
            
            $unasign_leads  = $query->paginate(10);
            
            
            $total_leads_provider = Lead::select('leads.lead_provider')
                                            ->selectRaw('count(*) as count, lead_provider')
                                            ->where('leads.lead_provider','!=','')
                                            ->groupBy('lead_provider')
                                            ->where('admin_email',$admin->email)
                                            ->having('count','>=','1')
                                            ->orderby('lead_provider','asc')
                                            ->get()->toArray();
                                            
        }
        
        
        //   return $this->sendResponse($data, 'leads');

        return response()->json([
            'success'  => true,
            'leadsData' => $unasign_leads,
            'agents' => [],
            'lead_providers' => $total_leads_provider,
            'message' => 'Assigned Leads Data',
        ]);
    }

    public function filterAssignedLeads(Request $request)
    {
        
        $startdate = $request->start_date;
        $enddate = $request->end_date;


        $user = User::where('id', auth()->user()->id)->with('companyinfo')->first();


        if ($user->usertype_id == 2) {

            $query = new Lead();

            $query      =    $query->with('leadInventory')->select('leads.id', 'leads.sender_first_name as lead_first_name', 'leads.sender_last_name as lead_last_name','leads.status', 'leads.assigned_user_id', 'leads.lead_provider','leads.lead_type_status' ,'leads.created_at', 'leads.updated_at', 'leads.chat_filter','leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
                                    ->leftjoin('users', 'leads.admin_email', 'users.email')
                                    ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                    ->where('leads.assigned_user_id',$user->id)
                                    ->where('leads.status', 'assigned')
                                    ->where("leads.admin_email", $user->email)
                                    ->orderby('leads.updated_at', 'desc');
            
            if($request->search != null){
	            $query->where(DB::raw('CONCAT_WS(" ", leads.sender_first_name, leads.sender_last_name)'), 'like','%' . $request->search . '%');
	        }
	        
	        if($request->agent_id != null){
	            $query->where("leads.assigned_user_id" ,$request->agent_id);
	        }
            
            if ($request->lead_status != null) {
                $query->where("leads.lead_status", $request->lead_status);
            }

            if ($request->lead_type_status != null) {
                $query->where("leads.lead_type_status", $request->lead_type_status);
            }

            if ($request->lead_source != null) {
                $query->where("leads.lead_provider", $request->lead_source);
            }

            if (!empty($startdate) || !empty($enddate)) {
                $query->WhereDate('leads.created_at',">=",date("Y-m-d", strtotime($startdate)))->WhereDate('leads.created_at',"<=",date("Y-m-d", strtotime($enddate)));
            }

            $leads = $query->paginate(10);

            $leadCount = number_format($leads->total()) . " results found.";

        } elseif ($user->usertype_id == 4) {
            $getUser = DB::table('users')->where('id', $user->id)->first();
            $user = DB::table('users')->where('id', $getUser->parent_user_id)->first();
            $admin_email = $user->email;

            $query = new Lead();

            $query      =   $query->with('leadInventory')->select('leads.id', 'leads.sender_first_name as lead_first_name', 'leads.sender_last_name as lead_last_name','leads.status', 'leads.assigned_user_id', 'leads.lead_provider','leads.lead_type_status' ,'leads.created_at', 'leads.updated_at', 'leads.chat_filter', 'leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip')
                                    ->leftjoin('users', 'leads.admin_email', 'users.email')
                                    ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                    ->where('leads.assigned_user_id',$user->id)
                                    ->where('leads.status', 'assigned')
                                    ->where("leads.admin_email", $admin_email)
                                    ->orderby('leads.updated_at', 'desc');
            
            if($request->search != null){
	            $query->where(DB::raw('CONCAT_WS(" ", leads.sender_first_name, leads.sender_last_name)'), 'like','%' . $request->search . '%');
	        }
	        
	        if($request->agent_id != null){
	            $query->where("leads.assigned_user_id" ,$request->agent_id);
	        }
            
            if ($request->lead_status != null) {
                $query->where("leads.lead_status", $request->lead_status);
            }
            

            if ($request->lead_type_status != null) {
                $query->where("leads.lead_type_status", $request->lead_type_status);
            }

            if ($request->lead_source != null) {
                $query->where("leads.lead_provider", $request->lead_source);
            }

            if (!empty($startdate) || !empty($enddate)) {
                $query->WhereDate('leads.created_at',">=",date("Y-m-d", strtotime($startdate)))->WhereDate('leads.created_at',"<=",date("Y-m-d", strtotime($enddate)));
            }

            $leads = $query->paginate(10);

            $leadCount = number_format($leads->total()) . " results found.";

        }
        
        return response()->json([
            'success'  => true,
            'unassignleadList' => $leads,
            'count' => $leadCount,
            'message' => 'Filtered Aassigned Leads Data',
        ]);
        
        // return $this->sendResponse([
        //     'unassignleadList' => $leads,
        //     'count' => $leadCount
        // ], 'unassignleadList');

    }



}