<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\Models\Version;
use App\User;
use App\Notification;
use ManualLead;
use Illuminate\Support\Facades\Cache;


class NotificationController extends BaseController{

    public function notification(){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        if($user->usertype_id == 2){

            $notifications = Notification::with(['lead' => function($query){
                                                $query->with(['leadInventory'])->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                                                      ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                                      ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip');
                                            }])->select('notifications.*','leads.title','leads.lead_provider','leads.assigned_user_id as assigned_agent_id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','users.first_name','users.last_name','manual_lead.title as manualleadtitle','manual_lead.lead_provider as manualleadprovider','manualagent.first_name as agentfirstname','manualagent.last_name as agentlastname')
                                            ->leftjoin('manual_lead','manual_lead.id','notifications.manual_lead_id')
                                            ->leftjoin('leads','leads.id','notifications.lead_id')
                                            ->leftjoin('users','users.id','leads.assigned_user_id')
                                            ->leftjoin('users as manualagent','manualagent.id','manual_lead.assigned_user_id')
                                            ->where('user_id',$user->id)
                                            ->where('notifications.lead_id','!=',null)
                                            ->orderby('notifications.id','desc')
                                            ->get();
        }
        elseif($user->usertype_id == 4){
            $notifications =Notification::with(['lead' => function($query){
                                                $query->with(['leadInventory'])->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                                                      ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                                      ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip');
                                            }])->select('notifications.*','leads.title','leads.lead_provider','leads.assigned_user_id  as assigned_agent_id','leads.sender_first_name  as lead_first_name','leads.sender_last_name  as lead_last_name','users.first_name','users.last_name')
                                            ->leftjoin('leads','leads.id','notifications.lead_id')
                                            ->leftjoin('users','users.id','leads.assigned_user_id')
                                            ->where('user_id',$user->id)
                                            ->orderby('id','desc')
                                            ->get();
        }
        return $this->sendResponse([
            'notification'=> $notifications,
        ],'notifications');

    }
    
    public function notificationCount(){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        if($user->usertype_id == 2){

            $notifications =    Notification::where('user_id',$user->id)
                                            ->where('status','new')
                                            ->where('notifications.lead_id','!=',null)
                                            ->orderby('notifications.id','desc')
                                            ->count();
        }
        elseif($user->usertype_id == 4){
            $notifications =    Notification::where('user_id',$user->id)
                                            ->where('status','new')
                                            ->orderby('id','desc')
                                            ->count();
        }
        return $this->sendResponse([
            'count'=> $notifications,
        ],'notifications_count');

    }
    
    public function notificationReadAll(){
        
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        
        $notifications = Notification::where('user_id',$user->id)->update(['status' => 'open']);
        
        return response()->json([
            'success' => true,
            'message' => 'Notification has been successfully cleared',
        ],200);
    }
    
    public function notificationRead($id){
        
        $notifications = Notification::where('id',$id)->update(['status' => 'open']);
        
        return response()->json([
            'success' => true,
            'message' => 'Notification has been successfully cleared',
        ],200);
    }

    public function versionUpdate(Request $request){
        $current = $request->current_version;
        $previous = $request->previous_version;
        $platform = $request->platform;
        if ($platform != null){
           if ($current != null && $previous != null ){
               $data = Version::where('platform',$platform)->first();
               if ($data){
                   if($data->current_version == $current || $data->previous_version == $previous){
                       $data->update(['previous_version' => $previous , 'current_version' => $current]);
                       return $this->sendResponse([],'Version Updated Successfully!.');
                   }
                   else{
                        return $this->sendError('Please change the current version first!.');
                   }
               }
               else{
                    return $this->sendError('Please use correct version!.');
               }
           }
           else{
               return $this->sendError('Please mention current version');
           }
        }
        else{
           return $this->sendError('Please mention device platform');
        }
    }

    public function versionCheck(Request $request){
        $current = $request->current_version;
        $platform = $request->platform;
        if ($platform != null){
            if ($current != null){
                $data = Version::where('platform',$platform)->first();
                if($data->previous_version == (String)$current || $data->current_version == (String)$current){
                      return $this->sendResponse([],'No update found!');
                }
                else{
                   return $this->sendError('New update found. Please update your app!');
                }
            }
            else{
                return $this->sendError('Please mention current version!');
            }
        }
        else{
             return $this->sendError('Please mention device platform');
        }
    }
}