<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\Carmake;
use App\Leadchat;
use App\Leadinventorylist;
use App\Inventorylandingpage;
use App\Leadinventoryinfo;
use App\Companyinfo;
use App\Contactemail;
use Twilio\Rest\Client;
use Mail;

use Illuminate\Support\Facades\Cache;


class InventoryController extends BaseController
{
    public function __construct()
    {
        $this->sid = 'AC15298329064d30e708bdc83adb95dc54';
        $this->auth = 'a50d5f32c3cf6395d827748625374fb7';

    }

    public function chatinventorylist(Request $request)
    {

        $leadid = $request->leadid;

        $admin_email = Lead::select('admin_email')->where('id',$leadid)->first();

        $getuser = User::where('email',$admin_email->admin_email)->first();

        $inventorylist = Leadinventorylist::where('user_id',$getuser->id)->where('is_sold','no')->orderby('id','desc')->get();
        
        $makers = Carmake::select('id','name')->get();

        $leadinfo = Lead::select('leads.id','leads.admin_email','company_info.name as companyname','company_info.phone_number as phone_number')
            ->where('leads.id',$leadid)
            ->leftjoin('users','leads.admin_email','users.email')
            ->leftjoin('company_info','company_info.user_id','users.id')
            ->get();
        $user_id = $getuser->id;

//        $company = Companyinfo::select('company_info.name','company_info.phone_number')->
//            where('user_id',$user_id)->first();

        return $this->sendResponse([
            'inventorylist' => $inventorylist,
            'makers' => $makers,
            'leadinfo' => $leadinfo,
        ],'Inventory_list');


    }

    public function getInventoryDetail(Request $request)
    {

        $admin_email = $request->adminemail;
        $vin = $request->vin;

        $userInfo = User::where('email',$admin_email)->first();
        $userId = $userInfo->id;

        $inventory = Leadinventorylist::where('user_id',$userId)->where('vin',$vin)->first();
        $image_name = null;
        if($inventory->car_img == null)
        {
            $image_name = "https://crm.text10x.ai/asset/no-car-photo.png";
        }
        else
        {
            $explode = explode("|", $inventory->car_img);
            $image_name = $explode[0];
        }


        return $this->sendResponse([
            'id' => $inventory->id,
            'info' => $inventory,
            'image_name' => $image_name,
        ],'Inventory_detail-send-paket');

    }

    public function sendInventoryDetail(Request $request)
    {
        // return $request;
        $sessionuser = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $admin_email = $request->adminemail;
        $from_number = $request->fromnumber;
        $lead_id = $request->leadid;
        $inventoryId = $request->inventoryId;


        $inventory = Leadinventorylist::where('id',$inventoryId)->first();

        $lead = Lead::where('admin_email',$admin_email)->where('id',$lead_id)->first();
        $user = User::where('email',$admin_email)->first();

        $company = Companyinfo::where('user_id',$user->id)->first();

        $uniq_link = substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyz'), 0, 8)."-".$inventoryId."-".substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyz'), 0, 10)."-".substr(str_shuffle('0123456789abcdefghijklmnopqrstuvwxyz'), 0, 12);
        Inventorylandingpage::insert(['user_id'=>$user->id,
            'lead_id'=>$lead_id,
            'inventory_id'=>$inventoryId,
            'link'=>$uniq_link,
            'sms'=>$request->sms,
            'email'=>$request->email,
            'v_price' => $request->v_price,
            'sticker'=>$request->sticker,
            'about_us'=>$request->about
        ]);

        $shortener = app('url.shortener');
        $inventory_url = $shortener->driver('is_gd')->shorten("https://vehicle.text10x.ai/main.php?url=".$uniq_link);

        if($request->sms == 'on')
        {
   
            if($lead->contact != null)
            {
                $sid    = $this->sid;
                $token  = $this->auth;
                $client = new Client( $sid, $token );

                $sms_body = strip_tags($request->msg)."\n\n".$inventory_url;
                $sms_body_chat = strip_tags($request->msg)."<br><br>".$inventory_url;
                $message_insert = false;
                try{
                    $client->messages->create(
                        $lead->contact,
                        array(
                            'from' => $from_number,
                            'body' => $sms_body
                        )
                    );
     
    
                    $check_number = Leadchat::where('admin_id', $user->id)->where('from',$lead->contact)->orwhere('to',$lead->contact)->first();
    
                    $countChat = null;
    
                    if($check_number != null)
                    {
                        $countChat = $check_number->chat_id;
                    }else{
                        $get_max_value = Leadchat::max('chat_id');
                        $countChat = $get_max_value + 1;
                    }

                    $send = [
                        'admin_id' => $user->id,
                        'lead_id' => $lead_id,
                        'from' => $from_number,
                        'to' => $lead->contact,
                        'message' => $sms_body_chat,
                        'chat_id' =>$countChat,
                        'type' => 'sent',
                        'private_chat' => 'no',
                        'private_id' => $user->id,
                        'sender_id' => $sessionuser->id,
                    ];
    
                    $message_insert = Leadchat::insert($send);
                }catch(\Twilio\Exceptions\RestException $e){
                    Lead::where('id',$request->leadid)->update(['lead_status' => 'Wrong Number']);
                    return response()->json([
                        'success' => false,
                        'message' => 'Wrong Number',
                    ],201);
                }
                if($message_insert){
                    return response()->json([
                        'success' => true,
                        'message' => 'send successfully',
                    ],200);
                }
                else{
                    return response()->json([
                        'success' => false,
                        'message' => 'Something Went wrong',
                    ],500);
                }
            }
        }
        else{
            return response()->json([
                'success' => false,
                'messge' => 'Something Went wrong',
            ],500);
        }

//        if($request->email == 'on')
//        {
//            if($lead->email != null)
//            {
//                $imgUrl = "https://www.ejcarsclub.com/images/no-car-photo.png";
//                if($inventory->car_img != null)
//                {
//                    $explode = explode("|",$inventory->car_img);
//                    $imgUrl = $explode[0];
//                }
//
//                $dataTop = $user->phone_number;
//                $phone_number = $dataTop;
////                if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dataTop,  $matches ) )
////                {
////                    $phone_number = '('.$matches[1].') ' .$matches[2] . '-' . $matches[3];
////                }
//
//                $message_body = 'Hi '.$lead->sender_first_name.',
//                                <br><br>
//                                '.$request->msg.'
//                                <br><br>
//                                <div style="width:100%;float:left;margin:10px 0 40px">
//                                    <img src="'.$imgUrl.'" width="320px">
//                                    <br>
//                                    <a style="width:320px;float:left;margin-top:10px;padding:8px 0;text-align:center;background:#666;color:#fff;border-radius:5px;text-decoration:none" href="'.$inventory_url.'">View detail</a>
//                                </div>
//                                <br><br><br>
//                                '.$company->name.'
//                                <br>
//                                '.$user->first_name.' '.$user->last_name.'
//                                <br>
//                                '.$phone_number;
//
//                $data = [
//                    'msg' => $message_body,
//                ];
//
//                Mail::send('email.autoPacket',$data, function($message) use ($lead,$company,$inventory){
//                    $message->to($lead->email, $lead->sender_first_name." ".$lead->sender_last_name)
//                        ->subject($inventory->year." ".$inventory->car_make." ".$inventory->car_model." - Text10X");
//                    $message->from($company->suite,$company->name);
//                });
//
//                $get_max_value_email = Contactemail::max('email_chat_id');
//                $countEmailChat = $get_max_value_email + 1;
//
//                $sendEmail = [
//                    'from' => $company->suite,
//                    'to' => $lead->email,
//                    'subject' => $inventory->year." ".$inventory->car_make." ".$inventory->car_model." - Text10X",
//                    'message' => $message_body,
//                    'type' => 'sent',
//                    'sender_id' => $user->id,
//                    'email_chat_id' => $countEmailChat,
//                    'robo_text' => 'auto_packet'
//                ];
//
//                $message_insert = Contactemail::insert($sendEmail);
//            }
//        }


    // if(isset($message_insert)){
    //     return response()->json([
    //         'success' => true,
    //         'messge' => 'send successfully',
    //     ],200);
    // }
    // else{
    //     return response()->json([
    //         'success' => false,
    //         'messge' => 'Something Went wrong',
    //     ],500);
    // }


//        return redirect()->route('chat',[$parameter]);
    }

    public function inventoryfilter(Request $request)
    {


        $userId = $request->user_id;
        $make = $request->make;
        $model = $request->model;
        $year = $request->year;
        $vin_field = $request->vin_field;
        $vin_val = $request->vin_val;
        $leadid =  $request->leadid;


        $list =  Leadinventorylist::where('user_id',$userId)->where('is_sold','no');


        if($make != null)
        {
            $list->where('car_make',$make);
        }

        if($model != null)
        {
            $list->where('car_model',$model);
        }

        if($year != null)
        {
            $list->where('year',$year);
        }

        if($vin_val != null)
        {
            $list->where($vin_field,$vin_val);
        }

        $final = $list->orderby('id','desc')
                        ->get();

        return $this->sendResponse([
            'inventorylist' => $final,

        ],'filter_Inventory_list');



    }

    public function getVinInfo(Request $request){

            $adminemail = $request->adminemail;
            $user = User::where('email',$adminemail)->first(['id']);
            $userId = $user->id;

            $vin = $request->vin;
            $vinInfo = Leadinventorylist::where('user_id',$userId)->where('vin',$vin)->first();

            if($vinInfo!=null)
            {

                return $this->sendResponse([
                    'chat_vin_info' => $vinInfo,
                ],'chat_vin_info');

            }
            else{
                return $this->sendResponse([
                    'chat_vin_info' => 'Something Went wrong successfully',
                ],'chat_vin_info');


            }
    }

    public function sendInventoryLink(Request $request)
    {

            $adminemail = $request->adminemail;
            $user = User::where('email',$adminemail)->first(['id']);
            $userId = $user->id;
            $vin = $request->vin;

            $vinInfo = Leadinventorylist::where('user_id',$userId)->where('vin',$vin)->first();

            if($vinInfo != null)
            {
                if($vinInfo->inventory_link == '')
                {

                    return $this->sendResponse([
                        'inventory_short_url' => 'Something Went Wrong',
                    ],'inventory_short_url');

                }
                else
                {
                    $shortener = app('url.shortener');
                    $shortUrl = $shortener->driver('is_gd')->shorten($vinInfo->inventory_link);


                    return $this->sendResponse([
                        'inventory_short_url' => $shortUrl,
                    ],'inventory_short_url');

                }
            }
            else{

                return $this->sendResponse([
                    'inventory_short_url' => 'Something Went Wrong',
                ],'inventory_short_url');


            }

    }

    public function editInventoryChat(Request $request)
    {
        $adminId = $request->user_id;
        $searchInventoryBy = $request->searchInventoryBy;
        $searchInventory = $request->searchInventory;
        $leadId = $request->textid;


        $getinventory = Leadinventorylist::where('user_id',$adminId)->where($searchInventoryBy,"LIKE","%{$searchInventory}%")->get();


        return $this->sendResponse([
            'search_inventory_list' => $getinventory,
        ],'search_inventory_list');

    }

    public function removeInventoryChat(Request $request)
    {

        $id = $request->id;

        $check = DB::table('leads_inventory_info')->where('lead_id',$id)->delete();

        if($check){
            return $this->sendResponse([
                'remove_inventory' => 'Inventory deleted successfully',
            ],'remove_inventory');
        }
        else{
            return $this->sendResponse([
                'remove_inventory' => 'Something went wrong',
            ],'remove_inventory');
        }

      
    }

    public function changeInventoryChat(Request $request)
    {
        $adminId = $request->user_id;
        $invent_id = $request->invent_id;
        $leadId = $request->lead_id;

        $row = Leadinventorylist::where('user_id',$adminId)->where('id',$invent_id)->first();

        $check = Leadinventoryinfo::where('lead_id',$leadId)->first();
       
        if($check == null)
        {
            $insert = Leadinventoryinfo::where('lead_id',$leadId)->insert(['lead_id' => $leadId, 'year' => $row->year, 'make' => $row->car_make, 'model' => $row->car_model, 'vin' => $row->vin]);

            return $this->sendResponse([
                'change_or_addinventory' => 'Inventory added successfully',
            ],'change_or_addinventory');
        }
        else
        {
            $update = Leadinventoryinfo::where('lead_id',$leadId)->update(['year' => $row->year, 'make' => $row->car_make, 'model' => $row->car_model, 'vin' => $row->vin]);

            return $this->sendResponse([
                'change_or_addinventory' => 'Inventory updated successfully',
            ],'change_or_addinventory');
        }
    }


}