<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\Leadchat;
use App\Leadlog;
use App\User;
use App\Companyinfo;
use App\Companyextranumber;
use App\Carmake;
use App\Carmodel;
use App\Contactemail;
use Validator;
use App\Leadinventoryinfo;
use App\Notification;
use App\Leadworkflow;
use App\Manualrobotext;
use App\Userimportlimit;
use Illuminate\Support\Facades\Cache;



class ImportController extends BaseController{

    public function workFlowView()
    {
                    $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

                    $workFlowListText = Leadworkflow::where('type','text')->where('user_id',$user->id)->get();
                    $workFlowListEmail = Leadworkflow::where('type','email')->where('user_id',$user->id)->get();
                    $workFlowStatus = Companyinfo::where('user_id',$user->id)->first('work_flow');
                    $importLimit = Userimportlimit::where('user_id',$user->id)->first('bulk_limit');

                    $leadSources = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as c, lead_provider')
                        ->where('admin_email',$user->email)
                        ->groupBy('lead_provider')
                        ->having('c','>=','1')
                        ->orderby('c','desc')
                        ->get();


                    return $this->sendResponse([
                        'workFlowListText' => $workFlowListText,
                        'workFlowListEmail' => $workFlowListEmail,
                        'leadSources' => $leadSources,
                        'workFlowStatus' => $workFlowStatus,
                        'importLimit' => $importLimit,

                    ],'Workflowview');

//                    return view('backend.pages.import.workflow', compact('workFlowListText','workFlowListEmail','leadSources','workFlowStatus','importLimit'));
                }
                
    public function workFlowAdd(Request $request)
    {
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $laedsource = explode(",",$request->lead_source);
            if (!empty($request->lead_source)){
                $leadSource = implode('|',$laedsource );
            }
            else{
                $leadSource = null;
            }

                $userid = $user->id;
            $data = [
                'created_by' => $user->id,
                'user_id' => $userid,
                'days_old' => $request->leads_old,
                'type' => $request->type,
                'source'=> $leadSource,
                'subject'=> $request->email_subject,
                'message'=> $request->manual_text
            ];
//            dd($data);

       $insert =  Leadworkflow::insert($data);

            if($insert){
                if(!empty($request->email_subject)) {
                    return $this->sendResponse([
                        'addworkflow' => 'Email Workflow Added Successfully' ,
                    ],'addworkflow');
                }
                else{
                    return $this->sendResponse([
                        'addworkflow' => 'Text Workflow Added Successfully' ,
                    ],'addworkflow');
                }

            }
            else {
                return $this->sendResponse([
                    'addworkflow' => 'Something Went Wrong' ,
                ],'addworkflow');
            }


//            return redirect()->route('work_flow_view');

    }

    public function workFlowEdit(Request $request)
    {
            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
            $id = $request->id;
            $get_type = Leadworkflow::where('id',$id)->value('type');
            $output = null;
            $type_selected1 = ""; $type_selected2 = ""; $type_selected3 = "";
            $days_old_selected1 = ""; $days_old_selected2 = ""; $days_old_selected3 = ""; $days_old_selected4 = ""; $days_old_selected5 = ""; $days_old_selected6 = ""; $days_old_selected7 = ""; $days_old_selected8 = ""; $days_old_selected9 = ""; $days_old_selected10 = ""; $days_old_selected11 = ""; $days_old_selected12 = "";

            $flow = Leadworkflow::where('id',$id)->where('user_id',$user->id)->first();

            $flowselected = Leadworkflow::where('id',$id)->where('user_id',$user->id)->first();

        $source = $flow->source;
        $manual_text_edit = $flow->message;
        $subject = $flow->subject;
        $type = $flow->type;

        if($flow->type == "email") {
            return $this->sendResponse([
                'get_type' => $get_type,
                'source' => $source,
                'manual_text_edit' => $manual_text_edit,
                'subject' => $subject,
                'flowselected' => $flowselected->days_old
            ],'addworkflow');
        }
        else{
            return $this->sendResponse([
                'get_type' => $get_type,
                'source' => $source,
                'manual_text_edit' => $manual_text_edit,
                'flowselected' => $flowselected->days_old
            ],'addworkflow');
        }



    }

    public function workFlowUpdate(Request $request)
    {
            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            $get_user_id = Leadworkflow::where('id',$request->id)->value('user_id');

                $userid = $user->id;
            $laedsource = explode(",",$request->lead_source);

            $get_type = Leadworkflow::where('id',$request->id)->value('type');
            if ($get_type=='email'){
                $subject = $request->email_subject;
            }
            else{
                $subject = null;
            }
            if (!empty($request->lead_source)){
                $leadSource = implode('|', $laedsource);
            }
            else{
                $leadSource = null;
            }


            $data = [
                'days_old' => $request->leads_old,
                'type' =>strtolower($request->type),
                'source'=> $leadSource,
                'subject'=> $subject,
                'message'=> $request->manual_text,
                'user_id' => $userid,
                'created_by' => $user->id,
            ];
            //dd($data);

              $updated =   Leadworkflow::where('id', $request->id)->where('user_id', $userid)->update($data);

        if($updated){
            return $this->sendResponse([
                'update_workflow' => 'Workflow Updated',
            ],'update_workflow');
        }
        else{
            return $this->sendResponse([
                'update_workflow' => 'Something Went Wrong',
            ],'update_workflow');
        }


    }

    public function workFlowDel(Request $request)
    {
            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            $delete = Leadworkflow::where('id',$request->flow_id)->where('user_id',$user->id)->delete();

        if($delete){
            return $this->sendResponse([
                'del_workflow' => 'work flow deleted',
            ],'del_workflow');
        }
        else {
            return $this->sendResponse([
                'del_workflow' => 'Something Went Wrong',
            ],'del_workflow');
        }


//            return redirect()->route('work_flow_view');

    }

    public function workFlowStart(Request $request)
    {

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $id =  $request->id;
        $value = $request->value;
            $data = [
                'start_flow'=> $value
            ];

           $result =  Leadworkflow::where('id',$id)->where('user_id',$user->id)->update($data);

           if($result) {
               $status = Leadworkflow::where('id', $id )->first();

               if($status->start_flow == 'yes') {
                   return $this->sendResponse([
                       'workflow' => 'work flow start',
                   ],'del_workflow');
               }
               else {
                   return $this->sendResponse([
                       'workflow' => 'work flow paused',
                   ],'del_workflow');
               }
           }
           else {
               return $this->sendResponse([
                   'workflow' => 'Smoething Went Wrong',
               ],'del_workflow');
           }



    }

    public function viewRoboTextTest()
    {

                    $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

                    $text = Manualrobotext::where('sender_id',$user->id)->whereIn('type',['fresh', 'default_fresh'])->get();
                    $textBulk = Manualrobotext::where('sender_id',$user->id)->where('type','bulk')->get();
                    $importLimit = Userimportlimit::where('user_id',$user->id)->first('bulk_limit');

                    $leadSources = Lead::select('leads.lead_provider')
                        ->selectRaw('count(*) as c, lead_provider')
                        ->where('admin_email',session()->get('email'))
                        ->groupBy('lead_provider')
                        ->having('c','>=','1')
                        ->orderby('c','desc')
                        ->get();


                    return $this->sendResponse([
                        'text' => $text,
                        'textBulk' => $textBulk,
                        'leadSources' => $leadSources,
                        'importLimit' => $importLimit
                    ],'Robo_text');

//                    return view('backend.pages.import.robo_text', compact('text','textBulk','leadSources','importLimit'));


    }

    public function addRoboTextTest(Request $request)
    {

            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

                if($request->type == 'bulk'){
                    $status = $request->status;
                    $leadSource = "all";
                    $text = $request->manual_text_bulk;
                    $type = $request->type;
                }
                elseif($request->type == 'default_fresh'){
                    $status = 'active';
                    $leadSource = "all";
                    $text = $request->manual_text;
                    $type = $request->type;
                }
                else{
                    $status = 'active';
                    $leadSource = implode('/', $request->lead_source);
                    $text = $request->manual_text;
                    $type = $request->type;

                }

                $insert = Manualrobotext::insert(['sender_id' => $user->id, 'text' => $text, 'type' => $type,'lead_source'=>$leadSource,'status'=>$status]);


                if($insert){

                    return $this->sendResponse([
                        'robotext' => "Robo text added successfully",
                    ],'Robo_text');

//                    $output = '<option value="'.$text.'">'.str_limit($text, $limit = 80, $end = "...").'</option>';
//                    $array = ['status' => 'yes','output'=>$output];
//                    echo json_encode($array);
                }

                else{
                    return $this->sendResponse([
                        'robotext' => "Something Went Wrong",
                    ],'Robo_text');
                }


    }

    public function roboTextChangeStatus(Request $request)
    {

            $id = $request->id;
            $status = $request->status;
            $type = $request->type;
            
            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            if($status == 'inactive')
            {
                Manualrobotext::where('id', $id)->where('type',$type)->update(['status' => 'inactive']);

                return $this->sendResponse([
                    'robotext' => "Robo Text Status Updated Successfully!",
                ],'Robo_text');

            }
            else
            {
                $find = Manualrobotext::where('sender_id', $user->id)->where('type',$type)->get();

                foreach($find as $data)
                {
                    Manualrobotext::where('sender_id', $user->id)->where('type',$type)->update(['status' => 'inactive']);
                }

                Manualrobotext::where('id', $id)->where('type',$type)->update(['status' => 'active']);


                return $this->sendResponse([
                    'robotext' => "Robo Text Status Updated Successfully!",
                ],'Robo_text');

            }

    }

    public function editRoboTextTest(Request $request){

            if($request->id > 0){
                $roboData = Manualrobotext::where('id',$request->id)->first();

                if($roboData){
                    return $this->sendResponse([
                        'status' => "yes",
                        'roboData' => $roboData,
                    ],'Robo_text');
                }
                else{
                    return $this->sendResponse([
                        'status' => "Something Went Wrong",
                    ],'Robo_text');
                }


            }

    }

    public function updateRoboTextTest(Request $request)
    {

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            $id = $request->manual_text_id;

            if($id != null )
            {
                $text = $request->manual_text;
                $type = $request->lead_type;

                if($type == 'bulk'){
                    $status = $request->status;

                    $data=[
                        'sender_id' => $user->id,
                        'text' => $text,
                        'type' => $type,
                        'status'=>$status
                    ];

                    Manualrobotext::where('id',$id)->update($data);


                    return $this->sendResponse([
                        'update_robo_text_bulk' => "Updated Successfully",
                    ],'update_robo_text_bulk');
                }
                elseif($type == 'default_fresh'){
                    $data=[
                        'sender_id' => $user->id,
                        'text' => $text,
                        'type' => $type,
                        'lead_source'=> null,
                        'status'=>"active"
                    ];

                    Manualrobotext::where('id',$id)->update($data);


                    return $this->sendResponse([
                        'update_robo_text_bulk' => "Updated Successfully",
                    ],'update_robo_text_bulk');
                }
                else{
                    $data=[
                        'sender_id' => $user->id,
                        'text' => $text,
                        'type' => $type,
                        'lead_source'=>null,
                        'status'=>"active"
                    ];

                    Manualrobotext::where('id',$id)->update($data);

                    return $this->sendResponse([
                        'update_robo_text_bulk' => "Updated Successfully",
                    ],'update_robo_text_bulk');
                }
            }
            else{
                return $this->sendResponse([
                    'update_robo_text_bulk' => "Something Went Wrong",
                ],'update_robo_text_bulk');
            }

    }


}