<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\EmailTemplate;
use App\Lead;
use App\User;
use App\Emailblast;
use App\Permissionallowed;
use App\Blastpercentage;
use App\Companyinfo;
use Illuminate\Support\Facades\Cache;


class EmailblastController extends BaseController{

    public function emailblast(){
        
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        if($user->usertype_id == 2){

            $get_lead_blast = Emailblast::select('email_blast.template_id','email_blast.subject','email_blast.is_activated','email_blast.is_attachment','email_blast.attachments','email_blast.id','email_blast.email_blast_created_id','email_blast.campaign_name','email_blast.send_limit','email_blast.send_at','email_blast.lead_provider','email_blast.message_filter','email_blast.email_status','email_blast.type','email_blast.target_status','email_blast.message_description','email_blast.assigned_id','email_blast.created_at','email_blast.updated_at','email_blast.date_from','email_blast.date_to','email_blast.send_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                        ->with('template')
                                        ->leftjoin('users as user_send','user_send.id','email_blast.send_id')
                                        ->leftjoin('users as user_assiged','user_assiged.id','email_blast.assigned_id')
                                        ->leftjoin('users as user_created','user_created.id','email_blast.email_blast_created_id')
                                        ->where('email_blast.send_id',$user->id)
                                        ->OrWhere('user_send.parent_user_id',$user->id)
                                        ->orderby('id','desc')
                                        ->get();

            $total_leads = Lead::where('lead_status','Active-Fresh')
                ->select()
                ->count('*');

            // $getagents = User::where('parent_user_id',$user->id)->select('users.id','users.first_name','users.last_name')
            //     ->where('usertype_id',2)
            //     // ->where('approval','approve')
            //     ->get();
            
            $getagents = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
            ->leftjoin('usertypes','usertypes.id','users.usertype_id')
            ->where('parent_user_id',$user->id)
            ->where('users.approval','approve')
            ->where('users.is_deleted',0)
            ->orderby('id','desc')
            ->get();
            
            $agents = array();
            $outsidefor = [
                'id' => 0,
                'first_name' => 'All',
                'last_name' => 'Agents',
            ];
            array_push($agents,$outsidefor);

            foreach ($getagents as $agentData){
                $data = [
                    'id' => $agentData->id,
                    'first_name' => $agentData->first_name,
                    'last_name' => $agentData->last_name,
                ];

                array_push($agents,$data);

            }

            $total_leads_provider = Lead::select('leads.lead_provider')
                ->where('leads.lead_provider','!=','')
                ->selectRaw('count(*) as count, lead_provider')
                ->groupBy('lead_provider')
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();


            $getdate = Lead::where('admin_email',$user->email)->orderby('created_at','asc')->first('created_at');
            $startdate = date("m/d/y", strtotime($getdate->created_at));

            $get_dedicated_number = null;
            $dedicated_number = null;

            $get_dedicated_number = Companyinfo::where('user_id',$user->id)->first(['phone_number']);

            $dedicated_number = $get_dedicated_number->phone_number;

            $country_code = '+1';
            $dedicated_number = ltrim($dedicated_number, $country_code);



            return $this->sendResponse([
                'email-blast-view' => $get_lead_blast,
                'total-leads' => $total_leads,
                'agents' => $agents,
                'total_lead_provider' => $total_leads_provider,
                'start_date' => $startdate,
                'dedicated_number' => $dedicated_number,
            ],'email-blast-view');
 
        }
        elseif($user->usertype_id == 4){
            
            $get_admin_id = User::where('id',$user->id)->first();
            $admin_name = User::where('id',$get_admin_id->parent_user_id)->first();


            
             $get_lead_blast = Emailblast::select('email_blast.template_id','email_blast.subject','email_blast.is_activated','email_blast.is_attachment','email_blast.attachments','email_blast.id','email_blast.email_blast_created_id','email_blast.campaign_name','email_blast.send_limit','email_blast.send_at','email_blast.lead_provider','email_blast.message_filter','email_blast.email_status','email_blast.type','email_blast.target_status','email_blast.message_description','email_blast.assigned_id','email_blast.created_at','email_blast.updated_at','email_blast.date_from','email_blast.date_to','email_blast.send_id','user_assiged.first_name as assigned_first_name','user_assiged.last_name as assigned_last_name','user_created.first_name as created_first_name','user_created.last_name as created_last_name')
                                            ->with('template')
                                            ->leftjoin('users as user_assiged','user_assiged.id','email_blast.assigned_id')
                                            ->leftjoin('users as user_created','user_created.id','email_blast.email_blast_created_id')
                                            ->where('email_blast.send_id',$admin_name->id)
                                            ->OrWhere('email_blast.assigned_id',$user->id)
                                            ->orderby('id','desc')
                                            ->get();

            $assigned_column = "admin_email";
            $total_leads = $admin_name->email;

            $check_permission = Permissionallowed::where('user_id', $admin_name->id)->first(['lead_structure']);

            if($check_permission != null)
            {
                if($check_permission->lead_structure == 'assigned')
                {
                    $assigned_column = "assigned_user_id";
                    $assigned_agents = $user->id;
                }
                else
                {
                    $assigned_column = "admin_email";
                    $assigned_agents =  $admin_name->email;
                }
            }
            else{
                $assigned_column = "admin_email";
                $assigned_agents =  $admin_name->email;
            }

            $total_leads = Lead::where('lead_status','Active-Fresh')
                ->where($assigned_column,$assigned_agents)
                ->count('*');

            $get_admin = User::where('id',$user->id)
                ->first();

            $agents = User::select('id','first_name','last_name')
                ->where('id',$user->id)
                ->get();

            $total_leads_provider = Lead::select('leads.lead_provider')
                ->where('leads.lead_provider','!=','')
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as count, lead_provider')
                ->where($assigned_column,$assigned_agents)
                ->having('count','>=','1')
                ->orderby('leads.lead_provider','asc')
                ->get();
            $get_dedicated_number = null;
            $dedicated_number = null;

            $get_dedicated_admin = User::where('id',$user->id)->first(['parent_user_id']);
            $get_dedicated_number = Companyinfo::where('user_id',$get_dedicated_admin->parent_user_id)->first(['phone_number']);

            $dedicated_number = $get_dedicated_number->phone_number;
            if(  preg_match( '/^\+\d(\d{3})(\d{3})(\d{4})$/', $dedicated_number,  $matches ) )
            {
                $dedicated_number = '('.$matches[1] . ') ' .$matches[2] . '-' . $matches[3];
            }

            return $this->sendResponse([
                'email-blast-view' => $get_lead_blast,
                'total-leads' => $total_leads,
                'agents' => $agents,
                'total_lead_provider' => $total_leads_provider,
                'dedicated_number' => $dedicated_number,
            ],'email-blast-view');

        }
        
    }

    public function emailBlastPost(Request $request){
           
            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            $date_from = date('Y-m-d', strtotime($request->schedule_time_from));
            $date_to = date('Y-m-d', strtotime($request->schedule_time_to));


            $validate = $request->validate([
                'sendat' => 'required',
                'leadprovider' => 'required',
                'type' => 'required',
                'target_status' => 'required',
                'schedule_time_from' => 'required',
                'schedule_time_to' => 'required',
            ]);

            if($request->type == "All"){
                $type = 0 ;
            }
            else {
                $type = $request->type;
            }

            $message_filter = date('m/d/Y', strtotime($request->schedule_time_from))." - ".date('m/d/Y', strtotime($request->schedule_time_to));

            $email_attachment = null;
            $email_attachment_type = null;

            if($request->email_body != null || $request->email_body != '')
            {
                $email_attachment = $request->email_body;
                $email_attachment_type = $request->email_type;
            }
            
            if($request->template_id != null || $request->template_id != '')
            {
                $tempId = $request->template_id;
            }else{
                $tempId  = null;
            }


            $target_status = explode(',',$request->target_status);
            $target_status_seperator = implode(', ', $target_status);

            $provider = explode(',',$request->leadprovider);
            $leadprovider =  implode(', ', $provider);

//            $target_status_seperator = $request->target_status;
//            $leadprovider = $request->leadprovider;

            $sender_id  = null;
            $sender_id = $request->senderid;


            
                if($request->assignedto != '' && $request->assignedto != 0)
                {
                    $assign_agent_id = $request->assignedto;
                }
                else
                {
                    $assign_agent_id = $user->id;
                }

            $audienceValMax = 'no';
            if($request->audienceVal > 400)
            {
                $audienceValMax = $request->audienceVal;
            }

            $blast = [
                'template_id'  => $tempId,
                'campaign_name' => $request->campaign_name,
                'send_limit' => $request->audienceVal,
                'send_at' => $request->sendat,
                'lead_provider' => $leadprovider,
                'message_filter' => $message_filter,
                'email_status' => 'Pending',
                'type' => $type,
                'target_status' => $target_status_seperator,
                'subject' => $request->subject,
                'message_description' => $request->messagedescription,
                'is_attachment' => $email_attachment_type,
                'attachments' => $email_attachment,
                'assigned_id' => $assign_agent_id,
                'send_id' => $sender_id,
                'date_from' => $date_from,
                'date_to' => $date_to,
                'email_blast_created_id' =>$user->id,
                'max_blast' => $audienceValMax,
                "is_activated" => 'yes'
            ];


            $insert_lead_blast = Emailblast::insertGetId($blast);

            $this->blastPercentage($insert_lead_blast);

            if($insert_lead_blast){
                return  response()->json([
                    'success' => true,
                    'message' => 'Blast added successfully',
                ]);


            }
            else{
                return  response()->json([
                    'success' => false,
                    'message' => 'Something went wrong',
                ]);

            }

    }

    public function emailBlastUpdate(Request $request){



            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

            $date_from = date('Y-m-d', strtotime($request->schedule_time_from_edit));
            $date_to = date('Y-m-d', strtotime($request->schedule_time_to_edit));

            $sender_id  = null;
            $sender_id = $request->editsenderid;
            $message_filter = date('m/d/Y', strtotime($request->schedule_time_from_edit))." - ".date('m/d/Y', strtotime($request->schedule_time_to_edit));

            $email_attachment = null;
            $email_attachment_type = null;

            if($request->email_body != null || $request->email_body != '')
            {
                $email_attachment = $request->email_body;
                $email_attachment_type = $request->email_type;
            }
            if($request->edittype == "All"){
                $type = 0 ;
            }
            else {
                $type = $request->edittype;
            }
            
            if($request->template_id != null || $request->template_id != '')
            {
                $tempId = $request->template_id;
            }else{
                $tempId  = null;
            }

//            if($user->usertype_id == 2){
//
//                $request->editassignedto = $user->id;
//            }

    
                if($request->editassignedto != '' && $request->editassignedto != 0)
                {
                    $assign_agent_id = $request->editassignedto;
                }
                else
                {
                    $assign_agent_id = $user->id;
                }


            $audienceValMax = 'no';
            if($request->editaudienceVal > 400)
            {
                $audienceValMax = $request->editaudienceVal;
            }

            $target_status = explode(',',$request->edittarget_status);
            $target_status_seperator = implode(', ', $target_status);

            $provider = explode(',',$request->editleadprovider);
            $leadprovider =  implode(', ', $provider);


            $blast = [
                'template_id'   =>  $tempId,
                'campaign_name' => $request->campaign_name,
                'subject'       => $request->subject,
                'send_limit'    => $request->editaudienceVal,
                'send_at'       => $request->editsendat,
                'lead_provider' => $leadprovider,
                'message_filter' => $message_filter,
                'email_status' => 'Pending',
                'type' => $type,
                'target_status' => $target_status_seperator,
                'message_description' => $request->editmessagedescription,
                'is_attachment' => $email_attachment_type,
                'attachments' => $email_attachment,
                'assigned_id' => $assign_agent_id,
                'send_id' => $sender_id,
                'date_from' =>$date_from,
                'date_to' => $date_to,
                'email_blast_created_id' =>$user->id,
                'max_blast' => $audienceValMax,
                "is_activated" => 'yes'
            ];
//            dd($blast);

            $update_lead_blast = Emailblast::where('id',$request->editleadblastid)->update($blast);

            $this->blastPercentage($request->editleadblastid);

            if($update_lead_blast){
                return response()->json([
                        'success' => true,
                        'message' => 'Blast campaign update successfully',
                    ],200);
            }else{
                return response()->json([
                        'success' => false,
                        'message' => 'No changes made to update campaign!',
                    ],401);
            }

    }

    public function blastPercentage($blast_id)
    {
        $admin_id = null;
        $get_lead_blast = Emailblast::select('email_blast.*','users.id as user_id','users.usertype_id as usertype_id')
            ->leftjoin('users','users.id','email_blast.assigned_id')
            ->where('email_blast.id',$blast_id)
            ->get();

        if($get_lead_blast->count() > 0)
        {
            foreach ($get_lead_blast as $leadblast) {
                $splitStatus = explode(', ', $leadblast->target_status);
                $splitDate = explode(' - ', $leadblast->message_filter);

                $startdate = date("Y-m-d", strtotime($splitDate[0]));
                $enddate = date("Y-m-d", strtotime($splitDate[1]));

                if($leadblast->usertype_id == 2){
                    $get_admin_email = User::where('id',$leadblast->user_id)->first();
                    $admin_id = $leadblast->user_id;

                    if($leadblast->lead_provider != "0"){
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->where('lead_provider',$leadblast->lead_provider)
                            ->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)
                            ->whereIn('lead_status',$splitStatus)
                            ->skip(0)->take($leadblast->send_limit)
                            ->get();
                    }
                    else{
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)
                            ->whereIn('lead_status',$splitStatus)
                            ->skip(0)->take($leadblast->send_limit)
                            ->get();
                    }
                }
                else{
                    $get_agent = User::where('id',$leadblast->user_id)->first();
                    $admin_id = $get_agent->parent_user_id;
                    $get_admin_email = User::where('id',$get_agent->parent_user_id)->first();

                    if($leadblast->lead_provider != "0"){
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->where('lead_provider',$leadblast->lead_provider)
                            ->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)
                            ->whereIn('lead_status',$splitStatus)
                            ->skip(0)->take($leadblast->send_limit)
                            ->get();
                    }else{
                        $leads = Lead::where('admin_email',$get_admin_email->email)
                            ->whereDate('created_at','>=',$startdate)->whereDate('created_at','<=',$enddate)
                            ->whereIn('lead_status',$splitStatus)
                            ->skip(0)->take($leadblast->send_limit)
                            ->get();
                    }
                }

                $leads_id = array();
                $count = 1;
                foreach($leads as $lead){

                    for($i = 0; $i < count($splitStatus); $i++){

                        $leads_id[] .= $lead->id;

                    }
                    $count++;

                }

                $check_blast_exist = Blastpercentage::where('blast_id',$blast_id)->where('blast_type','email')->first(['blast_id']);

                if($check_blast_exist == null)
                {
                    Blastpercentage::insert(['blast_id' => $blast_id,'user_id' => $admin_id,'blast_type' => 'email', 'leads_id' => implode(",",$leads_id)]);
                    return "true";
                }
                else
                {
                    Blastpercentage::where('blast_id', $blast_id)->update(['user_id' => $admin_id, 'leads_id' => implode(",",$leads_id)]);
                    return "true";
                }


            }
        }
    }

    public function emailBlastDelete(Request $request){

                $check_lead_blast = Emailblast::where('id',$request->leadblastid)->delete();

                Blastpercentage::where('blast_id',$request->leadblastid)->where('blast_type','email')->delete();


                if($check_lead_blast){
                    return response()->json([
                        'success' => true,
                        'message' => 'Email Blast Remove Successfully',
                    ]);
                }
                else{
                    return response()->json([
                       'success' => false,
                       'message' => 'Something went wrong while deleting',
                    ]);
                }

    }

    public function emailBlastImageFile(Request $request){
            
            $countfiles = count($_FILES['files']['name']);
            $files_arr = array();
            $shortener = app('url.shortener');
            $upload_location = "./asset/chat-assets/images/blast";
            for($index = 0;$index < $countfiles;$index++){
                if(isset($_FILES['files']['name'][$index]) && $_FILES['files']['name'][$index] != ''){
                    // File name
                    $filename = $_FILES['files']['name'][$index];
                    // Get extension
                    $ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
                    // Valid image extension
                    $valid_ext = array("png","jpeg","jpg");
                    $new_name = rand() . '.' .$ext;

                    // Check extension
                    if(in_array($ext, $valid_ext)){
                        $path = $upload_location.$new_name;
                        $completePath = url('/').'/asset/chat-assets/images/blast'.$new_name;
                        $shortUrl = $shortener->driver('is_gd')->shorten($completePath);
                        if(move_uploaded_file($_FILES['files']['tmp_name'][$index],$path)){
                            $files_arr[] = $shortUrl;
                        }
                    }
                }
            }


            return $this->sendResponse([
                'image_links' => $files_arr,
            ],'image_links');

    }
    
    public function emailblastTemplates(){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        if($user->usertype_id == 2){
            $emailTemp  =  EmailTemplate::whereIn('user_id',[1,auth()->user()->id])->get();
        }elseif($user->usertype_id == 4){
            $admin  = User::where('id',$user->parent_user_id)->first();
            $emailTemp  =  EmailTemplate::whereIn('user_id',[1,$admin->id])->get();
        }
        
        return $this->sendResponse([
                'email-templates' => $emailTemp,
            ],'email-templates');
    }

}