<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\Leadblast;
use App\Mmsblast;
use App\Emailblast;
use App\Voicemailblast;
use App\Leadchat;
use App\Leadlog;
use App\Contactemail;
use App\NinjaAssign;
use App\LeadAppointment;
use App\Leadreminder;
use App\Companyinfo;
use App\Creditpdf;
use App\Appraisevehicle;
use Carbon\Carbon;
use DB;
use Illuminate\Support\Facades\Cache;

class DashboardController extends BaseController{
      
    public function appointmentview(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['usertype_id','id','email']);

        if($user->usertype_id == 2){

            $get_appointments = LeadAppointment::with(['lead' => function($query){
                                                    $query->with(['leadInventory'])->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                                                          ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                                          ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip');
                                                }])->select('lead_appointment.id','lead_appointment.lead_id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','lead_appointment.set_appointment','lead_appointment.start_date','lead_appointment.end_date')
                                                ->leftjoin('leads','leads.id','lead_appointment.lead_id')
                                                ->where('leads.admin_email',$user->email)
                                                ->get();
        }
        elseif($user->usertype_id == 4){
            $get_appointments = LeadAppointment::with(['lead' => function($query){
                                                    $query->with(['leadInventory'])->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                                                          ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                                          ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip');
                                                }])->select('lead_appointment.id','lead_appointment.lead_id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','lead_appointment.set_appointment','lead_appointment.start_date','lead_appointment.end_date')
                                                ->leftjoin('leads','leads.id','lead_appointment.lead_id')
                                                ->where('leads.assigned_user_id',$user->id)
                                                ->get();
        }


        return response()->json([
                'success' => true,
                'data'    => $get_appointments
            ]);
        // return $this->sendResponse([
        //     'appointment_view' => $get_appointments
        // ],'Appointment view');

    }

    public function agents(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first('id');

        $user_data = User::select('users.id','users.first_name','users.last_name','users.email','users.phone_number')
            ->leftjoin('usertypes','usertypes.id','users.usertype_id')
            ->where('parent_user_id',$user->id)
            ->orderby('id','desc')
            ->get();
            
        return $this->sendResponse([
            'agents' => $user_data
        ],'agents');
    }

    public function  todayActivityFilter(Request $request){

         $startdate = date("Y-m-d", strtotime($request->from));
         $enddate = date("Y-m-d", strtotime($request->to));

         $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['usertype_id','id','parent_user_id','email']);

         if ($user->usertype_id == 2){

             $get_ninjas_ids = $get_ninjas_ids = array($user->parent_user_id);
             $get_assign_ninja = NinjaAssign::where('user_id',$user->parent_user_id)->where('assign_status','yes')->pluck('ninja_id')->toArray();

             if(count($get_assign_ninja) > 0){
                 $get_ninjas_ids = $get_assign_ninja;
                 $ninja_assigned = true;
             }else{
                 $ninja_assigned = false;
             }

             $agents_ids = array('0');
             $total_agents = DB::table('users')->select()->where('parent_user_id', $user->parent_user_id)->pluck('id')->toArray();
             if(count($total_agents) > 0){
                 $agents_ids = $total_agents;
             }
             
            if ($request->from != null){

                 $chat_collection = Leadchat::select(['message_length','id','type','ringless_voicemail','mms_attachments'])->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->where('sender_id',$user->id)->get();
                 $chat_collection_admin = Leadchat::select(['message_length','id','type','ringless_voicemail','mms_attachments','sender_id'])->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->where('admin_id',$user->parent_user_id)->get();

                 $today_leads = Lead::where('admin_email', $user->email)->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->count('id');
                 $today_appt_collection = Lead::select(['lead_status'])->where('admin_email', $user->email)->WhereDate('updated_at', ">=", $startdate)->WhereDate('updated_at', "<=", $enddate)->get();
                 $today_lead_blast = Leadblast::where('send_id',$user->id)->where('message_status', 'Sent')->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->count('id');
                 $today_mms_blast = Mmsblast::where('send_id',$user->id)->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->count('id');
                 $today_email_blast = Emailblast::where('send_id',$user->id)->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->count('id');
                 $today_ringless_voicemail_blast = Voicemailblast::where('send_id',$user->id)->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->count('id');

            }else{

                 $chat_collection = Leadchat::select(['message_length','id','type','ringless_voicemail','mms_attachments'])->whereDate('created_at', date('Y-m-d'))->where('sender_id',$user->id)->get();
                 $chat_collection_admin = Leadchat::select(['message_length','id','type','ringless_voicemail','mms_attachments','sender_id'])->whereDate('created_at', date('Y-m-d'))->where('admin_id',$user->parent_user_id)->get();

                 $today_leads = Lead::where('admin_email', $user->email)->whereDate('created_at', date('Y-m-d'))->count('id');
                 $today_appt_collection = Lead::select(['lead_status'])->where('admin_email', $user->email)->whereDate('updated_at', date('Y-m-d'))->get();
                 $today_lead_blast = Leadblast::where('send_id',$user->id)->where('message_status', 'Sent')->whereDate('created_at', date('Y-m-d'))->count('id');
                 $today_mms_blast = Mmsblast::where('send_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id');
                 $today_email_blast = Emailblast::where('send_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id');
                 $today_ringless_voicemail_blast = Voicemailblast::where('send_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id');
            }

             $today_appt_set = $today_appt_collection->where('lead_status','Appointment-Set')->count('id');
             $today_appt_showup = $today_appt_collection->where('lead_status','Appointment-Showed')->count('id');
             $today_sold = $today_appt_collection->whereIn('lead_status',['Sold-Unknown','Sold-Used','Sold-New'])->count('id');


             $total_agent_text_sent = 0;
             $total_agent_mms_sent = 0;
             $total_agent_ringless_voicemail_sent = 0;

             if($request->type == "sms")
             {
                $total_text = $chat_collection->where('ringless_voicemail',null)->where('mms_attachments',null)->where('type','sent')->sum('message_length');
                $total_text_received = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments',null)->where('type','received')->sum('message_length');
                $today_robo_text = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments',null)->where('sender_id',null)->where('type',null)->sum('message_length');
                
                $total_agent_text = $chat_collection_admin->where('ringless_voicemail',"=",null)->where('mms_attachments',null)->where('type','sent')->whereIn('sender_id', $agents_ids)->sum('message_length');
                $total_agent_text_sent = $total_agent_text_sent + $total_agent_text;
                // Ninja SMS sent and received
                if($ninja_assigned == "true"){
                    $today_ninja_text = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments',null)->where('type','sent')->whereIn('sender_id',$get_ninjas_ids)->sum('message_length');
                }else{
                    $today_ninja_text = 0;
                }
                    
                return $this->sendResponse([
                     'totalSent' => ( $total_text + $today_robo_text ),
                     'you_sent' => $total_text,
                     'robo_sent' => $today_robo_text,
                     'ninja_sent' => $today_ninja_text,
                     'agent_sent' => $total_agent_text_sent,
                     'received' => $total_text_received,
                     'leads'   => $today_leads,
                     'appt_set' => $today_appt_set,
                     'appt_showup' => $today_appt_showup,
                     'sms_blast' => $today_lead_blast,
                     'mms_blast'  => $today_mms_blast,
                     'email_blast' => $today_email_blast,
                     'ringless_voicemail_blast' => $today_ringless_voicemail_blast,
                     'ninja_assigned'    => $ninja_assigned,
                     'is_type' => 'sms'
                 ],'Desklogs data');

             }elseif ($request->type == "mms"){


                $total_mms = $chat_collection->where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('type','sent')->count('id');
                $total_mms_received = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('type','received')->count('id');
                $total_robo_mms = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('sender_id',null)->where('type',null)->count('id');
                
                $total_agent_mms = $chat_collection_admin->where('mms_attachments',"!=",null)->where('ringless_voicemail',"=",null)->where('type','sent')->whereIn('sender_id', $agents_ids)->count('id');
                $total_agent_mms_sent = $total_agent_mms_sent + $total_agent_mms;
                // Ninja SMS sent and received
                if($ninja_assigned == "true"){
                    $total_ninja_mms = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->whereIn('sender_id',$get_ninjas_ids)->where('type','sent')->count('id');
                }else{
                    $total_ninja_mms = 0;
                }
                
                 return $this->sendResponse([
                     'totalSent' => ( $total_mms + $total_robo_mms ),
                     'you_sent' => $total_mms,
                     'robo_sent' => $total_robo_mms,
                     'ninja_sent' => $total_ninja_mms,
                     'agent_sent' => $total_agent_mms_sent,
                     'received' => $total_mms_received,
                     'leads'   => $today_leads,
                     'appt_set' => $today_appt_set,
                     'appt_showup' => $today_appt_showup,
                     'sms_blast' => $today_lead_blast,
                     'mms_blast'  => $today_mms_blast,
                     'email_blast' => $today_email_blast,
                     'ringless_voicemail_blast' => $today_ringless_voicemail_blast,
                     'ninja_assigned'    => $ninja_assigned,
                     'is_type' => 'mms'
                 ],'Desklogs data');
             }elseif($request->type == "rvm"){

                $total_ringless_voicemail = $chat_collection->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->count('id');
                
                $total_robo_ringless_voicemail = $chat_collection_admin->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('sender_id',null)->where('type',null)->count('id');
                $total_agent_ringless_voicemail = $chat_collection_admin->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->where('sender_id', $agents_ids)->count('id');
                $total_agent_ringless_voicemail_sent = $total_agent_ringless_voicemail_sent + $total_agent_ringless_voicemail;
                
                // Ninja SMS sent and received
                if($ninja_assigned == "true"){
                    $today_ninja_ringless_voicemail = $chat_collection_admin->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->whereIn('sender_id',$get_ninjas_ids)->count('id');
                }else{
                    $today_ninja_ringless_voicemail = 0;
                }
                
                return $this->sendResponse([
                     'totalSent' => ( $total_ringless_voicemail + $total_robo_ringless_voicemail ),
                     'you_sent' => $total_ringless_voicemail,
                     'robo_sent' => $total_robo_ringless_voicemail,
                     'ninja_sent' => $today_ninja_ringless_voicemail,
                     'agent_sent' => $total_agent_ringless_voicemail_sent,
                     'received' => 0,
                     'leads'   => $today_leads,
                     'appt_set' => $today_appt_set,
                     'appt_showup' => $today_appt_showup,
                     'sms_blast' => $today_lead_blast,
                     'mms_blast'  => $today_mms_blast,
                     'email_blast' => $today_email_blast,
                     'ringless_voicemail_blast' => $today_ringless_voicemail_blast,
                     'ninja_assigned'    => $ninja_assigned,
                     'is_type' => 'rvm'
                ],'Desklogs data');
             }elseif ($request->type == "email"){
                 if ($request->from != null){
                     $email_collection = Contactemail::select(['id','robo_text','type','sender_id'])->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->where('sender_id',$user->id)->get();
                 }else{
                     $email_collection = Contactemail::select(['id','robo_text','type','sender_id'])->whereDate('created_at', date('Y-m-d'))->where('sender_id',$user->id)->get();
                 }

                $total_email = $email_collection->where('type','sent')->where('robo_text', 'no')->count('id');
                $total_email_received = $email_collection->where('type','received')->count('id');
                $total_robo_email = $email_collection->where('type', 'sent')->whereIn('robo_text', ['yes','workflow','robo'])->count('id');
                
                $total_agent_email = $email_collection->where('type', 'sent')->where('robo_text', 'no')->whereIn('sender_id', $agents_ids)->count('id');
                // Ninja SMS sent and received
                if($ninja_assigned == "true"){
                    $total_ninja_email = $email_collection->where('type', 'sent')->where('robo_text', 'no')->whereIn('sender_id',$get_ninjas_ids)->count('id');
                }else{
                    $total_ninja_email = 0;
                }

                return $this->sendResponse([
                     'totalSent' => ( $total_email + $total_robo_email ),
                     'you_sent' => $total_email,
                     'robo_sent' => $total_robo_email,
                     'ninja_sent' => $total_ninja_email,
                     'agent_sent' => $total_agent_email,
                     'received' => $total_email_received,
                     'leads'   => $today_leads,
                     'appt_set' => $today_appt_set,
                     'appt_showup' => $today_appt_showup,
                     'sms_blast' => $today_lead_blast,
                     'mms_blast'  => $today_mms_blast,
                     'email_blast' => $today_email_blast,
                     'ringless_voicemail_blast' => $today_ringless_voicemail_blast,
                     'ninja_assigned'    => $ninja_assigned,
                     'is_type' => 'email'
                 ],'Desklogs data');
             }else{
                 if ($request->from != null){
                     $logs_collection = Leadlog::select(['id','status'])->where('sender_id',$user->id)->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->get();
                 }else{
                     $logs_collection = Leadlog::select(['id','status'])->where('sender_id',$user->id)->whereDate('created_at', date('Y-m-d'))->get();
                 }

                 $total_log_received = $logs_collection->where('status','=','incoming')->count('id');
                 $total_log = $logs_collection->where('status','outbound')->count('id');

                 return $this->sendResponse([
                     'totalSent' => $total_log,
                     'you_sent' => $total_log,
                     'robo_sent' => 0,
                     'ninja_sent' => 0,
                     'agent_sent' => 0,
                     'received' => $total_log_received,
                     'leads'   => $today_leads,
                     'appt_set' => $today_appt_set,
                     'appt_showup' => $today_appt_showup,
                     'sms_blast' => $today_lead_blast,
                     'mms_blast'  => $today_mms_blast,
                     'email_blast' => $today_email_blast,
                     'ringless_voicemail_blast' => $today_ringless_voicemail_blast,
                     'ninja_assigned'    => $ninja_assigned,
                     'is_type' => 'call'
                 ],'Desklogs data');
             }


         }elseif($user->usertype_id == 4){
             // new code
             $get_ninjas_ids = $get_ninjas_ids = array($user->parent_user_id);
             $get_assign_ninja = NinjaAssign::where('user_id',$user->parent_user_id)->where('assign_status','yes')->pluck('ninja_id')->toArray();
             $get_admin_email = User::where('id',$user->parent_user_id)->first(['first_name','last_name','email']);
             if(count($get_assign_ninja) > 0){
                 $get_ninjas_ids = $get_assign_ninja;
                 $ninja_assigned = true;
             }else{
                 $ninja_assigned = false;
             }
             
             if ($request->from != null){

                 $chat_collection = Leadchat::select(['message_length','id','type','ringless_voicemail','mms_attachments'])->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->where('sender_id',$user->id)->get();
                 $chat_collection_admin = Leadchat::select(['message_length','id','type','ringless_voicemail','mms_attachments','sender_id'])->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->where('admin_id',$user->parent_user_id)->get();

                 $today_leads = Lead::where('admin_email', $get_admin_email->email)->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->count('id');
                 $today_appt_collection = Lead::select(['lead_status'])->where('admin_email', $get_admin_email->email)->WhereDate('updated_at', ">=", $startdate)->WhereDate('updated_at', "<=", $enddate)->get();
                 $today_lead_blast = Leadblast::where('send_id',$user->parent_user_id)->where('message_status', 'Sent')->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->count('id');
                 $today_mms_blast = Mmsblast::where('send_id',$user->parent_user_id)->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->count('id');
                 $today_email_blast = Emailblast::where('send_id',$user->parent_user_id)->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->count('id');
                 $today_ringless_voicemail_blast = Voicemailblast::where('send_id',$user->parent_user_id)->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->count('id');

             }else{

                 $chat_collection = Leadchat::select(['message_length','id','type','ringless_voicemail','mms_attachments'])->whereDate('created_at', date('Y-m-d'))->where('sender_id',$user->id)->get();
                 $chat_collection_admin = Leadchat::select(['message_length','id','type','ringless_voicemail','mms_attachments','sender_id'])->whereDate('created_at', date('Y-m-d'))->where('admin_id',$user->parent_user_id)->get();

                 $today_leads = Lead::where('admin_email', session()->get('parentemail'))->whereDate('created_at', date('Y-m-d'))->count('id');
                 $today_appt_collection = Lead::select(['lead_status'])->where('admin_email', session()->get('parentemail'))->whereDate('updated_at', date('Y-m-d'))->get();
                 $today_lead_blast = Leadblast::where('send_id',$user->parent_user_id)->where('message_status', 'Sent')->whereDate('created_at', date('Y-m-d'))->count('id');
                 $today_mms_blast = Mmsblast::where('send_id',$user->parent_user_id)->whereDate('created_at', date('Y-m-d'))->count('id');
                 $today_email_blast = Emailblast::where('send_id',$user->parent_user_id)->whereDate('created_at', date('Y-m-d'))->count('id');
                 $today_ringless_voicemail_blast = Voicemailblast::where('send_id',$user->parent_user_id)->whereDate('created_at', date('Y-m-d'))->count('id');

             }

             $today_appt_set = $today_appt_collection->where('lead_status','Appointment-Set')->count('id');
             $today_appt_showup = $today_appt_collection->where('lead_status','Appointment-Showed')->count('id');
             $today_sold = $today_appt_collection->whereIn('lead_status',['Sold-Unknown','Sold-Used','Sold-New'])->count('id');

             if($request->type == "sms")
             {
                 $total_text = $chat_collection->where('ringless_voicemail',null)->where('mms_attachments',null)->where('type','sent')->sum('message_length');
                 $total_text_received = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments',null)->where('type','received')->sum('message_length');
                 $today_robo_text = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments',null)->where('sender_id',null)->where('type',null)->sum('message_length');
                 

                // Ninja SMS sent and received
                if($ninja_assigned == "true"){
                    $today_ninja_text = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments',null)->where('type','sent')->whereIn('sender_id',$get_ninjas_ids)->sum('message_length');
                }else{
                    $today_ninja_text = 0;
                }
                 return $this->sendResponse([
                     'totalSent' => ( $total_text + $today_robo_text +$today_ninja_text ),
                     'you_sent' => $total_text,
                     'robo_sent' => $today_robo_text,
                     'ninja_sent' => $today_ninja_text,
                     'agent_sent' => 0,
                     'received' => $total_text_received,
                     'leads'   => $today_leads,
                     'appt_set' => $today_appt_set,
                     'appt_showup' => $today_appt_showup,
                     'sold'             => $today_sold,
                     'sms_blast' => $today_lead_blast,
                     'mms_blast'  => $today_mms_blast,
                     'email_blast' => $today_email_blast,
                     'ringless_voicemail_blast' => $today_ringless_voicemail_blast,
                     'ninja_assigned'    => $ninja_assigned,
                     'is_type' => 'sms'
                 ],'Desklogs data');
             }
             elseif($request->type == "mms")
             {
                 $total_mms = $chat_collection->where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('type','sent')->count('id');
                 $total_mms_received = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('type','received')->count('id');
                 $total_robo_mms = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('sender_id',null)->where('type',null)->count('id');
                 
                // Ninja SMS sent and received
                if($ninja_assigned == "true"){
                    $total_ninja_mms = $chat_collection_admin->where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->whereIn('sender_id',$get_ninjas_ids)->where('type','sent')->count('id');
                }else{
                    $today_ninja_text = 0;
                }
                
                 return $this->sendResponse([
                     'totalSent' => ( $total_mms + $total_robo_mms ),
                     'you_sent' => $total_mms,
                     'robo_sent' => $total_robo_mms,
                     'ninja_sent' => $total_ninja_mms,
                     'agent_sent' => 0,
                     'text_received' => $total_mms_received,
                     'leads'   => $today_leads,
                     'appt_set' => $today_appt_set,
                     'appt_showup' => $today_appt_showup,
                     'sms_blast' => $today_lead_blast,
                     'mms_blast'  => $today_mms_blast,
                     'email_blast' => $today_email_blast,
                     'ringless_voicemail_blast' => $today_ringless_voicemail_blast,
                     'ninja_assigned'    => $ninja_assigned,
                     'is_type' => 'mms'
                 ],'Desklogs data');
             }
             elseif($request->type == "rvm")
             {
                 $total_ringless_voicemail = $chat_collection->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->count('id');
                 
                 $total_robo_ringless_voicemail = $chat_collection_admin->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('sender_id',null)->where('type',null)->count('id');

                // Ninja SMS sent and received
                if($ninja_assigned == "true"){
                    $today_ninja_ringless_voicemail = $chat_collection_admin->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->whereIn('sender_id',$get_ninjas_ids)->count('id');
                }else{
                    $today_ninja_ringless_voicemail = 0;
                }
                
                 return $this->sendResponse([
                     'totalSent' => ( $total_ringless_voicemail + $total_robo_ringless_voicemail ),
                     'you_sent' => $total_ringless_voicemail,
                     'robo_sent' => $total_robo_ringless_voicemail,
                     'ninja_sent' => $today_ninja_ringless_voicemail,
                     'received' => 0,
                     'agent_sent' => 0,
                     'leads'   => $today_leads,
                     'appt_set' => $today_appt_set,
                     'appt_showup' => $today_appt_showup,
                     'sms_blast' => $today_lead_blast,
                     'mms_blast'  => $today_mms_blast,
                     'email_blast' => $today_email_blast,
                     'ringless_voicemail_blast' => $today_ringless_voicemail_blast,
                     'ninja_assigned'    => $ninja_assigned,
                     'is_type' => 'rvm'
                 ],'Desklogs data');
             }
             elseif($request->type == "email")
             {
                 $email_collection = DB::table('contact_email')->select(['id','robo_text','type','sender_id'])->whereDate('created_at', date('Y-m-d'))->where('sender_id',session()->get('parentid'))->get();
                 $total_email = $email_collection->where('type','sent')->where('robo_text', 'no')->count('id');
                 $total_email_received = $email_collection->where('type','received')->count('id');
                 $total_robo_email = $email_collection->where('type', 'sent')->whereIn('robo_text', ['yes','workflow','robo'])->count('id');
                 
                // Ninja SMS sent and received
                if($ninja_assigned == "true"){
                    $total_ninja_email = $email_collection->where('type', 'sent')->where('robo_text', 'no')->whereIn('sender_id',$get_ninjas_ids)->count('id');
                }else{
                    $total_ninja_email = 0;
                }
                 return $this->sendResponse([
                     'totalSent' => ( $total_email + $total_robo_email ),
                     'you_sent' => $total_email,
                     'robo_sent' => $total_robo_email,
                     'ninja_sent' => $total_ninja_email,
                     'agent_sent' => 0,
                     'received' => $total_email_received,
                     'leads'   => $today_leads,
                     'appt_set' => $today_appt_set,
                     'appt_showup' => $today_appt_showup,
                     'sms_blast' => $today_lead_blast,
                     'mms_blast'  => $today_mms_blast,
                     'email_blast' => $today_email_blast,
                     'ringless_voicemail_blast' => $today_ringless_voicemail_blast,
                     'ninja_assigned'    => $ninja_assigned,
                     'is_type' => 'email'
                 ],'Desklogs data');
             }
             else
             {
                 $logs_collection = DB::table('lead_logs')->select(['id','status'])->where('sender_id',session()->get('parentid'))->whereDate('created_at', date('Y-m-d'))->get();
                 $total_log_received = $logs_collection->where('status','=','incoming')->count('id');
                 $total_log = $logs_collection->where('status','outbound')->count('id');

                 return $this->sendResponse([
                     'totalSent' => $total_log,
                     'you_sent' => $total_log,
                     'robo_sent' => 0,
                     'ninja_sent' => 0,
                     'text_received' => $total_log_received,
                     'leads'   => $today_leads,
                     'appt_set' => $today_appt_set,
                     'appt_showup' => $today_appt_showup,
                     'sms_blast' => $today_lead_blast,
                     'mms_blast'  => $today_mms_blast,
                     'email_blast' => $today_email_blast,
                     'ringless_voicemail_blast' => $today_ringless_voicemail_blast,
                     'ninja_assigned'    => $ninja_assigned,
                     'is_type' => 'call'
                 ],'Desklogs data');
             }
         }

    }

    public function todayActivity(Request $request){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['usertype_id','id']);

        $today_robo_text = null;
        $today_ninja_text = null;
        $total_ninja_mms = null;
        $total_agent_text_sent = 0;
        $total_agent_mms_sent = 0;
        $total_agent_ringless_voicemail_sent = 0;
        $total_robo_email = 0;
        $total_ninja_email = 0;
        $total_agent_email = 0;
        $total_robo_ringless_voicemail = 0;

        if($user->usertype_id == 2){
            $get_ninjas_ids =array();
            $check_ninja = "yes";
            $get_assign_ninja = NinjaAssign::where('user_id',$user->id)->where('assign_status','yes')->get();
            if($get_assign_ninja->count()){
                $get_ninjas_ids = $get_assign_ninja->pluck('ninja_id')->toArray();
            }
            else{
                $get_ninjas_ids = array(auth()->user()->id);
                $check_ninja = "no";
            }


            $total_text = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->whereDate('created_at', date('Y-m-d'))->where('type','sent')->where('sender_id',$user->id)->sum('message_length');
            $total_mms =  Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('type','sent')->where('sender_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id');
            $total_log =  Leadlog::whereDate('created_at', date('Y-m-d'))->where('status','outbound')->where('sender_id',$user->id)->count('id');

            $total_ringless_voicemail =  Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->where('sender_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id'); 

            $total_email =  Contactemail::whereDate('created_at', date('Y-m-d'))->where('sender_id',$user->id)->where('type','sent')->where('robo_text', 'no')->count('id'); 
            $total_text_received =  Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('to',$user->companyinfo->phone_number)->where('type','received')->whereDate('created_at', date('Y-m-d'))->sum('message_length'); 
            $total_mms_received =  Leadchat::where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('to',$user->companyinfo->phone_number)->where('type','received')->whereDate('created_at', date('Y-m-d'))->count('id'); 
            $total_log_received =  Leadlog::where('to',$user->companyinfo->phone_number)->where('status','incoming')->whereDate('created_at', date('Y-m-d'))->count('id'); 

            $total_email_received =  Contactemail::where('to',$user->companyinfo->suite)->where('type','received')->whereDate('created_at', date('Y-m-d'))->count('id');

            $today_leads =  Lead::where('admin_email',$user->email)->whereDate('created_at', date('Y-m-d'))->count('id'); 

            $today_appt_set =  Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Set')->whereDate('updated_at', date('Y-m-d'))->count('id'); 

            $today_appt_showup =  Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Showed')->whereDate('updated_at', date('Y-m-d'))->count('id'); 

            $today_sold =  Lead::where('admin_email',$user->email)->whereIn('lead_status',['Sold-Unknown','Sold-Used','Sold-New'])->whereDate('updated_at', date('Y-m-d'))->count('id'); 

            $today_lead_blast =  Leadblast::where('send_id',$user->id)->where('message_status', 'Sent')->whereDate('created_at', date('Y-m-d'))->count('id'); 
            $today_mms_blast =  Mmsblast::where('send_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id'); 
            $today_email_blast =  Emailblast::where('send_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id'); 
            $today_ringless_voicemail_blast =  Voicemailblast::where('send_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id'); 

            $total_agents =  User::where('parent_user_id', $user->id)->where('approval','approve')->get(); 

            $agents_ids = array();

            if($total_agents->count() > 0){
                $agents_ids = $total_agents->pluck('id')->toArray();
            }
            else{
                $agents_ids = array($user->id);
            }



            $today_robo_text =  Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('created_at', date('Y-m-d'))->count('id');
            $total_robo_email =  Contactemail::where('type', 'sent')->whereIn('robo_text', ['robo','workflow'])->where('sender_id',$user->id)->whereDate('created_at', date('Y-m-d'))->count('id');
            
            $total_ninja_email =  Contactemail::where('type', 'sent')->where('robo_text', 'no')->where('sender_id',$user->id)->wherein('sender_id',$get_ninjas_ids)->whereDate('created_at', date('Y-m-d'))->count('id');
            
//            $total_agent_email = Cache::rememberForever('total_ninja_email'.implode('_',$get_ninjas_ids),function () use($agents_ids) {
//                return Contactemail::where('type', 'sent')->wherein('robo_text', 'no')->wherein('sender_id', $agents_ids)->whereDate('created_at', date('Y-m-d'))->count('id');
//            });
            $total_robo_mms =  Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('created_at', date('Y-m-d'))->count('id');
            $total_ninja_mms = Leadchat::where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('admin_id',$user->id)->whereIn('sender_id',$get_ninjas_ids)->where('type','sent')->whereDate('created_at', date('Y-m-d'))->count('id'); 
            $total_robo_ringless_voicemail = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->whereDate('created_at', date('Y-m-d'))->count('id'); 

            $today_ninja_ringless_voicemail  =  Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->where('admin_id',$user->id)->wherein('sender_id',$get_ninjas_ids)->whereDate('created_at', date('Y-m-d'))->count('id'); 

            $today_ninja_text =  Leadchat::where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('type','sent')->wherein('sender_id',$get_ninjas_ids)->whereDate('created_at', date('Y-m-d'))->sum('message_length'); 

//            $total_agent_text = Cache::rememberForever('total_agent_text'.implode('_',$get_ninjas_ids),function  () use($agents_ids) { return Leadchat::whereIn('sender_id', $agents_ids)->where('ringless_voicemail',"=",null)->whereDate('created_at', date('Y-m-d'))->count('id');});
//
//            $total_agent_mms = Cache::rememberForever('total_agent_mms'.implode('_',$get_ninjas_ids),function  () use($agents_ids) { return Leadchat::where('mms_attachments',"!=",null)->where('ringless_voicemail',"=",null)->whereIn('sender_id', $agents_ids)->whereDate('created_at', date('Y-m-d'))->count('id');});
//
//            $total_agent_ringless_voicemail = Cache::rememberForever('total_agent_ringless_voicemail'.implode('_',$get_ninjas_ids),function  () use($agents_ids) { return Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('sender_id', $agents_ids)->whereDate('created_at', date('Y-m-d'))->count('id');});



            $get_admin_agents = User::where('parent_user_id', $user->id)->get(['id']);
            $get_agent_ids = $get_admin_agents->pluck('id')->toArray();

            $total_agent_text  = Leadchat::whereDate('created_at', date('Y-m-d'))->where('ringless_voicemail',null)->where('mms_attachments',null)->where('type','sent')->whereIn('sender_id',$get_agent_ids)->sum('message_length');
            $total_agent_mms  = Leadchat::whereDate('created_at', date('Y-m-d'))->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('type','sent')->whereIn('sender_id',$get_agent_ids)->count('id');
            $total_agent_ringless_voicemail  = Leadchat::whereDate('created_at', date('Y-m-d'))->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->whereIn('sender_id',$get_agent_ids)->count('id');
            $total_agent_email = Contactemail::where('type', 'sent')->where('robo_text', 'no')->wherein('sender_id', $get_agent_ids)->whereDate('created_at', date('Y-m-d'))->count('id');


            return $this->sendResponse([
                'total_text' => (int)$total_text ,
                'total_robo_text' => (int)$today_robo_text ,
                'total_ninja_text' => (int)$today_ninja_text ,
                'agent_text_sent' => (int)$total_agent_text,
                'total_text_received' => (int)$total_text_received ,
                'total_mms' => (int)$total_mms,
                'total_robo_mms' => (int)$total_robo_mms,
                'total_ninja_mms' => (int)$total_ninja_mms,
                'total_agent_mms' => (int)$total_agent_mms,
                'all_mms_recieved' => (int)$total_mms_received,
                'total_ringless_voicemail' => (int)$total_ringless_voicemail,
                'total_robo_ringless_voicemail' => (int)$total_robo_ringless_voicemail,
                'today_ninja_ringless_voicemail' => (int)$today_ninja_ringless_voicemail,
                'total_agent_ringless_voicemail' => (int)$total_agent_ringless_voicemail,
                'total_call_log' => (int)$total_log,
                'total_log_received' => (int)$total_log_received,
                'total_email' => (int)$total_email,
                'total_robo_email' => (int)$total_robo_email,
                'total_ninja_email' => (int)$total_ninja_email,
                'total_agent_email' => (int)$total_agent_email,
                'total_email_recieved'=> (int)$total_email_received,
                'Leads'=> (int)$today_leads,
                'Appointement_set'=> (int)$today_appt_set,
                'Appointments_showUp'=> (int)$today_appt_showup,
                'SMS_Blast'=> (int)$today_lead_blast,
                'MMS_Blast'=> (int)$today_mms_blast,
                'Voicemail_Blast'=> (int)$today_ringless_voicemail_blast,
                'Email_Blast'=> (int)$today_email_blast,
                'Sold'=> (int)$today_sold,
                'check_ninja' => $check_ninja,
            ],'Desk logs');
        }
        elseif($user->usertype_id == 4){
            $adminId = User::where('id', $user->id)->value('parent_user_id');
            $adminCompany = Companyinfo::where('user_id', $adminId)->first();

            $total_text =  Leadchat::where('ringless_voicemail', null)->where('mms_attachments', null)->whereDate('created_at', date('Y-m-d'))->where('type', 'sent')->where('sender_id', $user->id)->sum('message_length');
             
            $total_mms =  Leadchat::where('ringless_voicemail', null)->where('mms_attachments', "!=", null)->where('type', 'sent')->where('sender_id', $user->id)->whereDate('created_at', date('Y-m-d'))->count('id');
             
            $total_ringless_voicemail =  Leadchat::where('ringless_voicemail', "!=", null)->where('mms_attachments', null)->where('type', 'sent')->where('sender_id', $user->id)->whereDate('created_at', date('Y-m-d'))->count('id');
            
            $total_log =  Leadlog::whereDate('created_at', date('Y-m-d'))->where('status', 'outbound')->where('sender_id', $user->id)->where('from', $adminCompany->phone_number)->count('id');
             

            $get_ninjas_ids = array();
            $get_assign_ninja =  NinjaAssign::where('user_id', $adminId)->where('assign_status', 'yes')->get();
             
            $check_ninja = "yes";
            if($get_assign_ninja->count()){
                $get_ninjas_ids = $get_assign_ninja->pluck('ninja_id')->toArray();
            }
            else{
                $get_ninjas_ids = array(0);
                $check_ninja = "no";
            }
            $total_text_received = 0;
            $total_mms_received = 0;
            $total_log_received = 0;
            $total_email =  Contactemail::whereDate('created_at', date('Y-m-d'))->where('sender_id', $user->id)->where('type', 'sent')->where('robo_text', 'no')->count('id');
             
            $total_robo_email =  Contactemail::where('type', 'sent')->whereIn('robo_text', ['robo','workflow'])->where('sender_id',$adminId)->whereDate('created_at', date('Y-m-d'))->count('id');
             
            $total_ninja_email =  Contactemail::where('type', 'sent')->where('robo_text', 'no')->where('sender_id', $adminId)->whereIn('sender_id', $get_ninjas_ids)->whereDate('created_at', date('Y-m-d'))->count('id');
             
            $user =  User::where('id', $user->id)->where('approval','approve')->first();
             
            $admin_info =  User::where('id', $user->parent_user_id)->first();
            
            $admin_contact =  Companyinfo::where('user_id', $user->parent_user_id)->first();
            

            $total_email_received =  Contactemail::where('to', $admin_contact->suite)->where('type', 'received')->whereDate('created_at', date('Y-m-d'))->count('id');
            
            $today_leads = Lead::where('admin_email', $admin_info->email)->whereDate('created_at', date('Y-m-d'))->count('id');
            
            $today_appt_set =  Lead::where('admin_email', $admin_info->email)->where('lead_status', 'Appointment-Set')->whereDate('updated_at', date('Y-m-d'))->count('id');
            
            $today_appt_showup = Lead::where('admin_email', $admin_info->email)->where('lead_status', 'Appointment-Showed')->whereDate('updated_at', date('Y-m-d'))->count('id');
            
            $today_sold = Lead::where('admin_email', $admin_info->email)->whereIn('lead_status', ['Sold-Unknown', 'Sold-Used', 'Sold-New'])->whereDate('updated_at', date('Y-m-d'))->count('id');
            
            $today_lead_blast = Leadblast::where('message_status', 'Sent')->where('send_id', $admin_info->id)->whereDate('created_at', date('Y-m-d'))->count('id');
            
            $today_mms_blast =  Mmsblast::where('message_status', 'Sent')->where('send_id', $admin_info->id)->whereDate('created_at', date('Y-m-d'))->count('id');
             
            $today_email_blast = Emailblast::where('email_status', 'Sent')->where('send_id', $admin_info->id)->whereDate('created_at', date('Y-m-d'))->count('id');
            
            $today_ringless_voicemail_blast =  Voicemailblast::where('message_status', 'Sent')->where('send_id', $admin_info->id)->whereDate('created_at', date('Y-m-d'))->count('id');
            
            $today_robo_text =  Leadchat::where('ringless_voicemail', null)->where('mms_attachments', null)->where('admin_id', $admin_info->id)->where('sender_id', null)->where('type', null)->whereDate('created_at', date('Y-m-d'))->sum('message_length');
            
            $total_robo_mms = Leadchat::where('ringless_voicemail', null)->where('mms_attachments', "!=", null)->where('admin_id', $admin_info->id)->where('sender_id', null)->where('type', null)->whereDate('created_at', date('Y-m-d'))->count('id');
            
            $total_ninja_mms = Leadchat::where('ringless_voicemail', null)->where('mms_attachments', "!=", null)->where('admin_id', $admin_info->id)->whereIn('sender_id', $get_ninjas_ids)->where('type', 'sent')->whereDate('created_at', date('Y-m-d'))->count('id');
            
            $total_robo_ringless_voicemail = Leadchat::where('ringless_voicemail', "!=", null)->where('mms_attachments', null)->where('admin_id', $admin_info->id)->where('sender_id', null)->where('type', null)->whereDate('created_at', date('Y-m-d'))->count('id');
            
            $today_ninja_text = Leadchat::where('ringless_voicemail', null)->where('mms_attachments', null)->where('type', 'sent')->where('admin_id', $admin_info->id)->whereIn('sender_id', $get_ninjas_ids)->whereDate('created_at', date('Y-m-d'))->sum('message_length');
            

            $today_ninja_ringless_voicemail = 0;


            return $this->sendResponse([
                'total_text' => (int)$total_text ,
                'total_robo_text' => (int)$today_robo_text ,
                'total_ninja_text' => (int)$today_ninja_text ,
                'total_text_received' => $total_text_received ,
                'total_mms' => (int)$total_mms,
                'total_robo_mms' => (int)$total_robo_mms,
                'total_ninja_mms' => (int)$total_ninja_mms,
                'all_mms_recieved' => $total_mms_received,
                'total_ringless_voicemail' => (int)$total_ringless_voicemail,
                'total_robo_ringless_voicemail' => (int)$total_robo_ringless_voicemail,
                'today_ninja_ringless_voicemail' => $today_ninja_ringless_voicemail,
                'total_call_log' => (int)$total_log,
                'total_log_received' => $total_log_received,
                'total_email' => (int)$total_email,
                'total_robo_email' => (int)$total_robo_email,
                'total_ninja_email' => (int)$total_ninja_email,
//                'total_agent_email' => $total_agent_email,
                'total_email_recieved'=> (int)$total_email_received,
                'Leads'=> (int)$today_leads,
                'Appointement_set'=> (int)$today_appt_set,
                'Appointments_showUp'=> (int)$today_appt_showup,
                'SMS_Blast'=> (int)$today_lead_blast,
                'MMS_Blast'=> (int)$today_mms_blast,
                'Voicemail_Blast'=> (int)$today_ringless_voicemail_blast,
                'Email_Blast'=> (int)$today_email_blast,
                'Sold'=> (int)$today_sold,
            ],'Desk logs');
        }
    }

    public function dashboard(){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['usertype_id','id','email']);
        if($user->usertype_id == 2){
            $get_ninjas_ids =array();
            $check_ninja = "yes";
            $get_assign_ninja = NinjaAssign::where('user_id',$user->id)->where('assign_status','yes')->get();
            
            if($get_assign_ninja->count()){
                $get_ninjas_ids = $get_assign_ninja->pluck('ninja_id')->toArray();
            }
            else{
                $get_ninjas_ids = array(0);
                $check_ninja = "no";
            }
            //Totals Leads
            $leads_collection = DB::table('leads')->select(['id','assigned_user_id'])->where('admin_email',$user->email)->get();
            
            $total_leads = $leads_collection->count('id');
            // $total_unasign_leads = $leads_collection->where('assigned_user_id',null)->count('id');
            // $total_leads =  Lead::where('admin_email', $user->email)->count('id');

            $total_unasign_leads = Lead::where('admin_email', $user->email)->where('assigned_user_id',null)->count('id');
            
            $total_showed_up_appointments = null;

            // //Totals Appointments
            $total_appointments =  LeadAppointment::select('lead_appointment.*', 'leads.id as leadid', 'leads.admin_email as adminemail')
                    ->leftjoin('leads', 'lead_appointment.lead_id', 'leads.id')
                    ->where('leads.admin_email', $user->email)
                    ->count('*');

            $total_admin_agents = User::where('usertype_id', 4)
                    ->where('parent_user_id', $user->id)
                    ->count('id');
                    
            $showedupAppointments = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Showed')->count();
                                    
            return $this->sendResponse([
                'tab_Leads' => $total_leads,
                'tab_Unassignleads' => $total_unasign_leads,
                'tab_agents' => $total_admin_agents,
                'tab_appointments' => $total_appointments,
                'tab_showedupAppointments' => $showedupAppointments,
            ],'Dashboard');
        }
        elseif ($user->usertype_id == 4){
            $adminId = User::where('id', $user->id)->value('parent_user_id');
            $getAdmin = User::where('id', $adminId)->first(['id','email']);
            
            $leads_collection = DB::table('leads')->select(['id','assigned_user_id'])->where('admin_email',$getAdmin->email)->get();
            
            $total_leads = $leads_collection->count('id');
            // $total_unasign_leads = $leads_collection->where('assigned_user_id',null)->count('id');
            
            // $total_leads = Lead::where('admin_email', $getAdmin->email)->count('id');

            $total_unasign_leads =Lead::where('admin_email', $getAdmin->email)->where('assigned_user_id',null)->count('id');

            $total_showed_up_appointments = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Showed')->where('assigned_user_id',auth()->user()->id)->count('id');


            $total_appointments = LeadAppointment::select('lead_appointment.*', 'leads.id as leadid', 'leads.admin_email as adminemail')
                    ->leftjoin('leads', 'lead_appointment.lead_id', 'leads.id')
                    ->where('leads.assigned_user_id', $user->id)
                    ->count('*');
            $showedupAppointments = Lead::where('admin_email',$user->email)->where('lead_status','Appointment-Showed')->count();        
            return $this->sendResponse([
                'tab_Leads' => $total_leads,
                'tab_Unassignleads' => $total_unasign_leads,
                'tab_upcomingappointment' => $total_appointments,
                'tab_showup_appointments' => $total_showed_up_appointments,
                'tab_showedupAppointments' => $showedupAppointments,
            ],'Dashboard');
        }
    }

    public function Filter_todayActivity(Request $request){

        $startdate = date("Y-m-d", strtotime($request->startdate));
        $enddate = date("Y-m-d", strtotime($request->enddate));

        $user = User::where('id',auth()->user()->id)->with('companyinfo:user_id,suite,phone_number')->first(['id','email','usertype_id']);

        $today_robo_text = null;
        $today_ninja_text = null;
        $total_ninja_mms = null;
        $total_agent_text_sent = 0;
        $total_agent_mms = 0;
        $total_agent_ringless_voicemail = 0;
        $total_robo_email = 0;
        $total_ninja_email = 0;
        $total_agent_email = 0;
        $total_robo_ringless_voicemail = 0;
        $final_sms_sent = 0;
        $final_mms_sent = 0;

        if($user->usertype_id == 2){

            $get_ninjas_ids = array();
            $get_assign_ninja = NinjaAssign::where('user_id',$user->id)->where('assign_status','yes')->get(['ninja_id']);

            $get_ninjas_ids = $get_assign_ninja->pluck('ninja_id')->toArray();

            $dealers = null;

            $total_leads_provider = null;
            $leadCount = null;

            // Collection
            $lead_list_collection = Lead::where('archive_status',1)->WhereDate('leads.created_at', ">=", $startdate)->WhereDate('leads.created_at', "<=", $enddate)->where('admin_email', $user->email)->get('id','lead_status');
            $total_log_collection = Leadlog::WhereDate('lead_logs.created_at', ">=", $startdate)->WhereDate('lead_logs.created_at', "<=", $enddate)->get(['id','status','sender_id','to']);
            $agent_text_sent_collection  = Leadchat::where('admin_id', $user->id)->WhereDate('created_at', ">=", $startdate)->WhereDate('created_at', "<=", $enddate)->get(['id','message_length','ringless_voicemail','mms_attachments','admin_id','type','sender_id','to']);
            $total_email_collection = Contactemail::WhereDate('contact_email.created_at', ">=", $startdate)->WhereDate('contact_email.created_at', "<=", $enddate)->get(['id','sender_id','to','type','robo_text']);
            // ENDS Collection
            $leadList = $lead_list_collection->count('id');

            $final_sms_sent = $agent_text_sent_collection->where('ringless_voicemail',null)->where('mms_attachments',null)->where('type','sent')->sum('message_length');
            $final_mms_sent = $agent_text_sent_collection->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('type','sent')->count('id');

            $total_text = $agent_text_sent_collection->where('type','sent')->where('ringless_voicemail',null)->where('mms_attachments','=',null)->where('sender_id', $user->id)->sum('message_length');
            $total_mms = $agent_text_sent_collection->where('type','sent')->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('sender_id', $user->id)->count('*');
            $total_ringless_voicemail = $agent_text_sent_collection->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->where('sender_id',$user->id)->count('id');
            $today_ninja_ringless_voicemail = $agent_text_sent_collection->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->wherein('sender_id',$get_ninjas_ids)->where('admin_id',$user->id)->count('id');
            $total_log = $total_log_collection->where('status','outbound')->where('sender_id', $user->id)->count('id');
            $total_email = $total_email_collection->where('robo_text','no')->where('sender_id', $user->id)->count('id');
            $total_text_received = $agent_text_sent_collection->where('to', $user->companyinfo->phone_number)->where('type', 'received')->sum('message_length');
            $total_mms_received = $agent_text_sent_collection->where('to', $user->companyinfo->phone_number)->where('type', 'received')->where('mms_attachments','!=',null)->count('id');
            $total_log_received = $total_log_collection->where('to', $user->companyinfo->phone_number)->where('status', 'incoming')->count('id');
            $total_email_received = $total_email_collection->where('to', $user->companyinfo->suite)->where('type', 'received')->count('id');

            $total_robo_email = $total_email_collection->where('type', 'sent')->whereIn('robo_text', ['robo','workflow'])->where('sender_id',$user->id)->count('id');
            $total_ninja_email = $total_email_collection->where('type', 'sent')->where('robo_text', 'no')->where('sender_id',$user->id)->wherein('sender_id',$get_ninjas_ids)->count('id');

            $get_mms_blast = Mmsblast::where('message_status', 'Sent')->where('send_id', $user->id)->WhereDate('mms_blast.created_at', ">=", $startdate)->WhereDate('mms_blast.created_at', "<=", $enddate)->count('id');
            $get_lead_blast = Leadblast::where('message_status', 'Sent')->WhereDate('lead_blast.created_at', ">=", $startdate)->WhereDate('lead_blast.created_at', "<=", $enddate)->where('send_id', $user->id)->count('id');
            $get_email_blast = Emailblast::where('email_status', 'Sent')->WhereDate('email_blast.created_at', ">=", $startdate)->WhereDate('email_blast.created_at', "<=", $enddate)->where('send_id', $user->id)->count('id');
            $today_ringless_voicemail_blast = Voicemailblast::where('message_status', 'Sent')->where('send_id',$user->id)->WhereDate('voicemail_blast.created_at', ">=", $startdate)->WhereDate('voicemail_blast.created_at', "<=", $enddate)->count('id');
            $today_sold = Lead::where('archive_status',1)->WhereDate('leads.updated_at', ">=", $startdate)->WhereDate('leads.updated_at', "<=", $enddate)->where('admin_email', $user->email)->whereIn('lead_status', ['sold-used', 'Sold-New', 'Sold-Unknown'])->count('id');
            $today_appt_showup = Lead::where('archive_status',1)->WhereDate('leads.updated_at', ">=", $startdate)->WhereDate('leads.updated_at', "<=", $enddate)->where('admin_email', $user->email)->where('lead_status','Appointment-Showed')->count('id');
            $appointment_set = Lead::where('archive_status',1)->WhereDate('leads.updated_at', ">=", $startdate)->WhereDate('leads.updated_at', "<=", $enddate)->where('admin_email', $user->email)->where('lead_status','Appointment-Set')->count('id');
            $today_robo_text = $agent_text_sent_collection->where('admin_id', $user->id)->where('sender_id', null)->where('type', null)->where('ringless_voicemail',null)->where('mms_attachments','=',null)->sum('message_length');
            $total_robo_mms = $agent_text_sent_collection->where('admin_id', $user->id)->where('sender_id', null)->where('type', null)->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->count('id');
            $total_robo_ringless_voicemail = $agent_text_sent_collection->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('admin_id',$user->id)->where('sender_id',null)->where('type',null)->count('id');
            $today_ninja_text = $agent_text_sent_collection->where('admin_id',$user->id)->where('ringless_voicemail',null)->where('mms_attachments','=',null)->where('type', 'sent')->wherein('sender_id',$get_ninjas_ids)->sum('message_length');

            $total_ninja_mms = $agent_text_sent_collection->where('ringless_voicemail', null)->where('mms_attachments', "!=", null)->where('admin_id', $user->id)->where('type', 'sent')->wherein('sender_id',$get_ninjas_ids)->count('id');


            $get_agent_ids = array();
            $total_agents = null;
            $get_admin_agents = User::where('parent_user_id', $user->id)->get(['id']);
            $get_agent_ids = $get_admin_agents->pluck('id')->toArray();

            $total_agent_text_sent  = $agent_text_sent_collection->where('ringless_voicemail',null)->where('mms_attachments',null)->where('type','sent')->whereIn('sender_id',$get_agent_ids)->sum('message_length');
            $total_agent_mms  = $agent_text_sent_collection->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('type','sent')->whereIn('sender_id',$get_agent_ids)->count('id');
            $total_agent_ringless_voicemail  = $agent_text_sent_collection->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->whereIn('sender_id',$get_agent_ids)->count('id');
            $total_agent_email = $total_email_collection->where('type', 'sent')->where('robo_text', 'no')->wherein('sender_id', $get_agent_ids)->count('id');

        }
        elseif($user->usertype_id == 4){
            $getUser = User::where('id', $user->id)->first('parent_user_id');
            $getAdmin = User::where('id', $getUser->parent_user_id)->first(['id','email']);

            $get_ninjas_ids = array();
            $get_ninjas_ids = NinjaAssign::where('user_id',$getAdmin->id)->where('assign_status','yes')->pluck('ninja_id')->toArray();

            $leadList = Lead::where('archive_status',1)->WhereDate('leads.created_at', ">=", $startdate)->WhereDate('leads.created_at', "<=", $enddate)->where('admin_email', $getAdmin->email)->count('id');


            $total_text = Leadchat::where('ringless_voicemail',null)->where('mms_attachments','=',null)->WhereDate('lead_chat.created_at', ">=", $startdate)->WhereDate('lead_chat.created_at', "<=", $enddate)->where('sender_id', auth()->user()->id)->sum('message_length');
            $total_mms = Leadchat::where('type', 'sent')->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('sender_id', auth()->user()->id)->WhereDate('lead_chat.created_at', ">=", $startdate)->WhereDate('lead_chat.created_at', "<=", $enddate)->count('id');
            $total_ringless_voicemail = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->where('sender_id',auth()->user()->id)->WhereDate('lead_chat.created_at', ">=", $startdate)->WhereDate('lead_chat.created_at', "<=", $enddate)->count('id');
            $today_ninja_ringless_voicemail = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->whereIn('sender_id',$get_ninjas_ids)->where('admin_id',$getUser->parent_user_id)->where('type','sent')->WhereDate('lead_chat.created_at', ">=", $startdate)->WhereDate('lead_chat.created_at', "<=", $enddate)->count('id');
            $total_log = Leadlog::where('status','outbound')->WhereDate('lead_logs.created_at', ">=", $startdate)->WhereDate('lead_logs.created_at', "<=", $enddate)->where('sender_id', $getAdmin->id)->count('id');
            $total_email = Contactemail::where('robo_text','no')->WhereDate('contact_email.created_at', ">=", $startdate)->WhereDate('contact_email.created_at', "<=", $enddate)->where('sender_id', auth()->user()->id)->count('id');

            $admin_contact = Companyinfo::where('user_id', $getUser->parent_user_id)->first('suite');

            $total_mms_received = Leadchat::where('to', $admin_contact->suite)->where('type', 'received')->where('mms_attachments','!=',null)->WhereDate('lead_chat.created_at', ">=", $startdate)->WhereDate('lead_chat.created_at', "<=", $enddate)->count('id');
            $total_text_received = 0;
            $total_log_received = 0;
            $total_email_received = Contactemail::where('to', $admin_contact->suite)->where('type', 'received')->WhereDate('contact_email.created_at', ">=", $startdate)->WhereDate('contact_email.created_at', "<=", $enddate)->count('id');
            $total_agent_text_sent = 0;

            $get_lead_blast = Leadblast::where('message_status', 'Sent')->where('send_id', $getAdmin->id)->WhereDate('lead_blast.created_at', ">=", $startdate)->WhereDate('lead_blast.created_at', "<=", $enddate)->count('id');

            $get_email_blast = Emailblast::where('email_status', 'Sent')->where('send_id', $getAdmin->id)->WhereDate('email_blast.created_at', ">=", $startdate)->WhereDate('email_blast.created_at', "<=", $enddate)->count('id');


            $total_robo_email = Contactemail::where('type', 'sent')->whereIn('robo_text', ['robo','workflow'])->where('sender_id',$getAdmin->id)->WhereDate('contact_email.created_at', ">=", $startdate)->WhereDate('contact_email.created_at', "<=", $enddate)->count('id');
            $total_ninja_email = Contactemail::where('type', 'sent')->where('robo_text', 'no')->where('sender_id', $getAdmin->id)->whereIn('sender_id', $get_ninjas_ids)->WhereDate('contact_email.created_at', ">=", $startdate)->WhereDate('contact_email.created_at', "<=", $enddate)->count('id');

            $get_mms_blast = Mmsblast::where('message_status', 'Sent')->where('send_id', $getAdmin->id)->WhereDate('mms_blast.created_at', ">=", $startdate)->WhereDate('mms_blast.created_at', "<=", $enddate)->count('id');
            $today_ringless_voicemail_blast = Voicemailblast::where('message_status', 'Sent')->where('send_id',$getAdmin->id)->WhereDate('voicemail_blast.created_at', ">=", $startdate)->WhereDate('voicemail_blast.created_at', "<=", $enddate)->count('id');
            $today_sold = Lead::where('admin_email', $getAdmin->email)->whereIn('lead_status', ['sold-used', 'Sold-New', 'Sold-Unknown'])->WhereDate('leads.updated_at', ">=", $startdate)->WhereDate('leads.updated_at', "<=", $enddate)->count('id');

            $total_robo_mms = Leadchat::where('admin_id', $getAdmin->id)->where('sender_id', null)->where('type', null)->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->WhereDate('lead_chat.created_at', ">=", $startdate)->WhereDate('lead_chat.created_at', "<=", $enddate)->count('id');
            $today_robo_text = Leadchat::where('admin_id',$getAdmin->id)->where('sender_id',null)->where('type',null)->where('ringless_voicemail',null)->where('mms_attachments','=',null)->WhereDate('lead_chat.created_at', ">=", $startdate)->WhereDate('lead_chat.created_at', "<=", $enddate)->sum('message_length');
            $total_robo_ringless_voicemail = Leadchat::where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('admin_id',$getAdmin->id)->where('sender_id',null)->where('type',null)->WhereDate('lead_chat.created_at', ">=", $startdate)->WhereDate('lead_chat.created_at', "<=", $enddate)->count('id');
            $today_ninja_text = Leadchat::where('admin_id',$getAdmin->id)->where('type','sent')->where('ringless_voicemail',null)->where('mms_attachments','=',null)->whereIn('sender_id',$get_ninjas_ids)->WhereDate('lead_chat.created_at', ">=", $startdate)->WhereDate('lead_chat.created_at', "<=", $enddate)->sum('message_length');
            $appointment_set = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Set')->WhereDate('leads.updated_at', ">=", $startdate)->WhereDate('leads.updated_at', "<=", $enddate)->count('id');
            $today_appt_showup = Lead::where('admin_email',$getAdmin->email)->where('lead_status','Appointment-Showed')->WhereDate('leads.created_at', ">=", $startdate)->WhereDate('leads.created_at', "<=", $enddate)->count('id');

            $total_ninja_mms = Leadchat::where('ringless_voicemail', null)->where('mms_attachments', "!=", null)->where('admin_id', $getAdmin->id)->where('type', 'sent')->wherein('sender_id',$get_ninjas_ids)->WhereDate('lead_chat.created_at', ">=", $startdate)->WhereDate('lead_chat.created_at', "<=", $enddate)->count('id');
        }

        return $this->sendResponse([
            'total_text' => (int)$total_text,
            'total_robo_text' => (int)$today_robo_text,
            'total_ninja_text' => (int)$today_ninja_text,
            'agent_text_sent' => (int)$total_agent_text_sent,
            'total_text_received' => (int)$total_text_received,
            'total_mms' =>(int)$total_mms,
            'total_robo_mms' => (int)$total_robo_mms,
            'total_ninja_mms' => (int)$total_ninja_mms,
            'total_agent_mms' => (int)$total_agent_mms,
            'all_mms_recieved' => (int)$total_mms_received,
            'total_ringless_voicemail' => (int)$total_ringless_voicemail,
            'total_robo_ringless_voicemail' => (int)$total_robo_ringless_voicemail,
            'today_ninja_ringless_voicemail' => (int)$today_ninja_ringless_voicemail,
            'total_agent_ringless_voicemail' => (int)$total_agent_ringless_voicemail,
            'total_call_log' => (int)$total_log,
            'total_log_received' => (int)$total_log_received,
            'total_email' => (int)$total_email,
            'total_robo_email' => (int)$total_robo_email,
            'total_ninja_email' => (int)$total_ninja_email,
            'total_agent_email' => (int)$total_agent_email,
            'total_email_recieved'=> (int)$total_email_received,
            'Leads'=> (int)$leadList,
            'Appointement_set'=> (int)$appointment_set,
            'Appointments_showUp'=> (int)$today_appt_showup,
            'SMS_Blast'=> (int)$get_lead_blast,
            'MMS_Blast'=> (int)$get_mms_blast,
            'Voicemail_Blast'=> (int)$today_ringless_voicemail_blast,
            'Email_Blast'=> (int)$get_email_blast,
            'Sold'=> (int)$today_sold,
            'final-sms-sent'=> (int)$final_sms_sent,
            'final-mm-sent' => (int)$final_mms_sent

        ],'Filter-Desk-logs');

    }

    public function leadsource()
    {

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['id','email','usertype_id']);

        if($user->usertype_id == 2){
            $today_leads = Lead::select('leads.lead_provider')
                ->where('leads.admin_email',$user->email)
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as total, lead_provider')
                ->get();
        }
        elseif($user->usertype_id == 4){
            $getUser = DB::table('users')->where('id', $user->id)->value('parent_user_id');
            $getAdmin = DB::table('users')->where('id', $getUser)->first(['id','email']);
            $today_leads = Lead::select('leads.lead_provider')
                ->where('leads.admin_email',$getAdmin->email)
                ->groupBy('lead_provider')
                ->selectRaw('count(*) as total, lead_provider')
                ->get();
        }
        return $this->sendResponse($today_leads,'lead-source');

    }

    public function upcomingApp(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['email','id','usertype_id']);

        if($user->usertype_id == 2){
            $upcoming_appointments = LeadAppointment::select('lead_appointment.id','lead_appointment.lead_id',DB::raw("DATE_FORMAT(STR_TO_DATE(lead_appointment.set_appointment,'%m/%d/%Y %l:%i %p'),'%Y-%m-%d %H:%i:%s') as appointment_date"),'leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','users.first_name as agent_first_name','users.last_name as agent_last_name')
                ->leftjoin('leads','lead_appointment.lead_id','leads.id')
                ->leftjoin('users','users.id','leads.assigned_user_id')
                ->where('leads.admin_email',$user->email)
                ->where('lead_appointment.set_appointment','>=',date('m/d/Y h:i:s A'))
                ->orderby('id','desc')
                ->limit(5)
                ->get();
        }
        elseif($user->usertype_id == 4){
            $upcoming_appointments = LeadAppointment::select('lead_appointment.id', 'lead_appointment.lead_id',DB::raw("DATE_FORMAT(STR_TO_DATE(lead_appointment.set_appointment,'%m/%d/%Y %l:%i %p'),'%Y-%m-%d %H:%i:%s') as appointment_date"),'leads.sender_first_name as lead_first_name', 'leads.sender_last_name as lead_last_name','users.first_name as agent_first_name', 'users.last_name as agent_last_name')
                                ->leftjoin('leads', 'lead_appointment.lead_id', 'leads.id')
                                ->leftjoin('users', 'users.id', 'leads.assigned_user_id')
                                ->where('leads.assigned_user_id', $user->id)
                                ->where('lead_appointment.set_appointment', '>=', date('m/d/Y h:i:s A'))
                                ->orderby('id', 'desc')
                                ->limit(5)
                                ->get();
        }



        return $this->sendResponse([
            'upcoming-appointments'=> $upcoming_appointments,
        ],'upcoming_appointments');

    }

    public function showedUpAppointmentView(){

                $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['usertype_id','email']);

                if($user->usertype_id == 2){
                    
                    $leads = Lead::with(['lead' => function($query){
                                        $query->with(['leadInventory'])->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                                              ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                              ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip');
                                    }])->select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                                    ->where('admin_email',$user->email)
                                    ->leftjoin('users','leads.admin_email','users.email')
                                    ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                                    ->leftjoin('company_info','company_info.user_id','users.id')
                                    ->where('lead_status','Appointment-Showed')
                                    ->orderby('updated_at', 'desc')
                                    ->get();

                    return $this->sendResponse([
                        'Showed_up_appointements'=> $leads,
                    ],'Showed_up_appointements');

                }
                elseif($user->usertype_id == 4){
                    
                    $leads = Lead::with(['lead' => function($query){
                                        $query->with(['leadInventory'])->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                                              ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                              ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip');
                                    }])->select('leads.id','leads.sender_first_name','leads.sender_last_name','leads.lead_type_status','leads.status','leads.assigned_user_id','leads.lead_provider','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name','agents.last_name','company_info.name as companyname','leads.contact as leadnumber','leads.admin_email')
                                    ->where('assigned_user_id',$user->email)
                                    ->leftjoin('users','leads.admin_email','users.email')
                                    ->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                                    ->leftjoin('company_info','company_info.user_id','users.id')
                                    ->where('lead_status','Appointment-Showed')
                                    ->orderby('updated_at', 'desc')
                                    ->get();
                                    
                    return $this->sendResponse([
                        'Showed_up_appointements'=> $leads,
                    ],'Showed_up_appointements');
                }


    }

    public function reminders(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first('id');

        $reminders = Leadreminder::select('leads.id as leadid','leads.sender_first_name','leads.sender_last_name','lead_reminders.set_reminder','lead_reminders.reminder_notes','lead_reminders.status as reminder-status')
            ->where('sender_id', $user->id)
            ->leftjoin('leads','leads.id','lead_reminders.lead_id')
            ->limit(5)
            ->orderby('lead_reminders.id', 'desc')
            ->get();

        return $this->sendResponse([
            'reminder' => $reminders
        ],'dashboard-reminders');

    }

    public function leadReminder($id){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first('id');

        $reminders = Leadreminder::select('leads.id as leadid','leads.sender_first_name','leads.sender_last_name','lead_reminders.set_reminder','lead_reminders.reminder_notes','lead_reminders.status as reminder-status')
            ->where('sender_id', $user->id)
            ->where('lead_id',$id)
            ->leftjoin('leads','leads.id','lead_reminders.lead_id')
            ->limit(5)
            ->orderby('lead_reminders.id', 'desc')
            ->get();

       return $this->sendResponse([
            'reminder' => $reminders
        ],'lead-reminders');


    }

    public function AppraisevehicleView(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['usertype_id','email']);

        if($user->usertype_id == 2){

            $appraise_vehicles = Appraisevehicle::select('appraise_vehicle.id','appraise_vehicle.lead_id','appraise_vehicle.first_name','appraise_vehicle.last_name','appraise_vehicle.created_at','leads.lead_provider','leads.admin_email','users.id as admin_id','users.first_name as admin_first_name','users.last_name as admin_last_name','company_info.name')
                ->leftjoin('leads','leads.id','appraise_vehicle.lead_id')
                ->leftjoin('users','users.email','leads.admin_email')
                ->leftjoin('company_info','company_info.user_id','users.id')
                ->where('leads.admin_email',$user->email)
                ->orderby('appraise_vehicle.id','desc')
                ->get();
        }
        elseif($user->usertype_id == 4){

            $user = User::where('id',auth()->user()->id)->with('companyinfo')->first('id');

            $getUser = DB::table('users')->where('id', $user->id)->value('parent_user_id');
            $getAdmin = DB::table('users')->where('id', $getUser)->first(['id','email']);

            $appraise_vehicles = Appraisevehicle::select('appraise_vehicle.id','appraise_vehicle.lead_id','appraise_vehicle.first_name','appraise_vehicle.last_name','appraise_vehicle.created_at','leads.lead_provider','leads.admin_email','users.id as admin_id','users.first_name as admin_first_name','users.last_name as admin_last_name','company_info.name')
                ->leftjoin('leads','leads.id','appraise_vehicle.lead_id')
                ->leftjoin('users','users.email','leads.admin_email')
                ->leftjoin('company_info','company_info.user_id','users.id')
                ->where('leads.admin_email',$getAdmin->email)
                ->orderby('appraise_vehicle.id','desc')
                ->get();
        }

        return $this->sendResponse([
            'Appraise_vehicle_view' => $appraise_vehicles,
        ],'Appraise_vehicle_view');

    }

    public function AppraisevehiclePdfview(Request $request){


        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $id = $request->id;

        if($user->usertype_id == 2){
            $appraise_vechile_data = DB::table('appraise_vehicle')
                ->select('appraise_vehicle.id','appraise_vehicle.lead_id','appraise_vehicle.year','appraise_vehicle.make','appraise_vehicle.model','appraise_vehicle.style','appraise_vehicle.condition','appraise_vehicle.mileage','appraise_vehicle.first_name','appraise_vehicle.last_name','appraise_vehicle.email','appraise_vehicle.phone','appraise_vehicle.created_at','leads.lead_provider','leads.admin_email','users.id as admin_id','users.first_name as admin_first_name','users.last_name as admin_last_name','company_info.name')
                ->leftjoin('leads','leads.id','appraise_vehicle.lead_id')
                ->leftjoin('users','users.email','leads.admin_email')
                ->leftjoin('company_info','company_info.user_id','users.id')
                ->where('appraise_vehicle.id',$id)
                ->where('leads.admin_email',$user->id)
                ->orderby('appraise_vehicle.id','desc')
                ->first();
        }
        elseif($user->usertype_id == 4){

            $getUser = DB::table('users')->where('id', auth()->user()->id)->value('parent_user_id');
            $getAdmin = DB::table('users')->where('id', $getUser)->first(['id','email']);

            $appraise_vechile_data = DB::table('appraise_vehicle')
                ->select('appraise_vehicle.id','appraise_vehicle.lead_id','appraise_vehicle.year','appraise_vehicle.make','appraise_vehicle.model','appraise_vehicle.style','appraise_vehicle.condition','appraise_vehicle.mileage','appraise_vehicle.first_name','appraise_vehicle.last_name','appraise_vehicle.email','appraise_vehicle.phone','appraise_vehicle.created_at','leads.lead_provider','leads.admin_email','users.id as admin_id','users.first_name as admin_first_name','users.last_name as admin_last_name','company_info.name')
                ->leftjoin('leads','leads.id','appraise_vehicle.lead_id')
                ->leftjoin('users','users.email','leads.admin_email')
                ->leftjoin('company_info','company_info.user_id','users.id')
                ->where('appraise_vehicle.id',$id)
                ->where('leads.admin_email',$getAdmin->email)
                ->orderby('appraise_vehicle.id','desc')
                ->first();
        }

        $getip = DB::table('ip_permissions')->where('ip',session()->get('sess_ip'))->first();



        $pdf = PDF::loadView('backend.pages.Appraise.appraisepdfview',compact('appraise_vechile_data','getip'));
        $file_name = "appraise-vehcile-.pdf";
        return $pdf->stream($file_name);


    }

    public function creditApplicationView(){

                $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['email','id','usertype_id']);

                if($user->usertype_id == 2){
                    $credit_app = Creditpdf::select('credit_pdf.file_name','credit_pdf.credit_application_id','credit_application.*','leads.lead_provider','leads.admin_email','users.id as admin_id','users.first_name as admin_first_name','users.last_name as admin_last_name','company_info.name')
                        ->leftjoin('credit_application','credit_pdf.credit_application_id','credit_application.id')
                        ->leftjoin('leads','leads.id','credit_application.lead_id')
                        ->leftjoin('users','users.email','leads.admin_email')
                        ->leftjoin('company_info','company_info.user_id','users.id')
                        ->where('leads.admin_email',$user->email)
                        ->orderby('credit_pdf.id','desc')
                        ->get();
                }
                elseif($user->usertype_id == 4){
                    $credit_app = Creditpdf::select('credit_pdf.file_name','credit_pdf.credit_application_id','credit_application.first_name','credit_application.last_name','credit_application.lead_id','credit_application.created_at','leads.lead_provider','leads.admin_email','leads.assigned_user_id','users.id as admin_id','users.first_name as admin_first_name','users.last_name as admin_last_name','company_info.name')
                        ->leftjoin('credit_application','credit_pdf.credit_application_id','credit_application.id')
                        ->leftjoin('leads','leads.id','credit_application.lead_id')
                        ->leftjoin('users','users.email','leads.admin_email')
                        ->leftjoin('company_info','company_info.user_id','users.id')
                        ->where('leads.assigned_user_id',$user->id)
                        ->orderby('credit_pdf.id','desc')
                        ->get();
                }

//                return view('backend.pages.creditapplication.creditapplication',compact('credit_app'));
        return $this->sendResponse([
            'credit_application_appointement' => $credit_app,
        ],'credit_application_appointement');

    }


    public function creditApplicationpdflink(Request $request){

        $name = str_replace(' ','%20',$request->filename);

        $link = 'https://credit.text10x.ai/public/pdffiles/'.$name;

        return $this->sendResponse([
            'credit_application_link' => $link,
        ],'credit_application_link');

    }

    public function masterSearch(Request $request)
    {

        $usersession = User::where('id',auth()->user()->id)->with('companyinfo')->first(['usertype_id','id']);

            $value = $request->value;
            $search_by = $request->search_by;
            $output = '';
            $lead_all = 0;


            if($usersession->usertype_id == 2)
            {
                $user = User::where('id',$usersession->id)->first();
                $userEmail = $user->email;

                if($search_by == 'full_name')
                {
                    $lead_all = Lead::select('leads.id','leads.admin_email','leads.sender_first_name','leads.sender_last_name','company_info.name as companyname','company_info.phone_number as phone_number')
                        ->leftjoin('users','leads.admin_email','users.email')
                        ->leftjoin('company_info','company_info.user_id','users.id')
                        ->where('admin_email',$userEmail)->where(DB::raw('CONCAT_WS(" ",sender_first_name,sender_last_name)'), 'like', "%$value%")->get();
                }
                else
                {
                    $lead_all = Lead::select('leads.id','leads.admin_email','leads.sender_first_name','leads.sender_last_name','company_info.name as companyname','company_info.phone_number as phone_number')
                        ->leftjoin('users','leads.admin_email','users.email')
                        ->leftjoin('company_info','company_info.user_id','users.id')
                        ->where('leads.'.$search_by,"LIKE","%{$value}%")->where('admin_email',$userEmail)->get();
                }
                
                if($lead_all->count() > 0)
                {
                    return $this->sendResponse([
                        'lead' => $lead_all,
                    ],'lead');
                }
                else
                {
                    return $this->sendResponse([
                        'lead' => [],
                    ],'lead');
                }

            }
            else
            {
                $getUser = User::where('id', auth()->user()->id)->first('parent_user_id');
                $getAdmin = User::where('id', $getUser->parent_user_id)->first('email');

                if($search_by == 'full_name')
                {
                    $lead_all = Lead::where('admin_email',$getAdmin->email)->where(DB::raw('CONCAT_WS(" ",sender_first_name,sender_last_name)'), 'like', "%$value%")->get(['id','admin_email','sender_first_name','sender_last_name']);
                }
                else
                {
                    $lead_all = Lead::where($search_by,"LIKE","%{$value}%")->where('admin_email',$getAdmin->email)->get(['id','admin_email','sender_first_name','sender_last_name']);
                }

                if($lead_all->count() > 0)
                {
                    return $this->sendResponse([
                        'lead' => $lead_all,
                    ],'lead');
                }
                else
                {
                    return $this->sendResponse([
                        'lead' => 'No result',
                    ],'lead');
                }

            }
    }
    public function textCount(){

        if(auth()->user()->usertype_id == 2)
        {
            $lead_count = Lead::where('admin_email',auth()->user()->email)
                ->whereNotIn('lead_status',['Not Interested','Wrong Number','Blocked-Harassment','Blocked-Inappropirate'])
                ->where('chat_filter',1)
                ->count('id');
            return response()->json(['textcount' => $lead_count]);
        }
        elseif(auth()->user()->usertype_id == 4)
        {
            $getUser = User::where('id',auth()->user()->id)->first(['parent_user_id']);
            $getAdmin = User::where('id',$getUser->parent_user_id)->first(['email']);

            $lead_count = Lead::where('admin_email',$getAdmin->email)
                ->where('chat_filter',1)
                ->whereNotIn('lead_status',['Not Interested','Wrong Number','Blocked-Harassment','Blocked-Inappropirate'])
                ->count('id');

            return response()->json(['textcount' => $lead_count]);
        }
    }

}