<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Twilio\Rest\Client;
use Carbon\Carbon;
use DB;

class VoiceMailBlastCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'voicemail:blast';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Message Send Successfull';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $currentdatetime = Carbon::now()->format('m-d-Y h:i a');
        
        $get_lead_blast = DB::table('voicemail_blast')
                        ->select('voicemail_blast.*','users.id as user_id','users.usertype_id as usertype_id')
                        ->leftjoin('users','users.id','voicemail_blast.send_id')
                        ->where('voicemail_blast.message_status','Pending')
                        ->where('voicemail_blast.audio_link','!=',null)
                        ->where('voicemail_blast.send_at',$currentdatetime)
                        ->get();
                        
        if($get_lead_blast->count() > 0)
        {
            foreach ($get_lead_blast as $leadblast) 
            {
              $splitStatus = explode(', ', $leadblast->target_status);
              $splitDate = explode(' - ', $leadblast->message_filter);
              
              $startdate = date("Y-m-d", strtotime($splitDate[0]));
              $enddate = date("Y-m-d", strtotime($splitDate[1]));
    
              if($leadblast->usertype_id == 2){
                $get_admin_email = DB::table('users')->where('id',$leadblast->user_id)->first();
                $admin_id = $leadblast->user_id;
                
                if($leadblast->lead_provider != "0"){
                  $leads = DB::table('leads')
                              ->where('lead_provider',$leadblast->lead_provider)
                              ->where('admin_email',$get_admin_email->email)
                              ->whereBetween('created_at',[$startdate,$enddate])
                              ->get();
                }
                else{
                  $leads = DB::table('leads')
                            ->where('admin_email',$get_admin_email->email)
                            ->whereBetween('created_at',[$startdate,$enddate])
                            ->get();
                }
              }
              else{
                $get_agent = DB::table('users')->where('id',$leadblast->user_id)->first();
                $admin_id = $get_agent->parent_user_id;
                $get_admin_email = DB::table('users')->where('id',$get_agent->parent_user_id)->first();
                
                if($leadblast->lead_provider != "0"){
                  $leads = DB::table('leads')
                              ->where('lead_provider',$leadblast->lead_provider)
                              ->where('admin_email',$get_admin_email->email)
                              ->whereBetween('created_at',[$startdate,$enddate])
                              ->get();
                }else{
                  $leads = DB::table('leads')
                              ->where('admin_email',$get_admin_email->email)
                              ->whereBetween('created_at',[$startdate,$enddate])
                              ->get();
                }
              }
              
              $count = 1;
              foreach($leads as $lead){
                
                for($i = 0; $i < count($splitStatus); $i++){
                  
                  if($lead->lead_status == $splitStatus[$i]){
                    
    
                    if($count <= $leadblast->send_limit){
                        $get_admin_contact = DB::table('company_info')
                                        ->select('company_info.*','users.email as admin')
                                        ->leftjoin('users','company_info.user_id','users.id')
                                        ->where('users.email',$lead->admin_email)
                                        ->first();
    
                        if ($get_admin_contact != null) {
                            try{
                                if($lead->contact != null)
                                {
                                    // yaha voice curl lagy ga
                                    header('Content-type: application/json');
                
                                    $url = 'https://api.dropcowboy.com/v1/rvm';
                                    
                                    $data = array("team_id" => 'ab6bc9a0-083c-45b6-a14e-bff345b8e97f', 
                                                    "secret" => 'b9133b1c-b12a-4ca5-ac27-106538b1a426',
                                                    "audio_url" => $leadblast->audio_link,
                                                    "audio_type" => 'wav',
                                                    "phone_number" => $lead->contact, 
                                                    "caller_id" => $get_admin_contact->phone_number,
                                                    "foreign_id" => $lead->id);
                                                    
                                    $data_string = json_encode($data);
                                    
                                    $ch = curl_init($url);
                                    
                                    curl_setopt_array($ch, array(
                                        CURLOPT_POST => true,
                                        CURLOPT_POSTFIELDS => $data_string,
                                        CURLOPT_HEADER => true,
                                        CURLOPT_HTTPHEADER => array('Content-Type:application/json', 'Content-Length: ' . strlen($data_string))
                                    ));
                                    
                                    $result = curl_exec($ch);
                                    curl_close($ch);
                
                                    $msg_body = "Here is your ringless voicemail message!";
                                    
                                    $check_number = DB::table('lead_chat')
                                    					->where('admin_id',$admin_id)
                                    					->where('from',$lead->contact)
                                    					->orwhere('to',$lead->contact)
                                    					->first();
                                    					
                                	if($check_number != null){
                            	    	$response = [
                            	    	    'admin_id' => $admin_id,
                                            'lead_id' => $lead->id,
                            	    		'from' => $get_admin_contact->phone_number,
                            	    		'to' => $lead->contact,
                            	    		'message' => $msg_body,
                    		                'ringless_voicemail' => $leadblast->audio_link,
                                			'chat_id' =>$check_number->chat_id,
                            	    	];
                            	    	$insert = DB::table('lead_chat')->insert($response);
                            	    	
                                        if($insert){
                                            $data = [
                                                'updated_at' => date('Y-m-d H:i:s'),
                                            ];
                                            DB::table('leads')->where('contact',$lead->contact)->update($data);
                                        }
                            	    }
                            	    else{
                            	    	$get_max_value = DB::table('lead_chat')->max('chat_id');
                            	    	
                                        $count = $get_max_value + 1;
                            
                                        $send = [
                            	    	    'admin_id' => $admin_id,
                                            'lead_id' => $lead->id,
                                    		'from' => $get_admin_contact->phone_number,
                                	    	'to' => $lead->contact,
                            	    		'message' => $msg_body,
                    		                'ringless_voicemail' => $leadblast->audio_link,
                                    		'chat_id' =>$count,
                                		];
                                		
                                		$message_insert = DB::table('lead_chat')->insert($send);
                                		
                                		$data = [
                                            'updated_at' => date('Y-m-d H:i:s'),
                                        ];
                                        DB::table('leads')->where('contact',$lead->contact)->update($data);
                                            
                                	}
                                }
                                else
                                {
                                    DB::table('leads')->where('id',$lead->id)->update(['lead_status' => 'Invalid Cell Number']);
                                }
                            }catch (\Twilio\Exceptions\RestException $e) {
                                $data = [
                                    'lead_status' => "Wrong Number",
                                ];
                                DB::table('leads')->where('contact',$lead->contact)->update($data);
                            }
                        }
                    }
                  }
                  
                }
                $count++;
                
              }
              DB::table('voicemail_blast')->where('id',$leadblast->id)->update(['message_status' => 'Sent']);
            }
        }
    }
}
