<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Twilio\Rest\Client;
use Illuminate\Http\Request;
use DB;

class LeadXmlCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'lead:xml';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Message Send Successfull';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $curr_date = date("H:i:s");
        $fix_date = '09:54:00';
        $end_date = '21:28:00';
        
        $sid    = 'AC15298329064d30e708bdc83adb95dc54';
        $token  = '5b99af1b1a553786d497d3072c1e29ac'; 
        $client = new Client( $sid, $token );

        $xml = DB::table('email_xml')->where('status','no')->get();
        
        if($xml->count() > 0)
        {
            if($curr_date > $fix_date && $curr_date < $end_date)
            {
                foreach($xml as $listing)
                {
                    $userData = DB::table('users')->where('id',$listing->user_id)->first();
                    $userCompany = DB::table('company_info')->where('user_id',$listing->user_id)->first();
                    $vendor_email = $userData->email;
                    
                    libxml_use_internal_errors(true);
                    $washBoday = str_replace(array("<![CDATA[","]]>"),"",$listing->body);
                    $body = simplexml_load_string($washBoday);
                    
                    if($body){
                        
                        $xmlUpdate = DB::table('email_xml')->where('id',$listing->id)->update(['status'=>'yes']);
                        
                        $source = "";
                        $first_name = "";
                        $last_name = "";
                        $phone = "";
                        $address = "";
                        $city = "";
                        $state = "";
                        $zip = null;
                        $car_year = null;
                        $car_make = null;
                        $car_model = null;
                        $car_vin = null;
                        $home_number = null;
                        $work_number = null;
                        
                        $customer_detail = json_encode($body->prospect);
                        $array = json_decode($customer_detail,TRUE);
                        
                        if(array_key_exists('phone', $array['customer']['contact']))
                        {    
                            if(empty($array['customer']['contact']['phone']))
                            {
                                $phone = null;
                            }
                            else
                            {
                                if(is_array($array['customer']['contact']['phone']) && isset($array['customer']['contact']))
                                {
                                    if(isset($array['customer']['contact']['phone'][0]['@attributes']['type']))
                                    {
                                        $home_number = null;
                                    }
                                    else
                                    {
                                        $home_number = $array['customer']['contact']['phone'][0];
                                        
                                        $number_length_home = strlen($home_number);
                                        if($number_length_home == 10){
                                            $home_number = '+1'.trim($home_number);
                                        }
                                        elseif ($number_length_home == 11){
                                            $home_number = '+'.trim($home_number);
                                        }
                                        elseif ($number_length_home == 12) {
                                            $home_number = '+'.trim($home_number);
                                        }
                                    }
                                    
                                    if(isset($array['customer']['contact']['phone'][1]['@attributes']['type']))
                                    {
                                        $phone = null;
                                    }
                                    else
                                    {
                                        $phone = $array['customer']['contact']['phone'][1];
                                        
                                        $number_length = strlen($phone);
                                        if($number_length == 10){
                                            $phone = '+1'.trim($phone);
                                        }
                                        elseif ($number_length == 11){
                                            $phone = '+'.trim($phone);
                                        }
                                        elseif ($number_length == 12) {
                                            $phone = '+'.trim($phone);
                                        }
                                    }
                                    
                                    if(isset($array['customer']['contact']['phone'][2]['@attributes']['type']))
                                    {
                                        $work_number = null;
                                    }
                                    else
                                    {
                                        $work_number = $array['customer']['contact']['phone'][2];
                                        
                                        $number_length_work = strlen($work_number);
                                        if($number_length_work == 10){
                                            $work_number = '+1'.trim($work_number);
                                        }
                                        elseif ($number_length_work == 11){
                                            $work_number = '+'.trim($work_number);
                                        }
                                        elseif ($number_length_work == 12) {
                                            $work_number = '+'.trim($work_number);
                                        }
                                    }
                                }
                                else
                                {
                                    $phone = str_replace(array("-","(",")"," ","_"), "",$array['customer']['contact']['phone']);
                                    
                                    $number_length = strlen($phone);
                                    if($number_length == 10){
                                        $phone = '+1'.trim($phone);
                                    }
                                    elseif ($number_length == 11){
                                        $phone = '+'.trim($phone);
                                    }
                                    elseif ($number_length == 12) {
                                        $phone = '+'.trim($phone);
                                    }
                                }
                                
                            }
                        }
                        else
                        {
                            $phone = null;
                        }
                        
                        if(array_key_exists('name', $array['customer']['contact'])){
                            if(is_array($array['customer']['contact']['name']))
                            {
                                if(count($array['customer']['contact']['name']) == 2)
                                {
                                    $name_length = 2;
                                }
                                else
                                {
                                    $name_length = 3;
                                }
                            }
                            else
                            {
                                $name_length = 1;
                            }
                        }
                        else
                        {
                            $first_name = "Unknown";
                            $last_name = "Name";
                        }
                        
                        if($name_length == 1){
                            $splitName = explode(' ', $array['customer']['contact']['name']);
                            $first_name = str_replace(array("-","(",")"," "), "",$splitName[0]);
                            $last_name = !empty($splitName[1]) ? str_replace(array("-","(",")"," "), "",$splitName[1]) : ''; 
                        }
                        elseif($name_length == 2)
                        {
                            $first_name = str_replace(array("-","(",")"," "), "",$array['customer']['contact']['name'][0]);
                            $last_name = str_replace(array("-","(",")"," "), "",$array['customer']['contact']['name'][1]);
                        }
                        else
                        {
                            if(isset($array['customer']['contact']['name'][0]['@attributes']['part']))
                            {
                                $first_name = null;
                            }
                            else
                            {
                                $first_name = str_replace(array("-","(",")"," "), "",$array['customer']['contact']['name'][0]);
                            }
                            
                            if(isset($array['customer']['contact']['name'][1]['@attributes']['part']))
                            {
                                $last_name = null;
                            }
                            else
                            {
                                $last_name = str_replace(array("-","(",")"," "), "",$array['customer']['contact']['name'][1]);
                            }
                            
                            if(isset($array['customer']['contact']['name'][2]['@attributes']['part']))
                            {
                                $last_name = str_replace(array("-","(",")"," "), "",$array['customer']['contact']['name'][2]);
                            }
                            else
                            {
                                $last_name = str_replace(array("-","(",")"," "), "",$array['customer']['contact']['name'][2]);
                            }
                        }
                        
                        if(array_key_exists('address', $array['customer']['contact'])){
                            
                            if(is_array($array['customer']['contact']['address']))
                            {
                                $zip = null;
                            }
                            else
                            {
                                if(array_key_exists('street', $array['customer']['contact']['address'])){
                                    $check_street = array('@attributes' => array('line' => 1));
                                    if($array['customer']['contact']['address']['street'] != $check_street){  
                                        $address = $array['customer']['contact']['address']['street'];  
                                    }
                                }
                                if(array_key_exists('city', $array['customer']['contact']['address'])){
                                    $check_street = array('@attributes' => array('line' => 1));
                                    if($array['customer']['contact']['address']['city'] != $check_street){  
                                        $city = $array['customer']['contact']['address']['city'];  
                                    }
                                }
                                if(array_key_exists('regioncode', $array['customer']['contact']['address'])){
                                    $check_street = array('@attributes' => array('line' => 1));
                                    if($array['customer']['contact']['address']['regioncode'] != $check_street){  
                                        $state = $array['customer']['contact']['address']['regioncode'];  
                                    }
                                }
                                if(array_key_exists('postalcode', $array['customer']['contact']['address'])){
                                    $check_street = array('@attributes' => array('line' => 1));
                                    if($array['customer']['contact']['address']['postalcode'] != $check_street){  
                                        $zip = str_replace(array("-","(",")"," "), "",$array['customer']['contact']['address']['postalcode']);
                                    }
                                }
                            }
                        }
                        
                        if(array_key_exists('id', $body->prospect))
                        {
                            foreach($body->prospect->id[0]->attributes() as $a => $b) {
                                if($a == "source")
                                {
                                    $source = $b;
                                }
                                
                                if($a == "type")
                                {
                                    $source = $b;
                                }
                            }
                        }
                        
                        if(empty($source))
                        {
                            $extract = explode("@",$listing->from);
                            $mail = explode(".",$extract[1]);
                    
                            $source = ucwords(str_replace("-", " ",$mail[0]));
                        }
        
                        $data = [];
                        $leads_email = null;
                        if(array_key_exists('email', $array['customer']['contact']))
                        {
                            if(is_array($array['customer']['contact']['email']))
                            {
                                if(!empty($array['customer']['contact']['email'][0]))
                                {
                                    $leads_email  = str_replace(array("-","(",")"," "), "",$array['customer']['contact']['email'][0]);
                                }
                            }
                            else
                            {
                                if(!empty($array['customer']['contact']['email']))
                                {
                                    $leads_email  = str_replace(array("-","(",")"," "), "",$array['customer']['contact']['email']);
                                }
                            }
                        }
                        
                        if(empty($leads_email))
                        {
                            $check_email = null;
                        }else
                        {
                            $check_email = DB::table('leads')->where('email',$leads_email)->where('admin_email',$vendor_email)->first();
                        }
                        
                        if(empty($phone))
                        {
                            $check_phone = null;
                        }else
                        {
                            $check_phone = DB::table('leads')->where('contact',$phone)->where('admin_email',$vendor_email)->first();
                        }
                        
                        if($check_phone == null)
                        {
                            if($check_email == null)
                            {
                                $lat = null;
                                $lng = null;
            
                                if($zip != null)
                                {
                                    $zipcode = $zip;
                                    $url = "https://maps.googleapis.com/maps/api/geocode/json?address=".urlencode($zipcode)."&sensor=false&key=AIzaSyDsft6f2XKBV0G42r8fw7PAo-DETqq9iR0";
                                    $details=file_get_contents($url);
                                    $result = json_decode($details,true);
            
                                    if (isset($result['status']) && ($result['status'] == 'OK'))
                                    {
                                        $lat = $result['results'][0]['geometry']['location']['lat'];
                                        $lng = $result['results'][0]['geometry']['location']['lng'];
                                    }
                                }   
                                
                                $interest_url = null;
                                if(array_key_exists('url', $array['provider']))
                                {
                                    $interest_url = $array['provider']['url'];
                                    
                                    if(empty($array['provider']['url']))
                                    {
                                        $interest_url = null;
                                    }
                                    else
                                    {
                                        $interest_url = $array['provider']['url'];
                                    }
                                }
                                
                                $data = [
                                    'lead_provider' => $source,
                                    'admin_email' => $vendor_email,
                                    'assigned_date' => date("d-m-Y"),
                                    'email' => $leads_email,
                                    'contact' => $phone,
                                    'status' => 'unassigned',
                                    'classification' => 'Sales',
                                    'sender_first_name' => $first_name,
                                    'sender_last_name' => $last_name,
                                    'address' => $address,
                                    'city' => $city,
                                    'state' => $state,
                                    'zip' => $zip,
                                    'lat' => $lat,
                                    'lng' => $lng,
                                    'lead_status' => 'Active-Fresh',
                                    'lead_url' => $interest_url,
                                    'created_at' => $listing->email_datetime,
                                ];
                                
                                $insert = DB::table('leads')->insertGetId($data);
                                
                                if(array_key_exists('year', $array['vehicle'])){
                                    if(!empty($array['vehicle']['year']))
                                    {
                                        $car_year = str_replace(array("-","(",")"," ","_"), "",$array['vehicle']['year']);
                                    }
                                }
                                if(array_key_exists('make', $array['vehicle'])){
                                    if(!empty($array['vehicle']['make']))
                                    {
                                        $car_make = str_replace(array("-","(",")"," ","_"), "",$array['vehicle']['make']);
                                    }
                                }
                                if(array_key_exists('model', $array['vehicle'])){
                                    if(!empty($array['vehicle']['model']))
                                    {
                                        $car_model = str_replace(array("-","(",")"," ","_"), "",$array['vehicle']['model']);
                                    }
                                }
                                if(array_key_exists('vin', $array['vehicle'])){
                                    if(!empty($array['vehicle']['vin']))
                                    {
                                        $car_vin = str_replace(array("-","(",")"," ","_"), "",$array['vehicle']['vin']);
                                    }
                                }
                                
                                $inventory_info = [
                                    'lead_id' => $insert,
                                    'year' => $car_year,
                                    'make' => $car_make,
                                    'model' => $car_model,
                                    'vin' => $car_vin
                                ];
                                
                                DB::table('leads_inventory_info')->insert($inventory_info);
                                
                                if($home_number != null || $work_number != null)
                                {
                                    DB::table('lead_general_info')->insert(["user_id" => $listing->user_id, "lead_id" => $insert, "home_contact" => $home_number, "work_contact" => $work_number]);
                                }
                                
                                if($insert)
                                {
                                    $super_admin = DB::table('users')->where('usertype_id',1)->get();
                                    
                                    foreach ($super_admin as $rows) {
                                        $notearr = [
                                            'lead_id' => $insert,
                                            'notification_message' => 'New Lead',
                                            'user_id' => $rows->id,
                                            'type' => 'lead',
                                            'status' => 'new'
                                        ];
        
                                        DB::table('notifications')->insert($notearr);
                                    }
        
                                    if($userData)
                                    {
                                        $notearr = [
                                            'lead_id' => $insert,
                                            'notification_message' => 'New Lead',
                                            'user_id' => $userData->id,
                                            'type' => 'lead',
                                            'status' => 'new'
                                        ];
        
                                        DB::table('notifications')->insert($notearr);
                                        
                                    }
                                    
                                    if($phone != null)
                                    {
                                        $roboText = DB::table('manaul_robo_text')->where('sender_id',$listing->user_id)->where('status','active')->where('type','default_fresh')->first();
                                        
                                        if($roboText != null)
                                        {
                                            if($first_name == "Unknown" || strtolower($first_name) == "none")
                                            {
                                                $message_body = "Hey, ".$roboText->text;
                                            }
                                            else
                                            {
                                                $message_body = "Hey ".$first_name.", ".$roboText->text;
                                            }
                                            
                                            try{
                                                $send_message = $client->messages->create(
                                                    $phone,
                                                    array(
                                                        'from' => $userCompany->phone_number,
                                                        'body' => $message_body
                                                    )
                                                );
                                            } catch(\Twilio\Exceptions\RestException $e)
                                            {
                                                DB::table('leads')->where('id',$insert)->update(['lead_status' => 'Wrong Number']);
                                                $send_message = null;
                                            }
                                            
                                            if($send_message != null)
                                            {
                                                $get_max_value = DB::table('lead_chat')->max('chat_id');
                                                
                                                $count = $get_max_value + 1;
                    
                                                $send = [
                                                'admin_id' => $listing->user_id,
                                                'lead_id' => $insert,
                                                'from' => $userCompany->phone_number,
                                                'to' => $phone,
                                                'message' => $message_body,
                                                'internal' => 0,
                                                'chat_id' => $count,
                                                'seen' => 'fresh'
                                                ];
                                                
                                                $message_insert = DB::table('lead_chat')->insert($send);
                                            }
                                        }
                                        
                                    }
                                    else
                                    {
                                        DB::table('leads')->where('id',$insert)->update(['lead_status' => 'Invalid Cell Number']);
                                    }
                                }
                                    
                            }
                        }
                        
                    }
                }
            }
        }
        else
        {
            $google_api = DB::table('google_sheet_api')->get();
        
            if($google_api->count() > 0)
            {
                foreach($google_api as $google_api)
                {
                    $spreadsheet_url="https://docs.google.com/spreadsheets/d/e/".$google_api->api_key."/pub?gid=0&single=true&output=csv";
            
                    if(!ini_set('default_socket_timeout', 1500)) echo "<!-- unable to change socket timeout -->";
                    
                    if (($handle = fopen($spreadsheet_url, "r")) !== FALSE) {
                        $get_admin_email = DB::table('users')->where('id',$google_api->user_id)->first(['email']);
                        $get_admin_company = DB::table('company_info')->where('user_id',$google_api->user_id)->first(['phone_number']);
                        $adminEmail = $get_admin_email->email;
                
                        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) 
                        {
                            $first_name = "Unknown";
                            $last_name = "Lead";
                            
                            if(!empty($data[1]))
                            {
                                $explodeName = explode(" ", $data[1]);
                                
                                if(count($explodeName) == 2)
                                {
                                    $first_name = $explodeName[0];
                                    $last_name = $explodeName[1];
                                }
                                else
                                {
                                    $first_name = $explodeName[0];
                                    $last_name = $explodeName[0];
                                }
                            }
                               
                            $customer_phone = null;
                            
                            if(!empty($data[3]))
                            {
                                $number_length = strlen($data[3]);
                                if($number_length == 10){
                                    $customer_phone = '+1'.trim($data[3]);
                                }
                                elseif ($number_length == 11){
                                    $customer_phone = '+'.trim($data[3]);
                                }
                                elseif ($number_length == 12) {
                                    $customer_phone = trim($data[3]);
                                }
                                else
                                {
                                    $customer_phone = trim($data[3]);
                                }
                            }
                            
                            $email_exist = DB::table('leads')->where('admin_email',$adminEmail)->where('email',$data[2])->first();
                            $contact_exist = DB::table('leads')->where('admin_email',$adminEmail)->where('contact',$customer_phone)->first();
                     
                            if($email_exist == null)
                            {
                                if($contact_exist == null)
                                {
                                    $data = [
                                        'lead_provider' => "Facebook",
                                        'admin_email' => $adminEmail,
                                        'assigned_date' => date("d-m-Y"),
                                        'email' => $data[2],
                                        'contact' => $customer_phone,
                                        'status' => 'unassigned',
                                        'classification' => 'Sales',
                                        'sender_first_name' => $first_name,
                                        'sender_last_name' => $last_name,
                                        'address' => null,
                                        'city' => null,
                                        'state' => null,
                                        'zip' => null,
                                        'lead_status' => 'Active-Fresh',
                                        'lead_url' => null,
                                    ];
                                    
                                    $insert = DB::table('leads')->insertGetId($data);
                                    
                                    $roboText = DB::table('manaul_robo_text')->where('sender_id',$get_admin_email->id)->where('status','active')->where('type','default_fresh')->first();
                                        
                                    if($roboText != null)
                                    {
                                        $message_body = null;
                                        if($first_name == "Unknown" || strtolower($first_name) == "none")
                                        {
                                            $message_body = "Hey, ".$roboText->text;
                                        }
                                        else
                                        {
                                            $message_body = "Hey ".$first_name.", ".$roboText->text;
                                        }
                                        
                                        if($customer_phone == null)
                                        {
                                            DB::table('leads')->where('id',$insert)->update(['lead_status' => 'Wrong Number']);
                                        }
                                        else
                                        {
                                            try{
                                                $send_message = $client->messages->create(
                                                    $customer_phone,
                                                    array(
                                                        'from' => $get_admin_company->phone_number,
                                                        'body' => $message_body
                                                    )
                                                );
                                            } catch(\Twilio\Exceptions\RestException $e){
                                                DB::table('leads')->where('id',$insert)->update(['lead_status' => 'Wrong Number']);
                                                $send_message = null;
                                            }
                                            
                                            if($send_message != null)
                                            {
                                                $get_max_value = DB::table('lead_chat')->max('chat_id');
                                                
                                                $count = $get_max_value + 1;
                    
                                                $send = [
                                                'admin_id' => $get_admin_email->id,
                                                'lead_id' => $insert,
                                                'from' => $get_admin_company->phone_number,
                                                'to' => $customer_phone,
                                                'message' => $message_body,
                                                'internal' => 0,
                                                'chat_id' => $count,
                                                'seen' => 'fresh'
                                                ];
                                                
                                                $message_insert = DB::table('lead_chat')->insert($send);
                                            }
                                        }
                                    }   
                                        
                                }
                            }
                            
                        }
                        fclose($handle);
                    }
                    
                }
            }
            else
            {
                return "false";
            }
        }
    }

    
}
