<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Traits\FirebaseTrait;
use Illuminate\Support\Facades\Auth;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

Route::post('response',function(Request $req){
    
    $get_admin_ids = array();
    $get_admin_from_ninja = DB::table('ninja_assign')->whereIn('ninja_id',[416,452])->pluck('user_id')->all();
    $checkUser = DB::table('users')->where('id',247)->first();
    
    if($checkUser->usertype_id  == 2){
        
        $get_admins = DB::table('users')->whereIn('id', $get_admin_from_ninja)->where('id', 231)->value('id');
        $get_agents = DB::table('users')->where('parent_user_id', $get_admins)->where("approval", "approve")->whereNotNull('device_token')->pluck('id');
        $get_agents[] = $get_admins;    
            
    }elseif($checkUser->usertype_id  == 4){
        
        
        $get_admins = DB::table('users')->whereIn('parent_user_id', $get_admin_from_ninja)->where('id', 247)->value('parent_user_id');
        $get_agents = DB::table('users')->where('parent_user_id', $get_admins)->where("approval", "approve")->whereNotNull('device_token')->pluck('id');
        $get_agents[] = $get_admins; 
        
    }
    
    $firebaseToken1 = DB::table('users')->whereIn('id',$get_agents)->pluck('device_token')->all();
    $firebaseToken2 = DB::table('users')->whereIn('id',$get_agents)->pluck('device_token_web')->all();
    $firebaseToken = array_merge($firebaseToken1, $firebaseToken2);
    return $firebaseToken;
    $response = FirebaseTrait::sendPushNotidication($req->title,$req->body,$req->token);
    return $response;
    $result = $req->all();
     
    return $result['status'];
});


// Route::get('/test-header', function (Request $request) {
//     dd($request->header());
// });


Route::group([ 'prefix' => 'auth'], function (){
    Route::group(['middleware' => ['guest:api']], function () {
        // Route::post('login/app', 'app\Http\Controllers\Api\AuthController@login');
        Route::post('login/app', [App\Http\Controllers\Api\AuthController::class, 'login']);
        
        Route::post('signup', [App\Http\Controllers\Api\AuthController::class ,'signup']);
        
        Route::post('/forgot-password-email',[App\Http\Controllers\Api\AuthController::class ,'forgotPasswordPost']);
        Route::post('/reset-password',[App\Http\Controllers\Api\AuthController::class , 'resetPasswordPost']);
    });

// Route::group(['middleware' => ['auth:api']], function () {
    Route::post('/long/life', [App\Http\Controllers\Api\AuthController::class, 'longLife']);
    Route::get('/dashboard', [App\Http\Controllers\Api\DashboardController::class, 'dashboard']);
    Route::post('/desklog-filters', [App\Http\Controllers\Api\DashboardController::class, 'todayActivityFilter']);
    Route::get('/desklog', [App\Http\Controllers\Api\DashboardController::class, 'todayActivity']);
    Route::get('/logout', [App\Http\Controllers\Api\AuthController::class, 'logout']);
    Route::get('/appointment-view', [App\Http\Controllers\Api\DashboardController::class, 'appointmentview']);
    Route::get('/upcoming_appointments', [App\Http\Controllers\Api\DashboardController::class, 'upcomingApp']);
    Route::get('/showed-up-appointment', [App\Http\Controllers\Api\DashboardController::class, 'showedUpAppointmentView']);
    Route::get('/leadsource', [App\Http\Controllers\Api\DashboardController::class, 'leadsource']);
    Route::post('/desklog-filter', [App\Http\Controllers\Api\DashboardController::class, 'Filter_todayActivity']);
    Route::get('/agents', [App\Http\Controllers\Api\DashboardController::class, 'agents']);
    Route::get('/reminders', [App\Http\Controllers\Api\DashboardController::class, 'reminders']);
    Route::get('/lead-reminder/{id}', [App\Http\Controllers\Api\DashboardController::class, 'leadReminder']);
    Route::get('/calls-filter', [App\Http\Controllers\Api\PhonecallsController::class, 'getStatusCalls']);
    Route::get('/today-text-page', [App\Http\Controllers\Api\TextController::class, 'textChatView']);

    Route::get('getuser', [App\Http\Controllers\Api\AuthController::class, 'getUser']);
    Route::get('/total_text_leads', [App\Http\Controllers\Api\TextController::class, 'totalTextLeads']);
    Route::get('/get_lead/{id}', [App\Http\Controllers\Api\TextController::class, 'getLead']);
    Route::get('/logs/{lead_id}', [App\Http\Controllers\Api\TextController::class, 'LeadLogs']);
    Route::get('/appointnments/{lead_id}', [App\Http\Controllers\Api\TextController::class, 'LeadAppointnments']);
    Route::get('/notes/{lead_id}', [App\Http\Controllers\Api\TextController::class, 'LeadNotes']);
    Route::post('/leads-filter', [App\Http\Controllers\Api\FilterleadsController::class, 'filterleads']);
    Route::get('/unassigned/leads', [App\Http\Controllers\Api\UnassignedLeadsController::class, 'unassignedleads']);
    Route::post('/filter-unassigned-leads', [App\Http\Controllers\Api\UnassignedLeadsController::class, 'filterUnassignedLeads']);
    Route::get('/assigned/leads', [App\Http\Controllers\Api\TextController::class, 'assignedleads']);
    Route::post('/filter-assigned-leads', [App\Http\Controllers\Api\TextController::class, 'filterAssignedLeads']);
    Route::get('/voicemail-blast-view', [App\Http\Controllers\Api\VoicemailblastController::class, 'voicemailblast']);
    Route::get('/chat-view', [App\Http\Controllers\Api\TextController::class, 'chatview']);
    Route::get('/chat-messages/{leadid}', [App\Http\Controllers\Api\TextController::class, 'fetchMessages']);
    Route::get('/get-all-messages', [App\Http\Controllers\Api\TextController::class, 'getAllMessages']);
    Route::post('/translation', [App\Http\Controllers\Api\TextController::class, 'textTranslation']);
    
    // Chat Stream
    Route::get('/message-stream/{id?}', [App\Http\Controllers\Api\TextController::class, 'messageStream']);
    
    Route::post('/change-assign-agent', [App\Http\Controllers\Api\ChatController::class, 'assignUser']);
    Route::post('/change-lead-status', [App\Http\Controllers\Api\ChatController::class, 'leadstatus']);
    Route::post('/change-lead-source', [App\Http\Controllers\Api\ChatController::class, 'leadsourcechange']);
    Route::post('/change-lead-class', [App\Http\Controllers\Api\ChatController::class, 'leadclasschange']);
    Route::post('/set-appointment', [App\Http\Controllers\Api\ChatController::class, 'setAppointment']);
    Route::post('/set-reminder', [App\Http\Controllers\Api\ChatController::class, 'setreminder']);
    Route::post('/send-message', [App\Http\Controllers\Api\ChatController::class, 'messageSend']);
    Route::post('/appraise-vehicle', [App\Http\Controllers\Api\ChatController::class, 'apraiseVechilelink']);
    Route::post('/chat-image-file', [App\Http\Controllers\Api\ChatController::class, 'chatImageFile']);
    Route::post('/chat-video-file', [App\Http\Controllers\Api\ChatController::class, 'chatVideoFile']);
    Route::post('/credit-application-pin', [App\Http\Controllers\Api\ChatController::class, 'creditpinApi']);
    Route::get('/credit-application-view', [App\Http\Controllers\Api\DashboardController::class, 'creditApplicationView']);
    Route::post('/credit-application-link', [App\Http\Controllers\Api\DashboardController::class, 'creditApplicationpdflink']);
    Route::post('/uploaded-mms-list', [App\Http\Controllers\Api\ChatController::class, 'getMmsLibrary']);
    Route::post('/archive-lead-api', [App\Http\Controllers\Api\ChatController::class, 'archiveChatApi']);
    Route::post('/push-message-added', [App\Http\Controllers\Api\ChatController::class, 'quickAnswerAdd']);
    Route::get('/show-push-messages', [App\Http\Controllers\Api\ChatController::class, 'getAnswers']);
    Route::post('/remove-push-message', [App\Http\Controllers\Api\ChatController::class, 'quickAnswerRemoveApi']);
    Route::get('/get/vin/info', [App\Http\Controllers\Api\ChatController::class, 'getVinInfo']);
    Route::get('/phone/log', [App\Http\Controllers\Api\ChatController::class, 'phoneLog']);
    Route::get('/lead-chat/log/detail', [App\Http\Controllers\Api\ChatController::class, 'leadchatlog']);
    Route::get('/email/log', [App\Http\Controllers\Api\ChatController::class, 'leademailog']);
    Route::get('/ringlessvoicemail/log', [App\Http\Controllers\Api\ChatController::class, 'ringlessVmlogview']);
    Route::post('/changed/lead-status-type', [App\Http\Controllers\Api\ChatController::class, 'leadstatustype']);
    Route::get('/update/leadinfo', [App\Http\Controllers\Api\ChatController::class, 'updateLeadinfo']);
    Route::get('/add-new-num', [App\Http\Controllers\Api\ChatController::class, 'Addnum']);
    Route::get('/update-new-number', [App\Http\Controllers\Api\ChatController::class, 'updateNumber']);
    Route::get('/mark-primary-number', [App\Http\Controllers\Api\ChatController::class, 'markprimary']);
    Route::get('/add-email', [App\Http\Controllers\Api\ChatController::class, 'addemail']);
    Route::get('/edit-email', [App\Http\Controllers\Api\ChatController::class, 'editemail']);
    Route::post('/add-notes', [App\Http\Controllers\Api\ChatController::class, 'updateNotes']);
    Route::get('/delete-note', [App\Http\Controllers\Api\ChatController::class, 'DeletNotes']);
    Route::post('/chat-rinless-voicemail-send', [App\Http\Controllers\Api\ChatController::class, 'ringlessVoiceMailer']);
    
    // SMS blast
    Route::post('/add-lead-blast', [App\Http\Controllers\Api\SMSblastController::class, 'leadBlastPost']);
    Route::get('/sms-blast-view', [App\Http\Controllers\Api\SMSblastController::class, 'smsblast']);
    Route::get('/sms-saved-templates', [App\Http\Controllers\Api\SMSblastController::class, 'savedTemplats']);
    Route::get('/sms-draft', [App\Http\Controllers\Api\SMSblastController::class, 'smsDraft']);
    Route::post('/smsblast-imageupload', [App\Http\Controllers\Api\SMSblastController::class, 'blastImageFile']);
    Route::post('/delete-sms-blast', [App\Http\Controllers\Api\SMSblastController::class, 'leadBlastDelete']);
    Route::post('/edit-sms-blast', [App\Http\Controllers\Api\SMSblastController::class, 'leadBlastUpdate']);
    Route::post('/activate-blast', [App\Http\Controllers\Api\SMSblastController::class, 'activateCampaign']);
    Route::post('/add-short-url', [App\Http\Controllers\Api\SMSblastController::class, 'addShortUrl']);
    Route::post('/sms-blast-filters', [App\Http\Controllers\Api\SMSblastController::class, 'leadcount']);
    Route::get('/incomming-blasts', [App\Http\Controllers\Api\SMSblastController::class, 'incommingBlasts']);
    
    // MMS Blast
    Route::get('/mms-blast-view', [App\Http\Controllers\Api\MMsblastController::class, 'mmsblast']);
    Route::get('/mms-saved-templates', [App\Http\Controllers\Api\MMsblastController::class, 'savedTemplats']);
    Route::get('/mms-draft', [App\Http\Controllers\Api\MMsblastController::class, 'mmsDraft']);
    Route::get('/mms-attachments', [App\Http\Controllers\Api\MMsblastController::class, 'mmsAttachments']);
    Route::post('/add-mms-blast', [App\Http\Controllers\Api\MMsblastController::class, 'mmsBlastPost']);
    Route::post('/update-mms-blast', [App\Http\Controllers\Api\MMsblastController::class, 'mmsBlastUpdate']);
    Route::post('/mmsblast-imageupload', [App\Http\Controllers\Api\MMsblastController::class, 'mmsBlastImageFile']);
    Route::post('/delete-mms-blast', [App\Http\Controllers\Api\MMsblastController::class, 'mmsBlastDelete']);
    
    // Email Blast
    Route::get('/email-blast-view', [App\Http\Controllers\Api\EmailblastController::class, 'emailblast']);
    Route::get('/email-blast-templates', [App\Http\Controllers\Api\EmailblastController::class, 'emailblastTemplates']);
    Route::post('/add-email-blast', [App\Http\Controllers\Api\EmailblastController::class, 'emailBlastPost']);
    Route::post('/update-email-blast', [App\Http\Controllers\Api\EmailblastController::class, 'emailBlastUpdate']);
    Route::post('/delete-email-blast', [App\Http\Controllers\Api\EmailblastController::class, 'emailBlastDelete']);
    Route::post('/email-blast-image-file', [App\Http\Controllers\Api\EmailblastController::class, 'emailBlastImageFile']);
    
    // RVM Blast
    Route::get('/voicemail-blast-view', [App\Http\Controllers\Api\VoicemailblastController::class, 'voicemailblast']);
    Route::get('/rvm-draft', [App\Http\Controllers\Api\VoicemailblastController::class, 'rvmDraft']);
    Route::post('/add-voicemail-blast', [App\Http\Controllers\Api\VoicemailblastController::class, 'voicemailPost']);
    Route::post('/delete-rvm-blast', [App\Http\Controllers\Api\VoicemailblastController::class, 'voicemailDelete']);
    Route::post('/update-rvm-blast', [App\Http\Controllers\Api\VoicemailblastController::class, 'voicemailUpdate']);
    Route::post('/uploded-files-rvm', [App\Http\Controllers\Api\VoicemailblastController::class, 'getRvmLibrary']);
    Route::post('/uplod-file-rvm', [App\Http\Controllers\Api\VoicemailblastController::class, 'uploadRvmLibrary']);
    
    Route::post('/get-inventory-list', [App\Http\Controllers\Api\InventoryController::class, 'chatinventorylist']);
    Route::get('/get-inventory-detail', [App\Http\Controllers\Api\InventoryController::class, 'getInventoryDetail']);
    Route::post('/send-inventory-packet', [App\Http\Controllers\Api\InventoryController::class, 'sendInventoryDetail']);
    Route::post('/filter-inventory-list', [App\Http\Controllers\Api\InventoryController::class, 'inventoryfilter']);
    Route::get('/appraise-vehicle-view', [App\Http\Controllers\Api\DashboardController::class, 'AppraisevehicleView']);
    Route::post('/get-vin-info-chatpage', [App\Http\Controllers\Api\InventoryController::class, 'getVinInfo']);
    Route::post('/inventory-send-shortlink', [App\Http\Controllers\Api\InventoryController::class, 'sendInventoryLink']);
    Route::post('/editinventory-bysearch', [App\Http\Controllers\Api\InventoryController::class, 'editInventoryChat']);
    Route::get('/change-inventory', [App\Http\Controllers\Api\InventoryController::class, 'changeInventoryChat']);
    Route::get('/remove-inventory-chat', [App\Http\Controllers\Api\InventoryController::class, 'removeInventoryChat']);

    Route::get('/kpi-dashboard-today', [App\Http\Controllers\Api\KpisController::class, 'kpistodayview']);
    Route::get('/kpi-dashboard-week', [App\Http\Controllers\Api\KpisController::class, 'kpisweekview']);
    Route::post('/kpi-dashboard-custom', [App\Http\Controllers\Api\KpisController::class, 'kpicustomesearch']);
    Route::post('/filter/kpi-status/today', [App\Http\Controllers\Api\KpisController::class, 'statusFilter']);
    Route::post('/filter/kpi-staus-level1', [App\Http\Controllers\Api\KpisController::class, 'statusFilterdate']);
    Route::post('/filter/kpi-status-level2', [App\Http\Controllers\Api\KpisController::class, 'statusFilterdate_level2']);
    Route::get('/chat_log_kpi', [App\Http\Controllers\Api\KpisController::class, 'chatLogs']);
    Route::post('/chat-log-kpi/filter', [App\Http\Controllers\Api\KpisController::class, 'chatFilters']);
    Route::post('/leadreport/today-week', [App\Http\Controllers\Api\KpisController::class, 'leadReportPDF']);
    Route::post('/customleadreport/level1', [App\Http\Controllers\Api\KpisController::class, 'customLeadReportdownload']);
    Route::get('/lead_source_kpi', [App\Http\Controllers\Api\LeadsourceController::class, 'leadSourceView']);
    Route::post('/custome_lead_source', [App\Http\Controllers\Api\LeadsourceController::class, 'customApi']);

    Route::get('/teamactivity-view', [App\Http\Controllers\Api\TeamController::class, 'teamActivityView']);
    Route::post('/custom-teamactivity', [App\Http\Controllers\Api\TeamController::class, 'customteamActivity']);

    Route::get('/workflow-view', [App\Http\Controllers\Api\ImportController::class, 'workFlowView']);
    Route::post('/add-text-email-workflow', [App\Http\Controllers\Api\ImportController::class, 'workFlowAdd']);
    Route::post('/edit-workflow-view', [App\Http\Controllers\Api\ImportController::class, 'workFlowEdit']);
    Route::post('/update-workflow', [App\Http\Controllers\Api\ImportController::class, 'workFlowUpdate']);
    Route::post('/delete-workflow', [App\Http\Controllers\Api\ImportController::class, 'workFlowDel']);
    Route::post('/start-pause-workflow', [App\Http\Controllers\Api\ImportController::class, 'workFlowStart']);

    Route::get('/robo-text-view', [App\Http\Controllers\Api\ImportController::class, 'viewRoboTextTest']);
    Route::post('/add-robo-text', [App\Http\Controllers\Api\ImportController::class, 'addRoboTextTest']);
    Route::post('/change-robotext-status', [App\Http\Controllers\Api\ImportController::class, 'roboTextChangeStatus']);
    Route::post('/edit-robo-text', [App\Http\Controllers\Api\ImportController::class, 'editRoboTextTest']);
    Route::post('/update-robo-text-bulk', [App\Http\Controllers\Api\ImportController::class, 'updateRoboTextTest']);

    Route::get('/feedback-view', [App\Http\Controllers\Api\FeedbackController::class, 'getFeedbacks']);
    Route::post('/feedback_submit', [App\Http\Controllers\Api\FeedbackController::class, 'feedbackPost']);
    Route::post('/feedbak-image-files', [App\Http\Controllers\Api\FeedbackController::class, 'feedbackImageFiles']);
    Route::get('/all-feedback-messages', [App\Http\Controllers\Api\FeedbackController::class, 'getAllFeedbackMessage']);
    Route::get('/feedback-chat/popup', [App\Http\Controllers\Api\FeedbackController::class, 'showFeedbackChatPopup']);
    Route::post('/feedback-chat', [App\Http\Controllers\Api\FeedbackController::class, 'getFeedbackscustom']);
    Route::post('/send-message-feedback', [App\Http\Controllers\Api\FeedbackController::class, 'messageSendfeedback']);
    Route::get('/manual-lead-view', [App\Http\Controllers\Api\ManualleadsController::class, 'manualLeadView']);
    Route::post('/car-models', [App\Http\Controllers\Api\ManualleadsController::class, 'carModels']);
    Route::post('/add-manual-lead', [App\Http\Controllers\Api\ManualleadsController::class, 'manualLeadPost']);
    // Notification
    Route::get('/notification', [App\Http\Controllers\Api\NotificationController::class, 'notification']);
    Route::get('/notification/count', [App\Http\Controllers\Api\NotificationController::class, 'notificationCount']);
    Route::get('/notification/read/all', [App\Http\Controllers\Api\NotificationController::class, 'notificationReadAll']);
    Route::get('/notification/read/{id?}', [App\Http\Controllers\Api\NotificationController::class, 'notificationRead']);
    
    Route::get('/archive-text', [App\Http\Controllers\Api\TextController::class, 'archiveChatView']);
    Route::get('/phone-call-view', [App\Http\Controllers\Api\PhonecallsController::class, 'phonecallview']);

    Route::get('account/setting-view', [App\Http\Controllers\Api\SettingController::class, 'settingView']);
    Route::get('account/user-view', [App\Http\Controllers\Api\UserController::class, 'usersView']);
    Route::get('/add-user-view', [App\Http\Controllers\Api\UserController::class, 'addUserView']);
    Route::post('/add-user-agent', [App\Http\Controllers\Api\UserController::class, 'addUser']);
    Route::post('/edit-user-view-agent', [App\Http\Controllers\Api\UserController::class, 'editUserView']);
    Route::post('/edit-user-agent', [App\Http\Controllers\Api\UserController::class, 'editUser']);
    Route::post('/report-change-status-update', [App\Http\Controllers\Api\UserController::class, 'reportUpdate']);
    Route::post('/add-report-addtional-details', [App\Http\Controllers\Api\UserController::class, 'reportAdditionalDetail']);
    Route::post('/company-detail-update', [App\Http\Controllers\Api\SettingController::class, 'companyDetail']);
    Route::post('/master-search', [App\Http\Controllers\Api\DashboardController::class, 'masterSearch']);
    Route::post('/chat-count', [App\Http\Controllers\Api\DashboardController::class, 'textCount']);

    Route::get('/agents-peter', [App\Http\Controllers\Api\TextController::class, 'check']);
    
    Route::post('/sync/device/token', [App\Http\Controllers\Api\ChatController::class, 'syncDeviceToken']);
// });
    Route::post('/version-update',[App\Http\Controllers\Api\NotificationController::class,'versionUpdate']);
    Route::post('/version-check',[App\Http\Controllers\Api\NotificationController::class,'versionCheck']);
    
    
    
});


// Route::group([

//     'middleware' => 'api',
//     'prefix' => 'auth'

// ], function ($router) {

//     Route::post('login', 'AuthController@login');
//     Route::post('logout', 'AuthController@logout');
//     Route::post('refresh', 'AuthController@refresh');
//     Route::post('me', 'AuthController@me');

// });
//    Route::get('logout', 'Api\AuthController@logout');
    Route::get('user', [App\Http\Controllers\Api\AuthController::class ,'user']);
    Route::post('/lead-info',[App\Http\Controllers\Api\ChatController::class ,'leadInfoApi']);
    Route::post('/send-message-bot',[App\Http\Controllers\Api\ChatController::class ,'messageSendApi']);
    Route::post('/recive-message-bot',[App\Http\Controllers\Api\ChatController::class,'responseMessageApi']);
    
    
    Route::post('/receive/message/response',[App\Http\Controllers\Api\ChatController::class,'responseMessageApi']);
    
    Route::any('/receive/email/response',[App\Http\Controllers\Api\Mailgun\EmailController::class , 'getEmailResponse']);
    
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:api')->get('/user', function (Request $request) {
    return $request->user();
});
