<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms;

use Twilio\Exceptions\TwilioException;
use Twilio\ListResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
class BrandedCallList extends ListResource {
    /**
     * Construct the BrandedCallList
     *
     * @param Version $version Version that contains the resource
     */
    public function __construct(Version $version) {
        parent::__construct($version);

        // Path Solution
        $this->solution = [];

        $this->uri = '/Business/BrandedCalls';
    }

    /**
     * Create a new BrandedCallInstance
     *
     * @param string $from Twilio number from which to brand the call
     * @param string $to The terminating Phone Number
     * @param string $reason The business reason for this phone call
     * @param array|Options $options Optional Arguments
     * @return BrandedCallInstance Newly created BrandedCallInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function create(string $from, string $to, string $reason, array $options = []): BrandedCallInstance {
        $options = new Values($options);

        $data = Values::of([
            'From' => $from,
            'To' => $to,
            'Reason' => $reason,
            'CallSid' => $options['callSid'],
        ]);

        $payload = $this->version->create(
            'POST',
            $this->uri,
            [],
            $data
        );

        return new BrandedCallInstance($this->version, $payload);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Preview.TrustedComms.BrandedCallList]';
    }
}