<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\Leadlog;
use Illuminate\Support\Facades\Cache;

class PhonecallsController extends BaseController{

    public function phonecallview() {
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        if($user->usertype_id == 2){

            $log = Leadlog::with(['lead' => function($query){
                                $query->with(['leadInventory'])->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                                      ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                      ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip');
                            }])->select('lead_logs.record_sid','lead_logs.status','lead_logs.lead_id','lead_logs.created_at','leads.id as leadid','leads.lead_provider','leads.sender_first_name','leads.sender_last_name','leads.lead_status','leads.contact as leadnumber','company_info.name as companyname','leads.admin_email')
                            ->leftjoin('leads','leads.id','lead_logs.lead_id')
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('company_info','company_info.user_id','users.id')
                            ->where('leads.admin_email',$user->email)
                            ->orderby('lead_logs.created_at','desc')
                            ->get();

            $count = Leadlog::select()->leftjoin('leads','leads.id','lead_logs.lead_id')->where('leads.admin_email',$user->email)->count('*');

        }

        elseif($user->usertype_id == 4){
            
            $log = Leadlog::with(['lead' => function($query){
                                $query->with(['leadInventory'])->leftjoin('users as agents','agents.id','leads.assigned_user_id')
                                      ->leftjoin('lead_general_info','lead_general_info.lead_id','leads.id')
                                      ->select('leads.id','leads.sender_first_name as lead_first_name','leads.sender_last_name as lead_last_name','leads.assigned_user_id','leads.lead_provider','leads.lead_type_status','leads.created_at','leads.updated_at','leads.chat_filter','agents.first_name as assign_first_name','agents.last_name as assign_last_name','leads.contact as leadnumber','lead_general_info.work_contact as workNumber','leads.email','leads.lead_provider','leads.lead_status','leads.classification','leads.address','leads.city','leads.state','leads.zip');
                            }])->select('lead_logs.record_sid','lead_logs.status','lead_logs.lead_id','lead_logs.created_at','leads.id as leadid','leads.lead_provider','leads.sender_first_name','leads.sender_last_name','leads.lead_status','leads.contact as leadnumber','company_info.name as companyname','leads.admin_email')
                            ->leftjoin('leads','leads.id','lead_logs.lead_id')
                            ->leftjoin('users','leads.admin_email','users.email')
                            ->leftjoin('company_info','company_info.user_id','users.id')
                            ->where('leads.assigned_user_id',$user->id)
                            ->orderby('lead_logs.created_at','desc')
                            ->get();

            $count = Leadlog::select()->leftjoin('leads','leads.id','lead_logs.lead_id')->where('leads.assigned_user_id',$user->id)->count('*');
            
        }
            return $this->sendResponse([
                'phone-call'=> $log,
                'count'=> $count,
            ],'archive-chat');
        }

    public function getStatusCalls(Request $request)
    {
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();

        $log = null;
        $count = null;

        if($user->usertype_id == 2){

            if($request->assign_agent == "0")
            {
                $log = Leadlog::select('lead_logs.record_sid','lead_logs.status','lead_logs.lead_id','lead_logs.created_at','leads.id as leadid','leads.lead_provider','leads.sender_first_name','leads.sender_last_name','leads.lead_status')
                    ->leftjoin('leads','leads.id','lead_logs.lead_id')
                    ->where('leads.admin_email',$user->email)
                    ->orderby('lead_logs.created_at','desc')
                    ->get();

                $count = DB::table('lead_logs')->select()->leftjoin('leads','leads.id','lead_logs.lead_id')->where('leads.admin_email',$user->email)->count('*');
            }
            else
            {
                $log = Leadlog::select('lead_logs.record_sid','lead_logs.status','lead_logs.lead_id','lead_logs.created_at','leads.id as leadid','leads.lead_provider','leads.sender_first_name','leads.sender_last_name','leads.lead_status')
                    ->leftjoin('leads','leads.id','lead_logs.lead_id')
                    ->where('leads.admin_email',$user->email)
                    ->where('lead_logs.status',$request->assign_agent)
                    ->orderby('lead_logs.created_at','desc')
                    ->get();

                $count = Leadlog::select()->leftjoin('leads','leads.id','lead_logs.lead_id')->where('lead_logs.status',$request->assign_agent)->where('leads.admin_email',$user->email)->count('*');
            }
        }
        elseif($user->usertype_id == 4){

            if($request->assign_agent == "0")
            {
                $log = Leadlog::select('lead_logs.record_sid','lead_logs.status','lead_logs.lead_id','lead_logs.created_at','leads.id as leadid','leads.lead_provider','leads.sender_first_name','leads.sender_last_name','leads.lead_status')
                    ->leftjoin('leads','leads.id','lead_logs.lead_id')
                    ->where('leads.assigned_user_id',$user->id)
                    ->orderby('lead_logs.created_at','desc')
                    ->get();

                $count = Leadlog::select()
                    ->leftjoin('leads','leads.id','lead_logs.lead_id')->where('leads.admin_email',$user->email)->count('*');
            }
            else
            {
                $log = Leadlog::select('lead_logs.record_sid','lead_logs.status','lead_logs.lead_id','lead_logs.created_at','leads.id as leadid','leads.lead_provider','leads.sender_first_name','leads.sender_last_name','leads.lead_status')
                    ->leftjoin('leads','leads.id','lead_logs.lead_id')
                    ->where('leads.assigned_user_id',$user->id)
                    ->where('lead_logs.status',$request->assign_agent)
                    ->orderby('lead_logs.created_at','desc')
                    ->get();

                $count = Leadlog::select()->leftjoin('leads','leads.id','lead_logs.lead_id')->where('lead_logs.status',$request->assign_agent)->where('leads.assigned_user_id',$user->id)->count('*');
            }

        }

        return $this->sendResponse([
            'phone-call'=> $log,
            'count'=> $count,
        ],'archive-chat');

    }

}