<?php

namespace App\Http\Controllers\Api\Mailgun;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use App\Traits\FirebaseTrait;
use App\Traits\PushNotificationTrait;
use Log;

class EmailController extends Controller
{
    public function getEmailResponse(Request $request){
        
        $data = $request->all();//,$data['Date']
        Log::info($data);
        $dealer = DB::table('company_info')->where('email_activated','yes')->where('suite',$data['recipient'])->first(['user_id','suite','password']);
        
        $emailData = [
            'body_plain' => $data['body-plain'],
            'to' => $data['recipient'],
            'subject' => $data['Subject'],
        ];
        if($request->has("Sender")){
            $from = $request->Sender;
        }
        else{
            $from = $request->sender;
        }
        
        if($dealer != null)
        {
            $admin_id = $dealer->user_id;
            $firebaseNoti = FirebaseTrait::initFirebase();
            $firebaseNoti['firebase']->getReference($firebaseNoti['production'].'/notifications')
            ->push([
                'admin_id' => $admin_id,
                'lead_id' => 0,
                'notification_message' => 'You received a new email',
                'type' => 'email',
                'status' => 'new',
                'seen' => 'no',
                'ninja_id' => 0
            ]);
            
            $user_ids = [$admin_id];
            $title = 'Received a new email';
            $message =  $data['Subject'];
            $user =     DB::table('users')->where('id',$dealer->user_id)->first();
            $lead =     DB::table('leads')->select('id')->where('admin_email',$user->email)->where('email',$from)->first();
            $response = PushNotificationTrait::PushNotificationFirebaseSend($user_ids,$title,$message,$lead->id,'email');
            
            $back_date = date("Y-m-d", strtotime("-3 days"));
            $end_date = date("Y-m-d", strtotime("+1 days"));
            $blast_percentage = DB::table('blast_percentage')->where('blast_type', 'email')->where('user_id', $dealer->user_id)->whereDate('created_at', '>=', $back_date)->whereDate('created_at', '<=', $end_date)->get(['id', 'leads_id','respond_id', 'value']);

            if ($blast_percentage->count() > 0) {
                foreach ($blast_percentage as $blast_percentage) {
                    if (str_contains($blast_percentage->leads_id, $lead->id)) {
                        $blast_percentage_array = explode(",", $blast_percentage->leads_id);
                        $index = array_search($lead->id, $blast_percentage_array);
                        if ($index !== FALSE) {
                            unset($blast_percentage_array[$index]);
                        }
                        
                        if ($blast_percentage->respond_id == null || $blast_percentage->respond_id == "") {
                            $messagedId = $lead->id;
                        } else {
                            $messagedId = $blast_percentage->respond_id . ',' . $lead->id;
                        }
                        
                        $blast_percentage_value = implode(",", $blast_percentage_array);

                        DB::table('blast_percentage')->where('id', $blast_percentage->id)->where('user_id', $dealer->user_id)->update(['leads_id' => $blast_percentage_value,'respond_id' => $messagedId, 'value' => $blast_percentage->value + 1]);
                    }
                }
            }
            $userData = DB::table('contact_email')->insert(["sender_id" => $admin_id,
                                                                                "from" => $from,
                                                                                "to" => $emailData['to'],
                                                                                "subject" => $emailData['subject'],
                                                                                "message" => $emailData['body_plain'],
                                                                                "type" => "received",
                                                                                "seen" => "no"
                                                                                ]);
                                                                                
            return response()->json(['success' => true, 'message' => "Email receive successfully!"]);
        }
        else{
            return response()->json(['success' => false, 'message' => "Admin not found!"]);
        }
    }
}
