<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use App\Lead;
use App\User;
use App\LeadAppointment;
use App\Leadblast;
use Permissionallowed;
use App\Blastpercentage;
use App\Companyinfo;
use App\Companyextranumber;
use Illuminate\Support\Facades\Cache;
use DB;


class LeadsourceController extends BaseController{

    public function leadSourceView(){
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();


            if($user->usertype_id == 2){
                // Today Report
                $today_leads = Lead::select('leads.lead_provider')
                    ->selectRaw('count(*) as c, lead_provider')
//                    ->whereDate('created_at', date('Y-m-d'))
                    ->where('leads.admin_email',$user->email)
                    ->groupBy('lead_provider')
                    ->having('c','>=','1')
                    ->orderby('c','desc')
                    ->get();

                // Weekly Report
                $weekly_leads = Lead::select('leads.lead_provider')
                    ->selectRaw('count(*) as c, lead_provider')
//                    ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
//                    ->whereDate('created_at','<=',date('Y-m-d'))
                    ->where('leads.admin_email',$user->email)
                    ->groupBy('lead_provider')
                    ->having('c','>=','1')
                    ->orderby('c','desc')
                    ->get();

                $total_today_lead = Lead::select('leads.lead_provider')
                    ->selectRaw('count(*) as c, lead_provider')
                    ->whereDate('created_at', date('Y-m-d'))
                    ->where('leads.admin_email',$user->email)
//                    ->groupBy('lead_provider')
//                    ->having('c','>=','1')
//                    ->orderby('c','desc')
                    ->count();

                $total_weekly_lead = Lead::select('leads.lead_provider')
                    ->selectRaw('count(*) as c, lead_provider')
                    ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
                    ->whereDate('created_at','<=',date('Y-m-d'))
                    ->where('leads.admin_email',$user->email)
//                    ->groupBy('lead_provider')
//                    ->having('c','>=','1')
//                    ->orderby('c','desc')
                    ->count();

//                dd($total_today_lead);
//                $total_today_lead = DB::select(DB::raw('select SUM(c) TotalCount from (select `leads`.`lead_provider`, count(*) as c from `leads` where DATE(leads.created_at) = CURDATE()  and `leads`.`admin_email` = "'.$user->email.'" group by `lead_provider` having `c` >= 1 order by `c` desc)x;'));
//
//
//
//                $total_weekly_lead = DB::select(DB::raw('select SUM(c) TotalCount from ( select `leads`.`lead_provider`, count(*) as c from `leads` where `leads`.`created_at` >= DATE_SUB(CURDATE(), INTERVAL 7 DAY) and `leads`.`admin_email` = "'.$user->email.'" group by `lead_provider` having `c` >= 1 order by `c` desc )x'));

                return $this->sendResponse([
                    'today_leadsource' => $today_leads,
                    'tota_today_lead' => $total_today_lead,
                    'week_lead_souce' => $weekly_leads,
                    'total_week_lead' => $total_weekly_lead
                ],'today_report');

                }
            elseif($user->usertype_id == 4){
                // Today Report
                $today_leads = Lead::select('leads.lead_provider')
                    ->selectRaw('count(*) as c, lead_provider')
                    ->whereDate('created_at', date('Y-m-d'))
                    ->where('leads.assigned_user_id',$user->id)
                    ->groupBy('lead_provider')
                    ->having('c','>=','1')
                    ->orderby('c','desc')
                    ->get();

                // Weekly Report
                $weekly_leads = Lead::select('leads.lead_provider')
                    ->selectRaw('count(*) as c, lead_provider')
                    ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
                    ->whereDate('created_at','<=',date('Y-m-d'))
                    ->where('leads.assigned_user_id',$user->id)
                    ->groupBy('lead_provider')
                    ->having('c','>=','1')
                    ->orderby('c','desc')
                    ->get();

                $total_today_lead = Lead::select('leads.lead_provider')
                    ->selectRaw('count(*) as c, lead_provider')
                    ->whereDate('created_at', date('Y-m-d'))
                    ->where('leads.assigned_user_id',$user->id)
//                    ->groupBy('lead_provider')
//                    ->having('c','>=','1')
//                    ->orderby('c','desc')
                    ->count();

                $total_weekly_lead = Lead::select('leads.lead_provider')
                    ->selectRaw('count(*) as c, lead_provider')
                    ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
                    ->whereDate('created_at','<=',date('Y-m-d'))
                    ->where('leads.assigned_user_id',$user->id)
//                    ->groupBy('lead_provider')
//                    ->having('c','>=','1')
//                    ->orderby('c','desc')
                    ->count();

//                $total_today_lead = DB::select(DB::raw('select SUM(c) TotalCount from (select `leads`.`lead_provider`, count(*) as c from `leads` where DATE(leads.created_at) = CURDATE()  and `leads`.`assigned_user_id` = "'.session()->get('id').'" group by `lead_provider` having `c` >= 1 order by `c` desc)x;'));
//                $total_weekly_lead = DB::select(DB::raw('select SUM(c) TotalCount from ( select `leads`.`lead_provider`, count(*) as c from `leads` where `leads`.`created_at` >= DATE_SUB(CURDATE(), INTERVAL 7 DAY) and `leads`.`assigned_user_id` = "'.session()->get('id').'" group by `lead_provider` having `c` >= 1 order by `c` desc )x'));

                return $this->sendResponse([
                    'today_leadsource' => $today_leads,
                    'tota_today_lead' => $total_today_lead,
                    'week_lead_souce' => $weekly_leads,
                    'total_week_lead' => $total_weekly_lead
                ],'today_report');

               }


    }

    public function customApi(Request $request)
    {
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
            $startdate = date("Y-m-d", strtotime($request->date_from));
            $enddate = date("Y-m-d", strtotime($request->date_to));

            if($user->usertype_id == 2 ){
                $custom_leads = Lead::select('leads.lead_provider',DB::raw('count(*) as c'))
                    ->whereDate('leads.created_at','>=',$startdate)
                    ->whereDate('leads.created_at','<=',$enddate)
                    ->where('leads.admin_email',$user->email)
                    ->groupBy('lead_provider')
                    ->having('c','>=','1')
                    ->orderby('c','desc')
                    ->get();

                $total_custom_lead = Lead::select('leads.lead_provider')
                    ->selectRaw('count(*) as c, lead_provider')
                    ->whereDate('leads.created_at','>=',$startdate)
                    ->whereDate('leads.created_at','<=',$enddate)
                    ->where('leads.admin_email',$user->email)
//                    ->groupBy('lead_provider')
//                    ->having('c','>=','1')
//                    ->orderby('c','desc')
                    ->count();

                return $this->sendResponse([
                    'custom_leadsource' => $custom_leads,
                    'tota_custom_lead' => $total_custom_lead,
                ],'today_report');

            }
            elseif($user->usertype_id == 4 ){
                $custom_leads = Lead::select('leads.lead_provider',DB::raw('count(*) as c'))
                    ->whereDate('leads.created_at','>=',$startdate)
                    ->whereDate('leads.created_at','<=',$enddate)
                    ->where('leads.assigned_user_id',$user->email)
                    ->groupBy('lead_provider')
                    ->having('c','>=','1')
                    ->orderby('c','desc')
                    ->get();

                $total_custom_lead = Lead::select('leads.lead_provider')
                    ->selectRaw('count(*) as c, lead_provider')
                    ->whereDate('created_at','>=',date('Y-m-d', strtotime('-7 days')))
                    ->whereDate('created_at','<=',date('Y-m-d'))
                    ->where('leads.assigned_user_id',$user->id)
//                    ->groupBy('lead_provider')
//                    ->having('c','>=','1')
//                    ->orderby('c','desc')
                    ->count();

                return $this->sendResponse([
                    'custom_leadsource' => $custom_leads,
                    'tota_custom_lead' => $total_custom_lead,
                ],'today_report');
            }
    }


}