<?php

namespace App\Http\Controllers\Api;

use http\Env\Response;
use Illuminate\Http\Request;
use Hash;
use Validator;
use App\Lead;
use App\User;
use App\Leadchat;
use App\Purchasepakage;
use App\LeadAppointment;
use App\Companyinfo;
use App\Companyextranumber;
use App\NinjaAssign;
use App\Leadreminder;
use App\Privatemessage;
use App\Creditpin;
use App\Quickanswer;
use App\Leadpause;
use App\Leadinventorylist;
use App\Leadinventoryinfo;
use App\Leadlog;
use App\Contactemail;
use App\Leadcontact;
use App\Leademail;
use App\Leadnote;
use App\Blastpercentage;
use App\Uploadblastlibrary;
use Twilio\Rest\Client;
use DB;
use Illuminate\Support\Facades\Cache;

class ChatController extends BaseController{

    public function __construct()
    {
        $this->sid = 'AC95de29915b5c944b51ead3ecc0e97d14';
        $this->auth = '9523723025905ec5198af138cbed61e5';
        $this->telnyx_key = 'KEY017B7E1BA69E11832D81D5112FB47B2F_qwIDBXfobXRLBgoLWxLBNm';
    }

    public function leadstatus(Request $request){

        $update_assign_id = Lead::where('id',$request->leadid)
            ->update(['lead_status' => $request->leadstatus,'updated_at' => date('Y-m-d H:i:s')]);
        if($update_assign_id){

            return response()->json([
                'success' => true,
                'message'=> 'Status changed successfully',
            ],200);
        }
        else{
            return response()->json([
                'success' => false,
                'message'=> 'Something went wrong',
            ],500);
        }
    }

    public function assignUser(Request $request){
        if($request->userid != null){
            $update_assign_id = Lead::where('id',$request->leadid)->update(['status' => $request->status,'assigned_user_id' => $request->userid]);
            if($update_assign_id){
                return response()->json([
                    'success' => true,
                    'message' => 'Assigned status changed successfully!.',
                ],200);
                
            }
            else{
                return response()->json([
                    'success' => false,
                    'message' => 'No agents assign.',
                ],401);
            }
        }
        else{
            return response()->json([
                'success' => false,
                'message' => 'Something went wrong',
            ],401);
            
        }

    }

    public function leadsourcechange(Request $request){

        $update_assign_id = Lead::where('id',$request->leadid)
            ->update(['lead_provider' => $request->leadsource_status,'updated_at' => date('Y-m-d H:i:s')]);

        if($update_assign_id){
            
            return response()->json([
                'success' => true,
                'message'=> 'Leadsource changed successfully',
            ],200);
            
        }
        else{
            return response()->json([
                'success' => false,
                'message'=> 'Something went wrong',
            ],500);
        }
    }

    public function leadclasschange(Request $request){

        $update_class = Lead::where('id',$request->leadid)
            ->update(['classification' => $request->classification,'updated_at' => date('Y-m-d H:i:s')]);
        if($update_class){
            return response()->json([
                'success' => true,
                'message'=> 'class changed successfully',
            ],200);
            
        }
        else{
            return response()->json([
                'success' => false,
                'message'=> 'Something went wrong',
            ],500);
        }
    }

    public function setAppointment(Request $request)
    {

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['id','usertype_id']);

        $user_id = $user->id;

        $arr = [
            "lead_id" => $request->leadid,
            "sender_id"=>$user_id,
            "set_appointment" => $request->setappointment,
            "start_date" => date('Y-m-d H:i:s'),
            "end_date" => date('Y-m-d H:i:s')
        ];

        $final_appointment_update = "";
        $final_appointment_insert = "";
        $check_appointment = LeadAppointment::where('lead_id',$request->leadid)->value('lead_id');

        if($check_appointment != null)
        {

            $final_appointment_update = LeadAppointment::where('lead_id',$request->leadid)->update($arr);
        }
        else
        {

            $final_appointment_insert = LeadAppointment::insert($arr);
        }

        $get_lead = Lead::where('id',$request->leadid)->first(['admin_email','sender_first_name','contact']);
        $get_admin_detail = User::where('email',$get_lead->admin_email)->first('id');

        if($request->robo_permission == 'on')
        {
            $packagePurchased = null;
            if($user->usertype_id == 2)

            {
                $packagePurchased = Purchasepakage::where('remaining_quantity','>',0)->where('user_id',$user->id)->where('package_type','sms')->first('id');
            }
            else if($user->usertype_id == 4)
            {
                $getAdmin = User::where('id',$user->id)->first('parent_user_id');
                $packagePurchased = Purchasepakage::where('remaining_quantity','>',0)->where('user_id',$getAdmin->parent_user_id)->where('package_type','sms')->first('id');
            }

            if($packagePurchased == null)
            {
                return response()->json([
                    'success' => false,
                    'message' => 'You have 0 remaining balance in account!',
                ],200);
                
            }
            else
            {

                $sid    = $this->sid;
                $token  = $this->auth;
                $this->telnyx_key = 'KEY017B7E1BA69E11832D81D5112FB47B2F_qwIDBXfobXRLBgoLWxLBNm';
                $client = new Client( $sid, $token );

                if($get_lead != null){

                    $get_admin_company = Companyinfo::where('user_id',$get_admin_detail->id)->first(['name','address','city','state','zip_code','telnyx_number', 'service_provider','phone_number','msg_service_id']);
                    if($get_admin_company){
                        $appoinment_message = "Hi ".$get_lead->sender_first_name.", Your appointment is set at ".$request->setappointment." with ".$get_admin_company->name." located at ".$get_admin_company->address.", ".$get_admin_company->city.", ".$get_admin_company->state." ".$get_admin_company->zip_code;

                        $check_number = Leadchat::where('admin_id', $get_admin_detail->id)
                            ->where('from',$get_lead->contact)
                            ->orwhere('to',$get_lead->contact)
                            ->first('chat_id');

                        if($check_number != null)
                        {
                            
                            try{
                                $fromNumber = $get_admin_company->phone_number;
                                if ($get_admin_company->service_provider == "Twilio") {
                                    $fromNumber   =   $get_admin_company->phone_number;
                                    $client->messages->create(
                                        $get_lead->contact,
                                        array(
                                            "messagingServiceSid" => $get_admin_company->msg_service_id,
                                            'body' => $appoinment_message
                                        )
                                    );
                                }else{
                                    $fromNumber   =   $get_admin_company->telnyx_number;
                                    Telnyx\Telnyx::setApiKey($this->telnyx_key);

                                    \Telnyx\Message::Create([
                                        'from' => $get_admin_company->telnyx_number,
                                        'to' => $get_lead->contact,
                                        'text' => $appoinment_message
                                    ]);
                                }

                                Lead::where('id',$request->leadid)->update(['lead_status' => 'Appointment-Set','updated_at' => date('Y-m-d H:i:s')]);
                                
                                $send = [
                                    'admin_id' => $get_admin_detail->id,
                                    'lead_id' => $request->leadid,
                                    'from' => $fromNumber,
                                    'to' => $get_lead->contact,
                                    'message' => $appoinment_message,
                                    'chat_id' =>$check_number->chat_id,
                                    'type' => 'sent',
                                    'sender_id' => $user->id,
                                ];    
                                
                                $message_insert = Leadchat::insert($send);
                                
                            }catch(\Twilio\Exceptions\RestException $e){
                                Lead::where('id',$request->leadid)->update(['lead_status' => 'Wrong Number']);
                                return response()->json([
                                    'success' => false,
                                    'message' => 'Wrong Number',
                                ],201);
                            }


                            if($final_appointment_update){
                                return response()->json([
                                    'success' => true,
                                    'message' => 'Appointment Rescheduled',
                                ],200);
                                

                            }
                            elseif($final_appointment_insert){
                                return response()->json([
                                    'success' => true,
                                    'message' => 'Appointment Set',
                                ],200);
                                
                            }
                            

                        }
                        else{
                            
                            try{
                                $fromNumber = $get_admin_company->phone_number;
                                if ($get_admin_company->service_provider == "Twilio") {
                                    $fromNumber   =   $get_admin_company->phone_number;
                                    $client->messages->create(
                                        $get_lead->contact,
                                        array(
                                            "messagingServiceSid" => $get_admin_company->msg_service_id,
                                            'body' => $appoinment_message
                                        )
                                    );
                                
                                }else{
                                    $fromNumber   =   $get_admin_company->telnyx_number;
                                    Telnyx\Telnyx::setApiKey($this->telnyx_key);

                                    \Telnyx\Message::Create([
                                        'from' => $get_admin_company->telnyx_number,
                                        'to' => $get_lead->contact,
                                        'text' => $appoinment_message
                                    ]);
                                }
                                Lead::where('id',$request->leadid)->update(['lead_status' => 'Appointment-Set','updated_at' => date('Y-m-d H:i:s')]);
                                
                                $get_max_value = Leadchat::max('chat_id');

                                $count = $get_max_value + 1;
                                $send = [
                                    'admin_id' => $get_admin_detail->id,
                                    'lead_id' => $request->leadid,
                                    'from' => $fromNumber,
                                    'to' => $get_lead->contact,
                                    'message' => $appoinment_message,
                                    'chat_id' =>$count,
                                ];
    
                                $message_insert = Leadchat::insert($send);
                            }catch(\Twilio\Exceptions\RestException $e){
                                Lead::where('id',$request->leadid)->update(['lead_status' => 'Wrong Number']);
                                return response()->json([
                                    'success' => false,
                                    'message' => 'Wrong Number',
                                ],401);
                            }
                            

                            if($final_appointment_update){
                                return response()->json([
                                    'success' => true,
                                    'message' => 'Appointment Rescheduled',
                                ],200);

                            }
                            elseif($final_appointment_insert){
                                return response()->json([
                                    'success' => true,
                                    'message' => 'Appointment Set',
                                ],200);
                                
                            }

                            
                        }
                    }
                }
            }
        }
        else
        {

            $update_assign_id = Lead::where('id',$request->leadid)
                ->update(['lead_status' => 'Appointment-Set','updated_at' => date('Y-m-d H:i:s')]);


            if($update_assign_id && $final_appointment_update){
                return response()->json([
                    'success' => true,
                    'message' => 'Appointment Rescheduled',
                ],200);
            

            }
            elseif($update_assign_id && $final_appointment_insert){
                return response()->json([
                    'success' => true,
                    'message' => 'Appointment Set',
                ],200);
                
            }
        }

    }


    public function setreminder(Request $request){
        $validate = $request->validate([
            "reminder_lead_id" => 'required',
            "setReminder" => 'required',
            "reminderNotes" => 'required',
        ]);

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first('id');

        $user_id = $user->id;

        // $date = new \DateTime($request->setReminder);
        // return $timestamp = $date->getTimestamp();

        $setReminder = date("Y-m-d H:i:s", strtotime($request->setReminder));
            // return\Carbon\Carbon::parse($request->setReminder)->toDateTimeString();
        $data = [
            'sender_id' => $user_id,
            'lead_id' => $request->reminder_lead_id,
            'set_reminder' => $setReminder,
            'reminder_notes' => $request->reminderNotes,
            'status' => 'no',
        ];
        $reminder = Leadreminder::insertGetId($data);
        if($reminder){
            
            return response()->json([
                'success'=>true,
                'message'=> 'Reminder Set Successfully!',
            ],200);
        }
        else{

            return response()->json([
                'success'=>false,
                'message'=> 'Something went wrong!',
            ],401);
        }
    }

    public function messageSend(Request $request){


        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first(['id','usertype_id','parent_user_id']);


        if (auth()->user()->usertype_id == 2){
            if (auth()->user()->email != $request->adminemail)
            {
                return response()->json([
                   'success'=> false,
                   'message' => 'invalid Admin',
                ],401);
                
            }
        }
        elseif(auth()->user()->usertype_id == 4){
            $check_admin_current = User::where('id',$user->parent_user_id)->first('email');
            if ($check_admin_current->email != $request->adminemail)
            {
                return response()->json([
                   'success'=> false,
                   'message' => 'invalid Admin',
                ],401);
                
            }
        }



        $sid    = 'AC95de29915b5c944b51ead3ecc0e97d14';
        $token  = '9523723025905ec5198af138cbed61e5';
        $client = new Client( $sid, $token );

            $check_admin = Companyinfo::select('company_info.*','users.email as admin','users.id as private_id')
                                        ->leftjoin('users','company_info.user_id','users.id')
                                        ->where('users.email',$request->adminemail)
                                        ->first();

            if($check_admin != null){

                $get_admin_id = User::where('email',$request->adminemail)->first(['id']);
                $get_lead_id = Lead::select('company','id')->where('contact',$request->leadnumber)->where('admin_email',$request->adminemail)->where('id',$request->lead_id)->first();

               if ($get_lead_id != null){
                    $check_number = Leadchat::where(function($query) use ($request) {
                       $query->where('from',$request->leadnumber)
                           ->orwhere('to',$request->leadnumber);
                    })
                   ->where('admin_id',$get_admin_id->id)->where('lead_id',$request->lead_id)
                   ->first('chat_id');

                   $message_length = 1;
                   if(strlen($request->leadmessage) < 161) { $message_length = 1; }
                   else if(strlen($request->leadmessage) > 160 && strlen($request->leadmessage) < 321) { $message_length = 2; }
                   else if(strlen($request->leadmessage) > 320 && strlen($request->leadmessage) < 481) { $message_length = 3; }
                   else if(strlen($request->leadmessage) > 480 && strlen($request->leadmessage) < 641) { $message_length = 4; }
                   else if(strlen($request->leadmessage) > 640 && strlen($request->leadmessage) < 801) { $message_length = 5; }
                   else if(strlen($request->leadmessage) > 800 && strlen($request->leadmessage) < 961) { $message_length = 6; }
                   else if(strlen($request->leadmessage) > 960 && strlen($request->leadmessage) < 1121) { $message_length = 7; }
                   else { $message_length = 8; }

                   if($check_number != null)
                   {
                       $ninja = 'no';
                       if($request->chattype == 0){
                           try{
                               $get_admin_ninjas = Cache::rememberForever('get_admin_ninjas'.$get_admin_id->id,function () use($get_admin_id)  {
                                   $admins = NinjaAssign::where('user_id',$get_admin_id->id)->where('assign_status','yes')->get(['ninja_id']);
                                   if($admins) {
                                       return implode('_',$admins->pluck('ninja_id')->toArray());
                                   }else{
                                       return false;
                                   }
                               });
                               if($get_admin_ninjas == null)
                               {
                                   $get_admin_ninjas = auth()->user()->id;
                               }
                               

                               $fromNumber   =   $check_admin->phone_number;

                               
                               $send = [
                                   'admin_id' => $get_admin_id->id,
                                   'lead_id' => $get_lead_id->id,
                                   'company' => $get_lead_id->company,
                                   'from' => $fromNumber,
                                   'to' => $request->leadnumber,
                                   'message' => $request->leadmessage,
                                   'internal' => $request->chattype,
                                   'chat_id' =>$check_number->chat_id,
                                   'type' => 'sent',
                                   'private_chat' => $ninja,
                                   'private_id' => $check_admin->private_id,
                                   'sender_id' => $user->id,
                                   'message_length' => $message_length
                               ];
                               
                               $if_sms = "false";
                               if ($request->mms_attachments != null){
                                   $send['mms_attachments'] = $request->mms_attachments;
                                   $data = [
                                       'user_id' => $get_admin_id->id,
                                       'file' => $request->mms_attachments,
                                       'type' => 'mms'
                                   ];
                                   Uploadblastlibrary::insert($data);
                                   $if_sms = "true";
                                  
                                   
                                  //mms
                                    $client->messages->create(
                                        $request->leadnumber,
                                        array(
                                            "messagingServiceSid" => $check_admin->msg_service_id,
                                            'body' => $request->leadmessage,
                                            "mediaUrl" => [$request->mms_attachments]
                                        )
                                    );
                               }
                                
                               if ($request->leadmessage != null && $if_sms == "false")
                               {
                                  //   sms
                                    
                                    $client->messages->create(
                                        $request->leadnumber,
                                        array(
                                            "messagingServiceSid" => $check_admin->msg_service_id,
                                            'body' => $request->leadmessage
                                        )
                                    );
                                    
                               }
                               
                               $message_insert = Leadchat::insert($send);

                               $find_lead = Lead::where('contact',$request->leadnumber)->first();

                               if($user->usertype_id == 4){
                                   $data = [
                                       'chat_filter' => 0,
                                       'assigned_user_id' => $user->id,
                                       'updated_at' => date('Y-m-d H:i:s'),
                                   ];
                               }else
                               {
                                   $data = [
                                       'chat_filter' => 0,
                                       'updated_at' => date('Y-m-d H:i:s'),
                                   ];
                               }

                               Lead::where('id',$find_lead->id)->update($data);


                                return response()->json([
                                   'success'=> true,
                                   'message' => 'Message sent successfully',
                                ],200);
                               
                           } catch(\Twilio\Exceptions\RestException $e)
                           {
                               Lead::where('id',$request->lead_id)->update(['lead_status' => "Wrong Number"]);
                               
                                return response()->json([
                                   'message' => 'wrong number',
                                   'success'=>false
                                ],404);
                               
                           }
                       }
                   }
                   else{
                       $get_max_value = Leadchat::max('chat_id');

                       $count = $get_max_value + 1;
                       $ninja = 'no';
                       if($request->chattype == 0){
                           try{
                               
                               if($get_admin_ninjas == null)
                               {
                                   $get_admin_ninjas = auth()->user()->id;
                               }
                               

                               $fromNumber   =   $check_admin->phone_number;

                               $send = [
                                   'admin_id' => $get_admin_id->id,
                                   'lead_id' => $get_lead_id->id,
                                   'company' => $get_lead_id->company,
                                   'from' => $fromNumber,
                                   'to' => $request->leadnumber,
                                   'message' => $request->leadmessage,
                                   'internal' => $request->chattype,
                                   'chat_id' =>$count,
                                   'type' => 'sent',
                                   'private_chat' => $ninja,
                                   'private_id' => $check_admin->private_id,
                                   'sender_id' => $user->id,
                                   'message_length' => $message_length
                               ];
                               
                               $if_sms = "false";
                               if ($request->mms_attachments != null){
                                   $send['mms_attachments'] = $request->mms_attachments;
                                   $if_sms = "true";
                                   
                                    //   mms
                                    $client->messages->create(
                                        $request->leadnumber,
                                        array(
                                            "messagingServiceSid" => $check_admin->msg_service_id,
                                            'body' => $request->leadmessage,
                                            "mediaUrl" => [$request->mms_attachments]
                                        )
                                    );
                                    
                                    
                               }
                               
                               if ($request->leadmessage != null && $if_sms == "false")
                               {
                                    //   sms
                                    
                                        $client->messages->create(
                                            $request->leadnumber,
                                            array(
                                                "messagingServiceSid" => $check_admin->msg_service_id,
                                                'body' => $request->leadmessage
                                            )
                                        );
                                    
                               }
                               
                               $message_insert = Leadchat::insert($send);


                               $find_lead = Lead::where('contact',$request->leadnumber)->first();

                               if($user->usertype_id == 4){
                                   $data = [
                                       'chat_filter' => 0,
                                       'assigned_user_id' => $user->id,
                                       'updated_at' => date('Y-m-d H:i:s'),
                                   ];
                               }else
                               {
                                   $data = [
                                       'chat_filter' => 0,
                                       'updated_at' => date('Y-m-d H:i:s'),
                                   ];
                               }

                               Lead::where('id',$find_lead->id)
                                   ->update($data);
                               
                                return response()->json([
                                   'success'=> true,
                                   'message' => 'Message sent successfully',
                                ],200);

                           } catch(\Twilio\Exceptions\RestException $e)
                           {

                                Lead::where('id',$request->lead_id)->update(['lead_status' => "Wrong Number"]);
                                return response()->json([
                                   'message' => 'wrong number',
                                   'success'=>false
                                ],404);
                               
                           }
                       }
                   }
               }
               else{
                    return response()->json([
                       'message' => 'invalid number',
                       'success'=>false
                    ],404);
                    
               }

            }
            else{
                 return response()->json([
                   'message' => 'invalid number',
                   'success'=>false
                ],404);
            }
        }

    public function creditpinApi(Request $request){
        

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first('id');

        $pin = mt_rand(1000,9999);

        Creditpin::where('contact',$request->contact)->delete();
        $credit_pin = [
            'contact' => $request->contact,
            'code' => $pin,
            'lead_id' => $request->leadid,
            'sender_id'=>$user->id
        ];
        $insert = Creditpin::insert($credit_pin);
        if($insert){
            $shortener = app('url.shortener');
            $shortUrl = $shortener->driver('is_gd')->shorten('https://credit.text10x.ai/credit/credit-pin/');
            $shortUrl .= " Your PIN code is:".$pin;

            return $this->sendResponse([
                'creditapp-Shorturl'=> $shortUrl,
            ],'creditapp-url');
        }
    }

    public function apraiseVechilelink(Request $request){
        $lead_id = $request->leadid;
        $shortener = app('url.shortener');
        $shortUrl = $shortener->driver('is_gd')->shorten('http://vehicle.text10x.ai/appraise-vehicle/appraise.php?lead_id='.$lead_id);

        return $this->sendResponse([
            'appraise-shorturl'=> $shortUrl,
        ],'Appraise-url');
    }

    public function chatImageFile(Request $request){
        $shortener = app('url.shortener');
        $image = $request->file('file');

        if($image != null){
            $new_name = rand() . '.' . $image->getClientOriginalExtension();
            $imagepath = $image->move('./asset/chat-assets/images', $new_name);
            $path = $new_name;
            $completePath = url('/').'/asset/chat-assets/images/'.$path;
            $shortUrl = $shortener->driver('is_gd')->shorten($completePath);

            $adminId = Companyinfo::where('name',$request->company_name)->first(['user_id']);

            // flushing cache for text chats
            $get_admin_ninjas = Cache::rememberForever('get_admin_ninjas'.$adminId->user_id,function () use($adminId)  {
                $admins = NinjaAssign::where('user_id',$adminId->user_id)->where('assign_status','yes')->get(['ninja_id']);
                if($admins) {
                    return implode('_',$admins->pluck('ninja_id')->toArray());
                }else{
                    return false;
                }
            });


            Cache::forget('today_ninja_text'.$get_admin_ninjas);
            Cache::forget('today_ninja_text'.$adminId->user_id);

            Cache::forget('total_agent_text'.$get_admin_ninjas);


            Cache::forget('total_text'.$get_admin_ninjas);
            Cache::forget('total_text'.$adminId->user_id);


            return $this->sendResponse([
                'image-url'=> $shortUrl,
            ],'image-url');
        }
        else{
            return $this->sendResponse([
                'image-url'=> 'No Image found',
            ],'image-url');
        }



    }

    public function chatVideoFile(Request $request){


        $shortener = app('url.shortener');
        $image = $request->file('file');
        $new_name = rand() . '.' . $image->getClientOriginalExtension();
        $imagepath = $image->move('./asset/chat-assets/video', $new_name);
        $path = $new_name;
        $completePath = url('/').'/asset/chat-assets/video/'.$path;
        $shortUrl = $shortener->driver('is_gd')->shorten($completePath);

        $adminId = Companyinfo::where('name',$request->company_name)->first(['user_id']);

        // flushing cache for text chats
        $get_admin_ninjas = Cache::rememberForever('get_admin_ninjas'.$adminId->user_id,function () use($adminId)  {
            $admins = NinjaAssign::where('user_id',$adminId->user_id)->where('assign_status','yes')->get(['ninja_id']);
            if($admins) {
                return implode('_',$admins->pluck('ninja_id')->toArray());
            }else{
                return false;
            }
        });


        Cache::forget('today_ninja_text'.$get_admin_ninjas);
        Cache::forget('today_ninja_text'.$adminId->user_id);

        Cache::forget('total_agent_text'.$get_admin_ninjas);


        Cache::forget('total_text'.$get_admin_ninjas);
        Cache::forget('total_text'.$adminId->user_id);

        return $this->sendResponse([
            'video-url'=> $shortUrl,
        ],'video-url');
    }


    public function getMmsLibrary(Request $request)
    {

        $admin_email = $request->adminemail;

        $admin_id = DB::table('users')->where('email',$admin_email)->value('id');

        $upload_blast_library = Uploadblastlibrary::where('user_id',$admin_id->id)->where('type','mms')->get(['file']);
            
        return $this->sendResponse([
            'list'=> $upload_blast_library,
        ],'Push message');

    }

    public function archiveChatApi(Request $request){
        if($request->leadid != '' || $request->leadid != null || $request->archiveid != '' || $request->archiveid != null){
            $archive = Lead::where('id',$request->leadid)
                ->update(['archive_status'=> $request->archiveid]);
            if($archive){
                return  response()->json([
                            'success' => true,
                            'message' => 'Status updated successfully',
                        ],200);
            }else{
                return response()->json([
                            'success' => false,
                            'message' => 'Something went wrong',
                        ],201);
            }
        }else{
            return response()->json([
                        'success' => false,
                        'message' => 'Something is missing',
                    ],201);
        }

    }

    public function quickAnswerAdd(Request $request){

        $validate = $request->validate([
            'answer' => 'required',
        ]);

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first('id');

        $data = [
            'answer' => $request->answer,
            'user_id' => $user->id
        ];
        $recordid = Quickanswer::insertGetId($data);

        if($recordid) {
            return response()->json([
                'success' => true,
                'message'=> 'Push message added successfully',
            ],200);
           
        }
        else{
    
            return response()->json([
                'success' => false,
                'message'=> 'Something went wrong',
            ],500);
        }

    }

    public function getAnswers(){

        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first('id');

        $get_answer = Quickanswer::where('user_id',$user->id)->orderby('id','desc')->get();

        if($get_answer){
            return $this->sendResponse([
                'push_messages'=> $get_answer,
            ],'Push message');
        }
        else{
            return $this->sendResponse([
                'push_messages'=> 'No Push Messages',
            ],'no push message');
        }


    }

    public function quickAnswerRemoveApi(Request $request){

        $delet = Quickanswer::where('id',$request->answerid)->delete();

        if($delet){
            return response()->json([
                'success' => true,
                'message'=> 'Remove successfully',
            ],200);
            
        }
        else{
             return response()->json([
                'success' => false,
                'message'=> 'Something went wrong',
            ],500);
            
        }

    }

    public function getVinInfo(Request $request){

        $adminemail = $request->adminemail;
        $user = User::where('email',$adminemail)->first(['id']);
        $userId = $user->id;

        $vin = $request->vin;
        $vinInfo = Leadinventorylist::where('user_id',$userId)->where('vin',$vin)->first();

        if($vinInfo!=null)
        {
            return $this->sendResponse([
                'vin_info'=> $vinInfo,
            ],'inventory-list');
        }
        else{
            return $this->sendResponse([
                'vin_info'=> 'Something went wrong',
            ],'inventory-list');
        }
    }

    public function phoneLog(Request $request){

        $get_log = Leadlog::select('lead_logs.status','lead_logs.lead_id','lead_logs.created_at','leads.id as leadid','leads.lead_provider','leads.admin_email','leads.sender_first_name','leads.sender_last_name','leads.lead_status')
            ->leftjoin('leads','leads.id','lead_logs.lead_id')
            ->where('lead_logs.lead_id',$request->leadid)
            ->orderby('lead_logs.id','desc')
            ->get();
        if($get_log->count() > 0){
            return $this->sendResponse([
                'phone_log'=> $get_log,
            ],'phone-log');
        }
        else{
            return $this->sendResponse([
                'phone_log'=> 'No phone log',
            ],'phone-log');
        }

    }

    public function leadchatlog(Request $request){

        $lead = Lead::where('id',$request->id)->first();
        $get_admin = User::where('email',$lead->admin_email)->first('id');

        $chat_logs = Leadchat::select('lead_chat.id','lead_chat.lead_id','lead_chat.from','lead_chat.to','lead_chat.message','lead_chat.type','lead_chat.created_at')
            ->where('mms_attachments',null)->where('ringless_voicemail',null)
            ->where('admin_id',$get_admin->id)
            ->where('from',$lead->contact)
            ->orwhere('to',$lead->contact)
            ->get();

        if($chat_logs->count()){
            return $this->sendResponse([
                'lead_chat_log'=> $chat_logs,
            ],'lead-chat-log');
        }
        else{
            return $this->sendResponse([
                'lead_chat_log'=> 'No Chat Log',
            ],'lead-chat-log');
        }
    }

    public function leademailog(Request $request){

        $get_log =Contactemail::where('to',$request->email)->orwhere('from',$request->email)->orderBy('id','desc')->get();

        if($get_log->count()){
            return $this->sendResponse([
                'email_log'=> $get_log,
            ],'Email-log');
        }
        else{
            return $this->sendResponse([
                'email_log'=> 'No Email log',
            ],'Email-log');
        }

    }
    
    public function ringlessVmlogview(Request $request){

        $lead = Lead::where('id',$request->id)->first();
        $get_admin = User::where('email',$lead->admin_email)->first();
        $chat_logs = Leadchat::where('admin_id',$get_admin->id)->where('mms_attachments',null)->where('ringless_voicemail','!=',null)->where('to',$lead->contact)->get();

        if($chat_logs->count()){
            return $this->sendResponse([
                'rvm_log'=> $chat_logs,
            ],'rvm-log');
        }
        else{
            return $this->sendResponse([
                'rvm_log'=> 'No Rvm log',
            ],'rvm-log');
        }

    }

    public function ringlessVoiceMailer(Request $request)
    {
//        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first();
        $image = $request->file('file');

        $new_name = rand() . '.' . 'wav';
        $imagepath = $image->move('./asset/voicemail/audio/', $new_name);
        $path = $new_name;
        $completePath = url('/') . '/asset/voicemail/audio/' . $path;
        
        $audio_url = $completePath;
        $lead_id = $request->audio_lead_id;
        $admin_email = $request->audio_admin_email;
        $from_number = $request->audio_from_number;

            $getLead = Lead::where('admin_email',$admin_email)->where('id',$lead_id)->first(['contact']);
            $getAdmin = User::where('email',$admin_email)->first(['id']);
            $getCompany = Companyinfo::where('user_id',$getAdmin->id)->first(['name','phone_number']);
        $data = [
            'user_id' => $getAdmin->id,
            'file' => $completePath,
            'type' => 'rvm'
        ];
        Uploadblastlibrary::insert($data);
        $message_insert = '';
        try{
            header('Content-type: application/json');

            $url = 'https://api.dropcowboy.com/v1/rvm';

            $data = array("team_id" => 'ab6bc9a0-083c-45b6-a14e-bff345b8e97f',
                "secret" => 'b9133b1c-b12a-4ca5-ac27-106538b1a426',
                "audio_url" => $audio_url,
                "audio_type" => 'wav',
                "phone_number" => $getLead->contact,
                "caller_id" => $getCompany->phone_number,
                "foreign_id" => $lead_id);

            $data_string = json_encode($data);

            $ch = curl_init($url);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);


            curl_setopt_array($ch, array(
                CURLOPT_POST => true,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POSTFIELDS => $data_string,
                CURLOPT_HEADER => true,
                CURLOPT_HTTPHEADER => array('Content-Type:application/json', 'Content-Length: ' . strlen($data_string))
            ));

            $result = curl_exec($ch);
            curl_close($ch);
            $result = json_decode($result,true);
            // return $result;
            $check_number = Leadchat::where(function($query) use ($getLead) {
                $query->where('from',$getLead->contact)
                    ->orwhere('to',$getLead->contact);
            })
                ->where('admin_id',$getAdmin->id)->where('lead_id',$lead_id)
                ->first('chat_id');
          
            
            // if($result != null){
                if($check_number != null)
                {
                    $send = [
                        'admin_id' => $getAdmin->id,
                        'lead_id' => $lead_id,
                        'from' => $getCompany->phone_number,
                        'to' => $getLead->contact,
                        'message' => "You have a new voicemail message from ".$getCompany->name,
                        'ringless_voicemail' => $audio_url,
                        'chat_id' =>$check_number->chat_id,
                        'type' => 'sent',
                        'sender_id' => auth()->user()->id,
                    ];
    
                    $message_insert = Leadchat::insert($send);
                }
                else
                {
                    $get_max_value = Leadchat::max('chat_id');
    
                    $count = $get_max_value + 1;
    
                    $send = [
                        'admin_id' => $getAdmin->id,
                        'lead_id' => $lead_id,
                        'from' => $from_number,
                        'to' => $getLead->contact,
                        'message' => "You have a new voicemail message from ".$getCompany->name,
                        'ringless_voicemail' => $audio_url,
                        'chat_id' =>$check_number->chat_id,
                        'type' => 'sent',
                        'sender_id' => auth()->user()->id,
                    ];
    
                    $message_insert = Leadchat::insert($send);
                }
                
                if($message_insert){
                    return response()->json([
                        'success' => true,
                        'message' => 'Send Successfully',
                    ],200);
                    
                    
                }
                else{
                    return response()->json([
                        'success' => false,
                        'message' => 'Something went wrong',
                    ],201);
                    
                }
            // }
        }catch(\Twilio\Exceptions\RestException $e){
            Lead::where('id',$lead_id)->update(['lead_status' => 'Wrong Number']);
            return response()->json([
                'success' => false,
                'message' => 'Wrong Number',
            ],201);
        }

        if($message_insert){
            return response()->json([
                'success' => true,
                'message' => 'Send Successfully',
            ],200);
            
            
        }
        else{
            return response()->json([
                'success' => false,
                'message' => 'Something went wrong',
            ],201);
            
        }
    }

    public function leadstatustype(Request $request){
        if($request->status == '0'){
            $update_assign_id = Lead::where('id',$request->leadid)
                ->update(['lead_type_status' => 0]);
            if($update_assign_id){
                
                return response()->json([
                    'success' => true,
                    'message' => 'Lead type removed successfully!'
                ],200);
                
            }
            else{
                return response()->json([
                    'success' => false,
                    'message' => 'Something went wrong'
                ],500);
                
            }
        }
        else{
            $update_assign_id = Lead::where('id',$request->leadid)
                ->update(['lead_type_status' => $request->status]);

            if($update_assign_id){
                return response()->json([
                    'success' => true,
                    'message' => 'Lead type changed successfully!'
                ],200);
            }
            else{
                return response()->json([
                    'success' => false,
                    'message' => 'Something went wrong'
                ],500);
            }
        }
    }

    public function updateLeadinfo(Request $request){

        $data = [
            'sender_first_name' => $request->first_name,
            'sender_last_name' => $request->last_name,
            'email' => $request->lead_email,
            'address' => $request->adress,
            'city'=>$request->city,
            'state'=>$request->state,
            'zip'=>$request->zip_code,

        ];
        if ($request->id != null){

            $update = Lead::where('id',$request->id)->update($data);

            return $this->sendResponse([
                'message'=>'Lead info updated'
            ],'Lead-info-update');

        }
        else{

            return $this->sendResponse([
                'message'=>'something went wrong'
            ],'Lead-info');
        }
    }

    public function Addnum(Request $request){



        $request->lead_id;
        $request->add_phone_num =  substr_replace($request->add_phone_num, "+", 0, 0);

//        dd($request->add_phone_num);

        $phone_number= $request->add_phone_num;

        $validator = Validator::make($request->all(), [
            "add_phone_num" => 'required|min:11|max:17',
            "lead_id" => 'required',
        ]);
        if ($validator->fails()) {

            return $this->sendResponse([
                'numberCount' => 2,
                'message' => "Invalid Phone Number"
            ],'add-num');

        }
        $check_phone = Leadcontact::where('lead_id',$request->lead_id)->where('contact_number',$phone_number)->first();
        if(!empty($check_phone)){

            return $this->sendResponse([
                'numberCount' => 2,
                'message' => "Phone Number already Exist"
            ],'add-num');
        }

        $data = [
            'lead_id' => $request->lead_id,
            'contact_number' => $phone_number,
        ];
        $all_numbers = Leadcontact::where('lead_id',$request->lead_id)->get();
        if($all_numbers->count() < 2){

            $contact = Leadcontact::insertGetId($data);

            $primary_number = Lead::where('id', $request->lead_id)->value('contact');
            $all_number = Leadcontact::where('lead_id', $request->lead_id)->get();


            return $this->sendResponse([
                'message' => "New number added Successfully!",
                'marking_primary' => $primary_number,
                'number' => $phone_number,
                'leadId' => $contact,
                'numberCount' => $all_numbers->count(),
                'all_number' => $all_number,
            ],'add-num');


        }
        else{
            return $this->sendResponse([
                'numberCount' => 2,
                'message' => "You can only add 3 numbers!"
            ],'add-num');
        }
    }

    public function updateNumber(Request $request){

       $num =  substr_replace($request->add_phone_n, "+", 0, 0);

        $phone_number= $num;

        $validator = Validator::make($request->all(), [
            "add_phone_n" => 'required|min:11|max:17',
            "id" => 'required',
            "lead_type" => 'required',
        ]);

        if ($validator->fails()) {

            return $this->sendResponse([
                'numberCount' => 2,
                'message' => "Invalid Phone Number"
            ],'update-num');
        }

        if($request->lead_type == 2)
        {
            $data = [
                'contact_number' => $phone_number,
            ];

            $contact = Leadcontact::where('id', $request->id)->update($data);
            $lead_id_get = Leadcontact::where('id', $request->id)->value('lead_id');
            $all_number = Leadcontact::where('lead_id', $lead_id_get)->get();
            $primary_number = Lead::where('id', $lead_id_get)->value('contact');

            if($contact){

                $message  = "ok";
            }
            else{
                $message  = "false";
            }

            return $this->sendResponse([
                'message' => $message,
                'marking_primary' => $primary_number,
                'all_number' => $all_number,
                'number' => $request->add_phone_n,
            ],'add-num');
        }
    }

    public function markprimary(Request $request){



        $marking_primary =  substr_replace($request->marking_primary, "+", 0, 0);
        $lead_id = $request->lead_id;
        $original =  substr_replace($request->original, "+", 0, 0);
        $admin_email = $request->admin_email;


        $get_admin = User::where('email',$admin_email)->first('id');

        $check_phone_final = Lead::where('contact',$marking_primary)->where('admin_email',$admin_email)->first();

        if($check_phone_final == null)
        {
            $check = Lead::where('admin_email',$admin_email)->where('id', $lead_id)->update(['contact' => $marking_primary]);

            $check_number = Leadcontact::where('lead_id', $lead_id)->where('contact_number',$marking_primary)->first();

            if($check_number != null)
            {
                Leadcontact::where('lead_id', $lead_id)->update(['is_primary' => 'no']);
                Leadcontact::where('id', $check_number->id)->update(['contact_number' => $original]);
            }

            $chatFrom = Leadchat::where('admin_id',$get_admin->id)->where('from', $original)->get();

            foreach($chatFrom as $chatFrom)
            {
                Leadchat::where('id',$chatFrom->id)->update(['from' => $marking_primary]);
            }

            $chatTo = Leadchat::where('admin_id',$get_admin->id)->where('to', $original)->get();

            foreach($chatTo as $chatTo)
            {
                Leadchat::where('id',$chatTo->id)->update(['to' => $marking_primary]);
            }

            $callFrom = Leadlog::where('sender_id',$get_admin->id)->where('from', $original)->get();

            foreach($callFrom as $callFrom)
            {
                Leadlog::where('id',$callFrom->id)->update(['from' => $marking_primary]);
            }

            $callTo = Leadlog::where('sender_id',$get_admin->id)->where('to', $original)->get();

            foreach($callTo as $callTo)
            {
                Leadlog::where('id',$callTo->id)->update(['to' => $marking_primary]);
            }
            $message = 'ok';
        }
        else
        {
            $message = 'false';
        }
        $primary_number = Lead::where('id', $lead_id)->value('contact');
        $all_number = Leadcontact::where('lead_id', $lead_id)->get();


        return $this->sendResponse([
            'message' => $message,
            'marking_primary' => $primary_number,
            'all_number' => $all_number,
        ],'mark-primary');

    }

    public function addemail(Request $request){

        $validator = Validator::make($request->all(), [
            "add_email_n" => 'required|email:rfc,dns',
            "lead_id" => 'required',
        ]);
        if ($validator->fails()) {

            return $this->sendResponse([
                'numberCount' => 2,
                'message' => "Invalid Email Address"
            ],'email-add');

        }
        $check_phone = Leademail::where('lead_id',$request->lead_id)->where('email',$request->add_email_n)->first();
        if(!empty($check_phone)){

            return $this->sendResponse([
                'numberCount' => 2,
                'message' => "Email Address already Exist"
            ],'email-add');

        }


        $data = [
            'lead_id' => $request->lead_id,
            'email' => $request->add_email_n,
        ];


        $all_emails = Leademail::where('lead_id',$request->lead_id)->get();

        if($all_emails->count() < 2){

            $contact = Leademail::insertGetId($data);


            return $this->sendResponse([
                'number' => $request->add_email_n,
                'leadId' => $contact,
                'numberCount' => $all_emails->count(),
                'message' => "New email added Successfully!"
            ],'email-add');
        }
        else{
            return $this->sendResponse([
                'numberCount' => 2,
                'message' => "You can only add 3 email!"
            ],'email-add');
        }
    }

    public function editemail(Request $request){

        $validator = Validator::make($request->all(), [
            "update_email_n" => 'required|email:rfc,dns',
            "id" => 'required',
            "lead_type" => 'required',
        ]);

        if ($validator->fails()) {

            return $this->sendResponse([
                'numberCount' => 2,
                'message' => "Invalid Email Address"
            ],'edit-email');
        }
        if($request->lead_type == 2)
        {
            $data = [
                'email' => $request->update_email_n,
            ];

            $contact = Leademail::where('id', $request->id)->update($data);

            if($contact){


                return $this->sendResponse([
                    'message' => "Email_updated"
                ],'edit-email');

            }
            else{

                return $this->sendResponse([
                    'message' => "Email Already Exist"
                ],'edit-email');

            }
        }
    }

    public function updateNotes(Request $request)
    {
        $user = User::where('id',auth()->user()->id)->with('companyinfo')->first('id');
        $note_id = $request->note_id;
        $note = $request->add_edit_note;
        $checknote = Leadnote::where('id',$note_id)->first();
        $update = "";
        $insert = "";
        if($checknote)
        {
            $update .= Leadnote::where("lead_id",$request->textid)->where('id',$request->note_id)->update(['note' => $note ]);
            $get = Leadnote::where("lead_id",$request->textid)->orderBy('id','desc')->get(['id','note']);
        }
        else{

            $data = [
                'lead_id' => $request->textid,
                'note' => $note,
                'created_id' => $user->id,
            ];

            $insert .=  Leadnote::insert($data);
            $get = Leadnote::where("lead_id",$request->textid)->orderBy('id','desc')->get(['id','note']);
        }


      if($update || $insert)
      {

          return $this->sendResponse([
              'add_note' => $get,
              'message' => "notes added Successfully!"
          ],'note-add');
      }
      else
          {
              return $this->sendResponse([
                  'add_note' => 'something went wrong ',
              ],'note-add');
      }

    }

    public function DeletNotes(Request $request){

        $note_id = $request->note_id;
        $lead_id = $request->leadid;

        $checknote = Leadnote::where('id',$note_id)->first();

        if($checknote){
            $delete = Leadnote::where('id',$note_id)->where('lead_id',$lead_id)->delete();
            $get = Leadnote::where("lead_id",$lead_id)->orderBy('id','desc')->get(['id','note']);

            return $this->sendResponse([
                'delete_note' => $get,
                'message' => "notes Delete Successfully!"
            ],'delete_note');
        }
        else{

            return $this->sendResponse([
                'delete_note' => 'something went wrong ',
            ],'delete_note');

        }


    }





    public function leadInfoApi(Request $request){

        $key = "OXy6QTkjto0PVGi4dWgYzBXhUF3dXn6CzDW6YG1BQWwJi0gRQAtiHMRIVTwqOE4k";
        
        if($request->key == $key){
//            $request->From = "+".$request->From;
//            $request->To = "+".$request->To;

            // echo csrf_token();

            $check_admin = Companyinfo::where('phone_number',$request->To)->first(['user_id']);

            if($check_admin != null){

                $get_admin_id = User::where('id',$check_admin->user_id)->first(['email']);
                $get_lead = Lead::where('admin_email',$get_admin_id->email)->where('contact',$request->From)->first(['id','sender_first_name','sender_last_name','contact','lead_status']);

                if($get_lead != null)
                {
                    $inventory = Leadinventoryinfo::where('lead_id',$get_lead->id)->first();

                    if($inventory != null)
                    {
//                        $myJSON =  json_encode([
//                            'status' => "Success",
//                            'first_name' => $get_lead->sender_first_name,
//                            'last_name' => $get_lead->sender_last_name,
//                            'cell_number' => $get_lead->contact,
//                            'lead_status' => $get_lead->lead_status,
//                            'vin' => $inventory->vin,
//                            'year' => $inventory->year,
//                            'make' => $inventory->make,
//                            'model' => $inventory->model
//                        ]);
                        return response()->json([
                            'status' => "Success",
                            'first_name' => $get_lead->sender_first_name,
                            'last_name' => $get_lead->sender_last_name,
                            'cell_number' => $get_lead->contact,
                            'lead_status' => $get_lead->lead_status,
                            'vin' => $inventory->vin,
                            'year' => $inventory->year,
                            'make' => $inventory->make,
                            'model' => $inventory->model
                        ]);

//                        echo "myFunc(".$myJSON.");";
                    }

                    else
                    {
                        return response()->json([
                            'status' => "Success",
                            'first_name' => $get_lead->sender_first_name,
                            'last_name' => $get_lead->sender_last_name,
                            'cell_number' => $get_lead->contact,
                            'lead_status' => $get_lead->lead_status,
                            'vin' => null,
                            'year' => null,
                            'make' => null,
                            'model' => null
                        ]);
                    }
                }
                else
                {
                    return response()->json(['status' => "Unsuccess"]);
                }
            }
            else{
                return response()->json(['status' => "Unsuccess"]);
            }
        }
        else{
            return response()->json(['status' => "Key not matched"]);
        }

    }

    public function messageSendApi(Request $request){

        $key = "OXy6QTkjto0PVGi4dWgYzBXhUF3dXn6CzDW6YG1BQWwJi0gRQAtiHMRIVTwqOE4k";
        
        if($request->key == $key){
            $sid    = $this->sid;
            $token  = $this->auth;
            $client = new Client( $sid, $token );

//            $request->From = "+".$request->From;
//            $request->To = "+".$request->To;
            $request->Body;




            $admin_contact = User::select('users.id','users.parent_user_id','users.usertype_id','users.email')
                ->where('company_info.phone_number',$request->From)
                ->leftjoin('company_info','company_info.user_id','users.id')
                ->first();


            $check_admin = Companyinfo::select('company_info.*','users.email as admin','users.id as private_id')
                ->leftjoin('users','company_info.user_id','users.id')
                ->where('company_info.phone_number',$request->From)
                ->first();

            if($check_admin != null){

                $get_admin_id = User::where('id',$check_admin->user_id)->first();
                $get_lead_id = Lead::where('admin_email',$get_admin_id->email)->where('contact',$request->To)->first();

                $check_number = Leadchat::where(function($query) use ($request) {
                        $query->where('from',$request->To)
                            ->orwhere('to',$request->To);
                    })
                    ->where('lead_id',$get_lead_id->id)
                    ->where('admin_id',$get_admin_id->id)
                    ->first();

                $message_length = 1;
                if(strlen($request->Body) < 161) { $message_length = 1; }
                else if(strlen($request->Body) > 160 && strlen($request->Body) < 321) { $message_length = 2; }
                else if(strlen($request->Body) > 320 && strlen($request->Body) < 481) { $message_length = 3; }
                else if(strlen($request->Body) > 480 && strlen($request->Body) < 641) { $message_length = 4; }
                else if(strlen($request->Body) > 640 && strlen($request->Body) < 801) { $message_length = 5; }
                else if(strlen($request->Body) > 800 && strlen($request->Body) < 961) { $message_length = 6; }
                else if(strlen($request->Body) > 960 && strlen($request->Body) < 1121) { $message_length = 7; }
                else { $message_length = 8; }

                if($check_number != null)
                {
                    $ninja = 'no';

                    if($request->To != null)
                    {

                        try{
                        $client->messages->create(
                            $request->leadnumber,
                            array(
                                "messagingServiceSid" => $check_admin->msg_service_id,
                                'body' => $request->leadmessage
                            )
                        );
//                            $client  = true;
                        }
                        catch(\Twilio\Exceptions\RestException $e)
                        {
                            $client = "false";

                            Lead::where('admin_email',$get_admin_id->adminemail)->where('id',$get_lead_id->lead_id)->update(['lead_status' => "Wrong Number"]);

                            $get_admin_ninjas = Cache::rememberForever('get_admin_ninjas'.$get_admin_id->id,function () use($get_admin_id)  {
                                $admins = NinjaAssign::where('user_id',$get_admin_id->id)->where('assign_status','yes')->get(['ninja_id']);
                                if($admins) {
                                    return implode('_',$admins->pluck('ninja_id')->toArray());
                                }else{
                                    return false;
                                }
                            });

                            Cache::forget('total_appt_set'.$this->get_ninja_admins);
                            Cache::forget('total_appt_set'.$get_admin_ninjas);
                            Cache::forget('total_appt_set'.$get_admin_id->id);

                            Cache::forget('total_appt_showup'.$this->get_ninja_admins);
                            Cache::forget('total_appt_showup'.$get_admin_ninjas);
                            Cache::forget('total_appt_showup'.$get_admin_id->id);

                            Cache::forget('total_sold'.$this->get_ninja_admins);
                            Cache::forget('total_sold'.$get_admin_ninjas);
                            Cache::forget('total_sold'.$get_admin_id->id);

                            return response()->json(['status' => 'no', 'lead_messages' => "This cell number is unreachable."]);
                        }

                        if($client)
                        {

                            $send = [
                                'admin_id' => $get_admin_id->id,
                                'lead_id' => $get_lead_id->id,
                                'from' => $check_admin->phone_number,
                                'to' => $request->To,
                                'message' => $request->Body,
                                'chat_id' =>$check_number->chat_id,
                                'type' => 'sent',
                                'private_chat' => $ninja,
                                'private_id' => $check_admin->private_id,
                                'sender_id' => $admin_contact->id,
                                'message_length' => $message_length
                            ];

                            $message_insert = Leadchat::insert($send);

                            // flushing cache for text chats
                            $get_admin_ninjas = Cache::rememberForever('get_admin_ninjas'.$get_admin_id->id,function () use($get_admin_id)  {
                                $admins = NinjaAssign::where('user_id',$get_admin_id->id)->where('assign_status','yes')->get(['ninja_id']);
                                if($admins) {
                                    return implode('_',$admins->pluck('ninja_id')->toArray());
                                }else{
                                    return false;
                                }
                            });

//                            Cache::forget('today_ninja_text'.$this->get_ninja_admins);
                            Cache::forget('today_ninja_text'.$get_admin_ninjas);
                            Cache::forget('today_ninja_text'.$get_admin_id->id);

                            Cache::forget('total_agent_text'.$get_admin_ninjas);

//                            Cache::forget('total_text'.$this->get_ninja_admins);
                            Cache::forget('total_text'.$get_admin_ninjas);
                            Cache::forget('total_text'.$get_admin_id->id);

                            $find_lead = Lead::where('id',$get_lead_id->id)->where('admin_email',$get_admin_id->email)->where('contact',$request->To)->first();

//                            if(session()->get('usertype') == 4){
//                                $data = [
//                                    'chat_filter' => 0,
//                                    'assigned_user_id' => session()->get('id'),
//                                    'updated_at' => date('Y-m-d H:i:s'),
//                                ];
//                            }
//                            else
//                            {
                                $data = [
                                    'chat_filter' => 0,
                                    'updated_at' => date('Y-m-d H:i:s'),
                                ];
//                            }
//                            dd('here');
                            Lead::where('id',$find_lead->id)->update($data);

                            $get_lead_message = Leadchat::select('lead_chat.*','users.first_name as senderfirstname','users.last_name as senderlastname')
                                ->leftjoin('users','users.id','lead_chat.sender_id')
                                ->where('lead_chat.chat_id',$check_number->chat_id)
                                ->where('lead_chat.admin_id', $get_admin_id->id)
                                ->get();

                            return response()->json(['status' => 'yes', 'lead_messages' => $get_lead_message]);
                        }
                        else{
                            return response()->json(['status' => 'no', 'lead_messages' => "Phone number is invalid"]);
                        }
                    }
                    else{
                        Lead::where('admin_email',$get_admin_id->adminemail)->where('id',$get_lead_id->lead_id)->update(['lead_status' => "Invalid Cell Number"]);

                        return response()->json(['status' => 'no', 'lead_messages' => "Phone number is invalid"]);
                    }
                }
                else{
                    $get_max_value = Leadchat::max('chat_id');

                    $count = $get_max_value + 1;

                    $ninja = 'no';

                    if($request->To != null)
                    {
                        try{
                            $client->messages->create(
                                $request->To,
                                array(
                                    "messagingServiceSid" => $check_admin->msg_service_id,
                                    'body' => $request->Body
                                )
                            );
                        } catch(\Twilio\Exceptions\RestException $e)
                        {
                            $client = "false";

                            Lead::where('admin_email',$get_admin_id->email)->where('id',$get_lead_id->id)->update(['lead_status' => "Wrong Number"]);

                            $get_admin_ninjas = Cache::rememberForever('get_admin_ninjas'.$get_admin_id->id,function () use($get_admin_id)  {
                                $admins = NinjaAssign::where('user_id',$get_admin_id->id)->where('assign_status','yes')->get(['ninja_id']);
                                if($admins) {
                                    return implode('_',$admins->pluck('ninja_id')->toArray());
                                }else{
                                    return false;
                                }
                            });

//                            Cache::forget('total_appt_set'.$this->get_ninja_admins);
                            Cache::forget('total_appt_set'.$get_admin_ninjas);
                            Cache::forget('total_appt_set'.$get_admin_id->id);

//                            Cache::forget('total_appt_showup'.$this->get_ninja_admins);
                            Cache::forget('total_appt_showup'.$get_admin_ninjas);
                            Cache::forget('total_appt_showup'.$get_admin_id->id);

//                            Cache::forget('total_sold'.$this->get_ninja_admins);
                            Cache::forget('total_sold'.$get_admin_ninjas);
                            Cache::forget('total_sold'.$get_admin_id->id);

                            return response()->json(['status' => 'no', 'lead_messages' => "This cell number is unreachable."]);
                        }

                        if($client)
                        {
                            $send = [
                                'admin_id' => $get_admin_id->id,
                                'lead_id' => $get_lead_id->id,
                                'from' => $request->From,
                                'to' => $request->To,
                                'message' => $request->Body,
                                'internal' => 0,
                                'chat_id' =>$count,
                                'type' => 'bot_sent',
                                'private_chat' => $ninja,
                                'private_id' => $check_admin->private_id,
                                'message_length' => $message_length
                            ];

                            $message_insert = Leadchat::insert($send);

                            // flushing cache for text chats
                            $get_admin_ninjas = Cache::rememberForever('get_admin_ninjas'.$get_admin_id->id,function () use($get_admin_id)  {
                                $admins = NinjaAssign::where('user_id',$get_admin_id->id)->where('assign_status','yes')->get(['ninja_id']);
                                if($admins) {
                                    return implode('_',$admins->pluck('ninja_id')->toArray());
                                }else{
                                    return false;
                                }
                            });

                            Cache::forget('today_ninja_text'.$this->get_ninja_admins);
                            Cache::forget('today_ninja_text'.$get_admin_ninjas);
                            Cache::forget('today_ninja_text'.$get_admin_id->id);

                            Cache::forget('total_agent_text'.$get_admin_ninjas);

                            Cache::forget('total_text'.$this->get_ninja_admins);
                            Cache::forget('total_text'.$get_admin_ninjas);
                            Cache::forget('total_text'.$get_admin_id->id);

                            $data = [
                                'chat_filter' => 0,
                                'updated_at' => date('Y-m-d H:i:s'),
                            ];

                            Lead::where('id',$get_lead_id->id)
                                ->where('admin_email',$get_admin_id->email)
                                ->update($data);

                            return response()->json(['status' => 'Success']);
                        }
                        else{
                            return response()->json(['status' => 'Unsuccess']);
                        }
                    }
                    else{
                        Lead::where('admin_email',$get_admin_id->email)->where('id',$get_lead_id->id)->update(['lead_status' => "Invalid Cell Number"]);

                        return response()->json(['status' => 'Unsuccess']);
                    }
                }

            }
            else{
                return response()->json(['status' => "Unsuccess"]);
            }
        }
        else{
            return response()->json(['status' => "Key not matched"]);
        }
      
    }
    
    
    public function responseMessageApi(Request $request)
    {
        $super_admin = DB::table('company_info')->where('id',1)->where('phone_number',$request->To)->first();
        
        if($super_admin != null)
        {
            $check_number = DB::table('lead_chat')
        					->where('admin_id',1)
        					->where('to',$request->From)
        					->first();
			
			$master_notification = DB::table('master_notification')->where('user_id',1)->where('type','unread_text')->where('user_type','superadmin')->first(['id']);
            if($master_notification == null)
            {
                DB::table('master_notification')->insert(['user_id'=>1,'user_type'=>'superadmin','type'=>'unread_text','count'=>DB::raw('count + 1')]);
            }
            else
            {
                DB::table('master_notification')->where('id',$master_notification->id)->where('user_id',1)->update(['count'=>DB::raw('count + 1')]);
            }
        					
        	if($check_number != null)
        	{
        	    $response = [
                    'admin_id' => 1,
                    'lead_id' => 0,
                    'ninja_id' => 0,
    	    		'from' => $request->From,
    	    		'to' => $super_admin->phone_number,
    	    		'message' => $request->Body,
        			'chat_id' =>$check_number->chat_id,
        			'type' => 'received',
    	    	];
    	    	
    	    	$insert = DB::table('lead_chat')->insert($response);
    	    	
    	    	$data = [
    	    	            'chat_id' =>$check_number->chat_id,
                            'chat_filter' => 1,
                            'lead_status' => 'Active-Contacted',
                            'updated_at' => date('Y-m-d H:i:s'),
                        ];
                        
                $update = DB::table('customer_leads')
                        ->where('contact',$request->From)
                        ->update($data);
                
        	}
        	else
        	{
        	    $get_max_value = DB::table('lead_chat')->max('chat_id');
                                        
                $count = $get_max_value + 1;
                                        
                $response = [
                    'admin_id' => 1,
                    'lead_id' => 0,
                    'ninja_id' => 0,
    	    		'from' => $request->From,
    	    		'to' => $super_admin->phone_number,
    	    		'message' => $request->Body,
        			'chat_id' => $count,
        			'type' => 'received',
    	    	];
    	    	$insert = DB::table('lead_chat')->insert($response);
    	    	
    	    	$data = [
    	    	            'user_id' => 1,
    	    	            'chat_id' => $count,
    	    	            'contact' => $request->From,
                            'lead_status' => 'Active-Contacted',
                            'chat_filter' => 1,
                        ];
                        
                $update = DB::table('customer_leads')
                        ->insert($data);
        	}
                
        }
        else
        {
            $check_lead_exist = "true";
            $admin_contact = DB::table('users')->where('phone_number',$request->From)->first(['id','parent_user_id','usertype_id','email']);
             
            if($admin_contact != null)
            {
                $check_lead_exist = DB::table('leads')->where('admin_email',$admin_contact->email)->where('contact',$request->From)->first(['contact']);
            }
    		
            if($check_lead_exist == null)
            {
                $admins_id = $admin_contact->id; 
                
                if($admin_contact->usertype_id == 2)
                {
                    $admins_id = $admin_contact->id;
                }
                else
                {
                    $admins_id = $admin_contact->parent_user_id;
                }
                
                dd($admins_id,'if');
                
                $master_notification = DB::table('master_notification')->where('user_id',$admins_id)->where('type','unread_text')->where('user_type','ninja')->first(['id']);
                if($master_notification == null)
                {
                    DB::table('master_notification')->insert(['user_id'=>$admins_id,'user_type'=>'ninja','type'=>'unread_text','count'=>DB::raw('count + 1')]);
                }
                else
                {
                    DB::table('master_notification')->where('id',$master_notification->id)->where('user_id',$admins_id)->update(['count'=>DB::raw('count + 1')]);
                }
                
        		$check_number = DB::table('lead_chat')
                                        ->where(function($query) use ($request) {
                                            $query->where('from',$request->From)
                                            ->orwhere('to',$request->From);
                                        })
                                        ->where('admin_id',$admins_id)
                                        ->first();
                
                $message_length = 1;
                if(strlen($request->Body) < 161) { $message_length = 1; }
                else if(strlen($request->Body) > 160 && strlen($request->Body) < 321) { $message_length = 2; }
                else if(strlen($request->Body) > 320 && strlen($request->Body) < 481) { $message_length = 3; }
                else if(strlen($request->Body) > 480 && strlen($request->Body) < 641) { $message_length = 4; }
                else if(strlen($request->Body) > 640 && strlen($request->Body) < 801) { $message_length = 5; }
                else if(strlen($request->Body) > 800 && strlen($request->Body) < 961) { $message_length = 6; }
                else if(strlen($request->Body) > 960 && strlen($request->Body) < 1121) { $message_length = 7; }
                else { $message_length = 8; }
               
                $msg_body = null;
                $mms_attachment = null;
                
                if($request->MediaUrl0 != null)
                {
                    $mms_attachment = $request->MediaUrl0;
                    
                    if($request->Body == null)
                    {
                        $msg_body = "Above is your attachment.";
                    }
                    else
                    {
                        $msg_body = $request->Body;
                    }
                    
                    $msg_body = $request->Body;
                }
                else
                {
                    $msg_body = $request->Body;
                }
                    
                $response = [
                    'admin_id' => $admins_id,
                    'lead_id' => 0,
    	    		'from' => $request->From,
    	    		'to' => $request->To,
    	    		'message' => $msg_body,
    	    		'mms_attachments' => $mms_attachment,
        			'chat_id' =>$check_number->chat_id,
        			'sender_id' => $admin_contact->id,
        			'type' => 'received',
            		'message_length' => $message_length
    	    	];
    	    	
    	    	$insert = DB::table('lead_chat')->insert($response);
    	    	
    	    	// flash cache
    	    	$get_admin_ninjas = Cache::rememberForever('get_admin_ninjas'.$admins_id,function () use($admins_id)  {
                    $admins = DB::table('ninja_assign')->where('user_id',$admins_id)->get(['ninja_id']);
                    if($admins) {
                        return implode('_',$admins->pluck('ninja_id')->toArray());
                    }else{
                        return false;
                    }
                });
                
                Cache::forget('total_text_received'.$this->get_ninja_admins); // for refreshing admin dashboards after ninja activities
                Cache::forget('total_text_received'.$get_admin_ninjas); // for refreshing ninja dashboards after admin activities
                Cache::forget('total_text_received'.$admins_id); // for refreshing admin and agent activities

                Cache::forget('total_mms_received'.$this->get_ninja_admins);
                Cache::forget('total_mms_received'.$get_admin_ninjas);
                Cache::forget('total_mms_received'.$admins_id);
            }
            else
            {
                $admin_contact = DB::table('company_info')->where('phone_number',$request->To)->first(['id','name','user_id','phone_number','msg_service_id']);
               
                if($admin_contact == null)
                {
                    $admin_contact = DB::table('company_extra_number')->where('phone_number',$request->To)->first(['user_id','name','phone_number']);
                }
                
                $admins_id = $admin_contact->user_id;
                
                $master_notification = DB::table('master_notification')->where('user_id',$admin_contact->user_id)->where('type','unread_text')->where('user_type','admin')->first(['id']);
                if($master_notification == null)
                {
                    DB::table('master_notification')->insert(['user_id'=>$admin_contact->user_id,'user_type'=>'admin','type'=>'unread_text','count'=>DB::raw('count + 1')]);
                }
                else
                {
                    DB::table('master_notification')->where('id',$master_notification->id)->where('user_id',$admin_contact->user_id)->update(['count'=>DB::raw('count + 1')]);
                }
                
        		$user = DB::table('users')->where('id',$admin_contact->user_id)->first(['email']);
        		$lead = DB::table('leads')->where('admin_email',$user->email)->where('contact',$request->From)->first(['id','sender_first_name','sender_last_name','lead_status']);
                
    			$check_number = DB::table('lead_chat')
                                        ->where(function($query) use ($request) {
                                            $query->where('from',$request->From)
                                            ->orwhere('to',$request->From);
                                        })
                                        ->where('admin_id',$admin_contact->user_id)
                                        ->where('lead_id',$lead->id)
                                        ->orderBy('id','desc')
                                        ->first();
            	
            	$message_length = 1;
                if(strlen($request->Body) < 161) { $message_length = 1; }
                else if(strlen($request->Body) > 160 && strlen($request->Body) < 321) { $message_length = 2; }
                else if(strlen($request->Body) > 320 && strlen($request->Body) < 481) { $message_length = 3; }
                else if(strlen($request->Body) > 480 && strlen($request->Body) < 641) { $message_length = 4; }
                else if(strlen($request->Body) > 640 && strlen($request->Body) < 801) { $message_length = 5; }
                else if(strlen($request->Body) > 800 && strlen($request->Body) < 961) { $message_length = 6; }
                else if(strlen($request->Body) > 960 && strlen($request->Body) < 1121) { $message_length = 7; }
                else { $message_length = 8; }
                
                $back_date = date("Y-m-d", strtotime("-3 days"));
                $end_date = date("Y-m-d", strtotime("+1 days"));
                
            	if($check_number != null)
            	{
            	    $msg_body = null;
                    $mms_attachment = null;
                    
                    if($request->MediaUrl0 != null)
                    {
                        $mms_attachment = $request->MediaUrl0;
                        
                        if($request->Body == null)
                        {
                            $msg_body = "Above is your attachment.";
                        }
                        else
                        {
                            $msg_body = $request->Body;
                        }
                        
                        $blast_percentage = DB::table('blast_percentage')->where('blast_type', 'mms')->where('user_id', $admin_contact->user_id)->whereDate('created_at','>=',$back_date)->whereDate('created_at','<=',$end_date)->get(['id','leads_id','value']);
                
                        if($blast_percentage->count() > 0)
                        {
                            foreach($blast_percentage as $blast_percentage)
                            {
                                if (str_contains($blast_percentage->leads_id, $lead->id)) 
                                {
                                    $blast_percentage_array = explode(",",$blast_percentage->leads_id);
                                    $index = array_search($lead->id,$blast_percentage_array);
                                    if($index !== FALSE){
                                        unset($blast_percentage_array[$index]);
                                    }
                                    $blast_percentage_value = implode(",",$blast_percentage_array);
                                    
                                    DB::table('blast_percentage')->where('id', $blast_percentage->id)->where('user_id', $admin_contact->user_id)->update(['leads_id' => $blast_percentage_value,'value' => $blast_percentage->value + 1]);
                                }
                            }
                        }
                
                        $msg_body = $request->Body;
                    }
                    else
                    {
                        $blast_percentage = DB::table('blast_percentage')->where('blast_type', 'sms')->where('user_id', $admin_contact->user_id)->whereDate('created_at','>=',$back_date)->whereDate('created_at','<=',$end_date)->get(['id','leads_id','value']);
                
                        if($blast_percentage->count() > 0)
                        {
                            foreach($blast_percentage as $blast_percentage)
                            {
                                if (str_contains($blast_percentage->leads_id, $lead->id)) 
                                {
                                    $blast_percentage_array = explode(",",$blast_percentage->leads_id);
                                    $index = array_search($lead->id,$blast_percentage_array);
                                    if($index !== FALSE){
                                        unset($blast_percentage_array[$index]);
                                    }
                                    $blast_percentage_value = implode(",",$blast_percentage_array);
                                    
                                    DB::table('blast_percentage')->where('id', $blast_percentage->id)->where('user_id', $admin_contact->user_id)->update(['leads_id' => $blast_percentage_value,'value' => $blast_percentage->value + 1]);
                                }
                            }
                        }
                
                        $msg_body = $request->Body;
                    }
                    
                
        	        // flash cache
        	    	$get_admin_ninjas = Cache::rememberForever('get_admin_ninjas'.$admin_contact->user_id,function () use($admin_contact)  {
                        $admins = DB::table('ninja_assign')->where('user_id',$admin_contact->user_id)->get(['ninja_id']);
                        if($admins) {
                            return implode('_',$admins->pluck('ninja_id')->toArray());
                        }else{
                            return false;
                        }
                    });
                    
            	    if(strtolower($msg_body) == "stop" || strtolower($msg_body) == 'not interested' || strtolower($msg_body) == 'ni')
                    {
                        $update_disposition = array('lead_status' => 'Not Interested', 'updated_at' => date('Y-m-d G:i:s'));
                        
                        DB::table('leads')->where('id',$lead->id)->update($update_disposition);
                        DB::table('lead_disposition_logs')->insert(['lead_id' => $lead->id,'from' => "bot",'logs' => "Not Interested"]);
                        
                        $response = [
                            'admin_id' => $admin_contact->user_id,
                            'lead_id' => $lead->id,
            	    		'from' => $request->From,
            	    		'to' => $request->To,
            	    		'message' => $msg_body,
            	    		'mms_attachments' => $mms_attachment,
                			'chat_id' =>$check_number->chat_id,
                			'type' => 'received',
                    		'message_length' => $message_length
            	    	];
            	    	
                        
            	    	$insert = DB::table('lead_chat')->insert($response);
            	    	
                        Cache::forget('total_text_received'.$this->get_ninja_admins); // for refreshing admin dashboards after ninja activities
                        Cache::forget('total_text_received'.$get_admin_ninjas); // for refreshing ninja dashboards after admin activities
                        Cache::forget('total_text_received'.$admin_contact->user_id); // for refreshing admin and agent activities
        
                        Cache::forget('total_mms_received'.$this->get_ninja_admins);
                        Cache::forget('total_mms_received'.$get_admin_ninjas);
                        Cache::forget('total_mms_received'.$admin_contact->user_id);
                    
                        if($insert){
                            $data = [
                                'chat_filter' => 0,
                                'sent_from' => $request->To,
                                'updated_at' => date('Y-m-d H:i:s'),
                            ];
                            $update = DB::table('leads')
                                    ->where('id',$lead->id)
                                    ->where('admin_email',$user->email)
                                    ->where('contact',$request->From)
                                    ->update($data);
                                    
                            
                        }
                    }
                    elseif(strtolower($msg_body) == 'wrong number')
                    {
                        $update_disposition = array('lead_status' => 'Wrong Number', 'updated_at' => date('Y-m-d G:i:s'));
                        
                        DB::table('leads')->where('id',$lead->id)->update($update_disposition);
                        DB::table('lead_disposition_logs')->insert(['lead_id' => $lead->id,'from' => "bot",'logs' => "Wrong Number"]);
                        
                        $response = [
                            'admin_id' => $admin_contact->user_id,
                            'lead_id' => $lead->id,
            	    		'from' => $request->From,
            	    		'to' => $request->To,
            	    		'message' => $msg_body,
            	    		'mms_attachments' => $mms_attachment,
                			'chat_id' =>$check_number->chat_id,
                			'type' => 'received',
                    		'message_length' => $message_length
            	    	];
            	    	
                        
            	    	$insert = DB::table('lead_chat')->insert($response);
            	    	
                        Cache::forget('total_text_received'.$this->get_ninja_admins); // for refreshing admin dashboards after ninja activities
                        Cache::forget('total_text_received'.$get_admin_ninjas); // for refreshing ninja dashboards after admin activities
                        Cache::forget('total_text_received'.$admin_contact->user_id); // for refreshing admin and agent activities
        
                        Cache::forget('total_mms_received'.$this->get_ninja_admins);
                        Cache::forget('total_mms_received'.$get_admin_ninjas);
                        Cache::forget('total_mms_received'.$admin_contact->user_id);
            	    	
                        if($insert){
                            $data = [
                                'chat_filter' => 0,
                                'sent_from' => $request->To,
                                'updated_at' => date('Y-m-d H:i:s'),
                            ];
                            $update = DB::table('leads')
                                    ->where('id',$lead->id)
                                    ->where('admin_email',$user->email)
                                    ->where('contact',$request->From)
                                    ->update($data);
                        }
                    }
                    else
                    {
                        
                        if($lead->lead_status == 'Active-Fresh')
                        {
                            $update_disposition = array('lead_status' => 'Active-Contacted', 'updated_at' => date('Y-m-d G:i:s'));
                            
                            DB::table('leads')->where('id',$lead->id)->update($update_disposition);
                            DB::table('lead_disposition_logs')->insert(['lead_id' => $lead->id,'from' => "bot",'logs' => "Active-Contacted"]);
                        }
                        
                        $response = [
                            'admin_id' => $admin_contact->user_id,
                            'lead_id' => $lead->id,
            	    		'from' => $request->From,
            	    		'to' => $request->To,
            	    		'message' => $msg_body,
            	    		'mms_attachments' => $mms_attachment,
                			'chat_id' => $check_number->chat_id,
                			'type' => 'received',
                    		'message_length' => $message_length
            	    	];
            	    	
            	    	$insert = DB::table('lead_chat')->insert($response);
            	    	
            	    	if($admin_contact->user_id == 197)
                        {
                        	$sid    = $this->sid;
                            $token  = $this->auth;
                            $client = new Client( $sid, $token );
                            
                            // if text
                            if (strpos(strtolower($msg_body), 'text') !== false) {
                                $client->messages->create(
                    				$request->From,
                    				array(
                    					"messagingServiceSid" => $admin_contact->msg_service_id,
                    					'body' => "Great! what stock number OR year, make, model are you looking at? I prefer you give me the stock number."
                    				)
                    			);
                                
                                $send = [
                                    'admin_id' => $admin_contact->user_id,
                                    'lead_id' => $lead->id,
                                    'from' => $request->To,
                                    'to' => $request->From,
                                    'message' => "Great! what stock number OR year, make, model are you looking at? I prefer you give me the stock number.",
                                    'chat_id' =>$check_number->chat_id
                                ];
                                
                                DB::table('lead_chat')->insert($send);
                            }
                            
                            // if stock provided
                            if(preg_replace('/[^0-9]/', '', $msg_body))
                            {
                                $stockNumber = preg_replace('/[^0-9]/', '', $msg_body);
                                
                                $inventoryLink = DB::table('lead_inventory_list')->where("stock_no",$stockNumber)->first(['inventory_link']);
                                
                                if($inventoryLink != null)
                                {
                                    if($inventoryLink->inventory_link != null)
                                    {
                                        $client->messages->create(
                            				$request->From,
                            				array(
                            					"messagingServiceSid" => $admin_contact->msg_service_id,
                            					'body' => "Great! would this be the car that you are looking at? ".$inventoryLink->inventory_link
                            				)
                            			);
                                        
                                        $send = [
                                            'admin_id' => $admin_contact->user_id,
                                            'lead_id' => $lead->id,
                                            'from' => $request->To,
                                            'to' => $request->From,
                                            'message' => "Great! would this be the car that you are looking at? ".$inventoryLink->inventory_link,
                                            'chat_id' =>$check_number->chat_id
                                        ];
                                        
                                        DB::table('lead_chat')->insert($send);
                                    }
                                }
                            }
                            
                            // if text
                            if (strpos(strtolower($msg_body), 'yes') !== false) {
                                $client->messages->create(
                    				$request->From,
                    				array(
                    					"messagingServiceSid" => $admin_contact->msg_service_id,
                    					'body' => "Ok wonderful, is today good for you to come in OR Tomorrow for a test drive?"
                    				)
                    			);
                                
                                $send = [
                                    'admin_id' => $admin_contact->user_id,
                                    'lead_id' => $lead->id,
                                    'from' => $request->To,
                                    'to' => $request->From,
                                    'message' => "Ok wonderful, is today good for you to come in OR Tomorrow for a test drive?",
                                    'chat_id' =>$check_number->chat_id
                                ];
                                
                                DB::table('lead_chat')->insert($send);
                            }
                            
                            // if call
                            if (strpos(strtolower($msg_body), 'call') !== false || strpos(strtolower($msg_body), 'phone') !== false) {
                                $client->messages->create(
                    				$request->From,
                    				array(
                    					"messagingServiceSid" => $admin_contact->msg_service_id,
                    					'body' => "Someone from our staff will call you within 5 minutes. Please be advised to answer your phone."
                    				)
                    			);
                                
                                $send = [
                                    'admin_id' => $admin_contact->user_id,
                                    'lead_id' => $lead->id,
                                    'from' => $request->To,
                                    'to' => $request->From,
                                    'message' => "Someone from our staff will call you within 5 minutes. Please be advised to answer your phone.",
                                    'chat_id' =>$check_number->chat_id
                                ];
                                
                                DB::table('lead_chat')->insert($send);
                            }
                        }
                        
                        if($admin_contact->user_id == 385)
                        {
                        	$sid    = $this->sid;
                            $token  = $this->auth;
                            $client = new Client( $sid, $token );
                            
                            // if text
                            if (strpos(strtolower($msg_body), 'text') !== false) {
                                $client->messages->create(
                    				$request->From,
                    				array(
                    					"messagingServiceSid" => $admin_contact->msg_service_id,
                    					'body' => "Perfect! Would you like to schedule an appointment with us today or tomorrow?"
                    				)
                    			);
                                
                                $send = [
                                    'admin_id' => $admin_contact->user_id,
                                    'lead_id' => $lead->id,
                                    'from' => $request->To,
                                    'to' => $request->From,
                                    'message' => "Perfect! Would you like to schedule an appointment with us today or tomorrow?",
                                    'chat_id' =>$check_number->chat_id
                                ];
                                
                                DB::table('lead_chat')->insert($send);
                            }
                            
                            // today or tomorrow
                            if (strpos(strtolower($msg_body), 'today') !== false || strpos(strtolower($msg_body), 'tomorrow') !== false) {
                                $client->messages->create(
                    				$request->From,
                    				array(
                    					"messagingServiceSid" => $admin_contact->msg_service_id,
                    					'body' => "What's a good time for you during our normal business hours of 9am to 5pm?"
                    				)
                    			);
                                
                                $send = [
                                    'admin_id' => $admin_contact->user_id,
                                    'lead_id' => $lead->id,
                                    'from' => $request->To,
                                    'to' => $request->From,
                                    'message' => "What's a good time for you during our normal business hours of 9-5?",
                                    'chat_id' =>$check_number->chat_id
                                ];
                                
                                DB::table('lead_chat')->insert($send);
                            }
                            
                            // confirmation
                            if (preg_match('~[0-9]+~', $msg_body)) {
                                $client->messages->create(
                    				$request->From,
                    				array(
                    					"messagingServiceSid" => $admin_contact->msg_service_id,
                    					'body' => "Awesome. I will confirm with my team that this time works."
                    				)
                    			);
                                
                                $send = [
                                    'admin_id' => $admin_contact->user_id,
                                    'lead_id' => $lead->id,
                                    'from' => $request->To,
                                    'to' => $request->From,
                                    'message' => "Awesome. I will confirm with my team that this time works.",
                                    'chat_id' =>$check_number->chat_id
                                ];
                                
                                DB::table('lead_chat')->insert($send);
                            }
        
                            // if call
                            if (strpos(strtolower($msg_body), 'call') !== false || strpos(strtolower($msg_body), 'phone') !== false) {
                                $client->messages->create(
                    				$request->From,
                    				array(
                    					"messagingServiceSid" => $admin_contact->msg_service_id,
                    					'body' => "Perfect. One of our representatives will call you as soon as possible."
                    				)
                    			);
                                
                                $send = [
                                    'admin_id' => $admin_contact->user_id,
                                    'lead_id' => $lead->id,
                                    'from' => $request->To,
                                    'to' => $request->From,
                                    'message' => "Perfect. One of our representatives will call you as soon as possible.",
                                    'chat_id' =>$check_number->chat_id
                                ];
                                
                                DB::table('lead_chat')->insert($send);
                            }
                        }
                        
                        // Cache::forget('total_text_received'.$this->get_ninja_admins); // for refreshing admin dashboards after ninja activities
                       
                        if($insert){
                            $data = [
                                'chat_filter' => 1,
                                'sent_from' => $request->To,
                                'updated_at' => date('Y-m-d H:i:s'),
                            ];
                            $update = DB::table('leads')
                                    ->where('id',$lead->id)
                                    ->where('admin_email',$user->email)
                                    ->where('contact',$request->From)
                                    ->update($data);
                            $firebaseToken = User::where('parent_user_id',$admins_id)->orWhere('id',$admins_id)->whereNotNull('device_token')->pluck('device_token')->all();
                    
          
                            $SERVER_API_KEY = 'AAAAzoCHeWk:APA91bGcskG8PdxbmjhFJrXtdo6ue-zUiats0IbC3LLznCOQTwC3OV5b7o9djBncWDbli0egGXZPlvV7oPt6gtdtOVSsOybMRCKD7KJ4OL4gIwENFeZE7isnnaqM4q97TejcoYXdlbjd';
                            $leadName = $lead->sender_first_name. ' ' . $lead->sender_last_name;
                            $data = [
                                "registration_ids" => $firebaseToken,
                                "notification" => [
                                    "title" => 'New message received from '.$leadName,
                                    "body" => $msg_body,  
                                ],
                                'data' => [
                                    'click_action'=> "FLUTTER_NOTIFICATION_CLICK",
                                    'lead_id' => $lead->id,
                                    'lead_first_name' => $lead->sender_first_name,
                                    'lead_last_name' => $lead->sender_last_name,
                                    'companyName' => $admin_contact->name, 
                                    'admin_email' => $user->email,
                                    'phone_number' => $admin_contact->phone_number,
                                ],
                            ];
                            $dataString = json_encode($data);
                            $headers = [
                                'Authorization: key=' . $SERVER_API_KEY,
                                'Content-Type: application/json',
                            ];
                        
                            $ch = curl_init();
                          
                            curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
                            curl_setopt($ch, CURLOPT_POST, true);
                            curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
                            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                            curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
                                   
                            $response = curl_exec($ch);
                      
                        }
                        
                        
                        
                    }
            	    
            	    // survey check
                    $lead_survey = DB::table('lead_survey')->where('admin_id',$admin_contact->user_id)->where('lead_id',$lead->id)->where('status','no')->first(['id','survey_id']);
                    if($lead_survey != null)
                    {
                    	$sid    = $this->sid;
                        $token  = $this->auth;
                        $client = new Client( $sid, $token );
            
                        $scope_exist = preg_replace('/[^0-9]/', '', $msg_body);
                        
                        if($scope_exist != '' && $scope_exist < 11)
                        {
                            DB::table('lead_survey')->where('admin_id',$admin_contact->user_id)->where('id',$lead_survey->id)->update(['scope' => $scope_exist,'message' => $msg_body,'status' => 'yes']);
                            $survey_msg = DB::table('survey_templates')->where('user_id',$admin_contact->user_id)->where('id',$lead_survey->survey_id)->first(['promoter_msg','passive_msg','detractor_msg']);
                            
                            if($scope_exist == 9 || $scope_exist == 10)
                            {
                                $tmp_msg = str_replace("[SCALE]",$scope_exist,$survey_msg->promoter_msg);
                                
                    	    	$client->messages->create(
                    				$request->From,
                    				array(
                    					"messagingServiceSid" => $admin_contact->msg_service_id,
                    					'body' => $tmp_msg
                    				)
                    			);
                                
                                $send = [
                                    'admin_id' => $admin_contact->user_id,
                                    'lead_id' => $lead->id,
                                    'from' => $request->To,
                                    'to' => $request->From,
                                    'message' => $tmp_msg,
                                    'chat_id' =>$check_number->chat_id
                                ];
                                
                                DB::table('lead_chat')->insert($send);
                            }
                            elseif($scope_exist == 7 || $scope_exist == 8)
                            {
                                $tmp_msg = str_replace("[SCALE]",$scope_exist,$survey_msg->passive_msg);
                                
                    	    	$client->messages->create(
                    				$request->From,
                    				array(
                    					"messagingServiceSid" => $admin_contact->msg_service_id,
                    					'body' => $tmp_msg
                    				)
                    			);
                                
                                $send = [
                                    'admin_id' => $admin_contact->user_id,
                                    'lead_id' => $lead->id,
                                    'from' => $request->To,
                                    'to' => $request->From,
                                    'message' => $tmp_msg,
                                    'chat_id' =>$check_number->chat_id
                                ];
                                
                                DB::table('lead_chat')->insert($send);
                            }
                            else
                            {
                                $tmp_msg = $survey_msg->detractor_msg;
                                
                    	    	$client->messages->create(
                    				$request->From,
                    				array(
                    					"messagingServiceSid" => $admin_contact->msg_service_id,
                    					'body' => $tmp_msg
                    				)
                    			);
                                
                                $send = [
                                    'admin_id' => $admin_contact->user_id,
                                    'lead_id' => $lead->id,
                                    'from' => $request->To,
                                    'to' => $request->From,
                                    'message' => $tmp_msg,
                                    'chat_id' =>$check_number->chat_id
                                ];
                                
                                DB::table('lead_chat')->insert($send);
                            }
                        }
                        else
                        {
                            DB::table('lead_survey')->where('admin_id',$admin_contact->user_id)->where('id',$lead_survey->id)->update(['message' => $msg_body,'status' => 'yes']);
                        }
                    }
                    // END survey check
        	    }
            }
        }
        return response()->json(['data'=>$data]);
        
    }
    public function syncDeviceToken(Request $request){
        DB::table('users')->where('id',auth()->user()->id)->update(['device_token' => $request->device_token]);
         return response()->json([
                'success'  => true,
                'message' => "Device token updated successfully!"
             ],200);
        //  return $this->sendResponse([
        //             'message' => "Device token updated successfully!"
        //         ],'device-token');
    }

    
}