<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Twilio\Rest\Client;
use Illuminate\Http\Request;
use DB;
use Mail;

class TodayReportCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'today:report';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Message Send Successfull';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $date = date("H:i");
        $sendSmstime = "18:50";
        $sendSmstimeAfter = "19:10";

        $sid    = 'AC15298329064d30e708bdc83adb95dc54';
        $token  = '5b99af1b1a553786d497d3072c1e29ac'; 
        $client = new Client( $sid, $token );

        if($date > $sendSmstime && $date < $sendSmstimeAfter)
        {
        
            $adminInfo = DB::table('users')->where('activity_status','!=','no')->where('usertype_id',2)->get();
    
            if(!$adminInfo->isEmpty())
            {
    
                $total_text =null;
                $total_text_received = null;
                $total_log = null;
                $total_log_received = null;
                $total_email = null;
                $total_email_received = null;
                $get_lead_blast = null;
                $get_email_blast = null;
                $appointment_set = null;
                $today_sold = null;
                $leadList = null;
                $smsCount = 1;
                $today_robo_text = null;
                $today_ninja_text = null;
                $total_agent_text_sent = null;
                $total_agent_mms_sent = null;
    
                foreach($adminInfo as $admin)
                {
                    $adminCompany = DB::table('company_info')->where('user_id',$admin->id)->first();
                    $reportingPhoneCompany = DB::table('user_reporting_details')->where('user_id',$admin->id)->whereNotNull('phone_number')->get();
                    $reportingEmailCompany = DB::table('user_reporting_details')->where('user_id',$admin->id)->whereNotNull('email')->get();
                    
                    //total text send of today
                    $total_text = DB::table('lead_chat')->where('ringless_voicemail',null)->where('mms_attachments',null)->whereDate('created_at', date('Y-m-d'))->where('admin_id',$admin->id)->count('id');
    
                    //total text received today
                    $total_text_received = DB::table('lead_chat')->where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$admin->id)->where('type','received')->whereDate('created_at', date('Y-m-d'))->count('id');
    
                    //total call send today
                    $total_log = DB::table('lead_logs')->whereDate('created_at', date('Y-m-d'))->where('status','outbound')->where('from',$adminCompany->phone_number)->count('id');
    
                    //total call received today
                    $total_log_received = DB::table('lead_logs')->where('status','incoming')->whereDate('created_at', date('Y-m-d'))->where('to',$adminCompany->phone_number)->count('id');
    
                    //total email send today
                    $total_email = DB::table('contact_email')->whereDate('created_at', date('Y-m-d'))->where('from',$adminCompany->suite)->where('type','sent')->count('id');
    
                    //total email received today
                    $total_email_received = DB::table('contact_email')->where('from',$adminCompany->suite)->where('type','received')->whereDate('created_at', date('Y-m-d'))->count('id');
    
                    //total lead blast send today
                    $get_lead_blast = DB::table('lead_blast')->where('message_status','Sent')->where('send_id',$admin->id)->whereDate('created_at', date('Y-m-d'))->count('*');
    
                    //total email blast send today
                    $get_email_blast = DB::table('email_blast')->where('email_status','Sent')->where('send_id',$admin->id)->whereDate('created_at', date('Y-m-d'))->count('*');
                    
                    //total mms blast send today
                    $today_mms_blast = DB::table('mms_blast')->where('send_id',$admin->id)->whereDate('created_at', date('Y-m-d'))->count('id');
                    $total_mms = DB::table('lead_chat')->where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('type','sent')->where('admin_id',$admin->id)->whereDate('created_at', date('Y-m-d'))->count('id');
                    $total_mms_received = DB::table('lead_chat')->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('to',$adminCompany->suite)->where('type','received')->whereDate('created_at', date('Y-m-d'))->count('id');
                    $total_robo_mms = DB::table('lead_chat')->where('ringless_voicemail',null)->where('mms_attachments',"!=",null)->where('admin_id',$admin->id)->where('sender_id',null)->where('type',null)->whereDate('created_at', date('Y-m-d'))->count('id');
                  
                    //total voicemail blast send today
                    $today_voicemail_blast = DB::table('voicemail_blast')->where('send_id',$admin->id)->whereDate('created_at', date('Y-m-d'))->count('id');
                    $total_voicemail = DB::table('lead_chat')->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('type','sent')->where('admin_id',$admin->id)->whereDate('created_at', date('Y-m-d'))->count('id');
                    $total_robo_voicemail = DB::table('lead_chat')->where('ringless_voicemail',"!=",null)->where('mms_attachments',null)->where('admin_id',$admin->id)->where('sender_id',null)->where('type',null)->whereDate('created_at', date('Y-m-d'))->count('id');
                  
                    //total appointment set today
                    $appointment_set = DB::table('leads')->where('lead_status','Appointment-Set')->where('admin_email',$admin->email)->whereDate('created_at', date('Y-m-d'))->count('*');
    
                    //total sold  today
                    $today_sold = DB::table('leads')->where('admin_email',$admin->email)->whereIn('lead_status',['sold-used','Sold-New','Sold-Unknown'])->whereDate('created_at', date('Y-m-d'))->count('*');
    
                    //total leads of today
                    $leadList = DB::table('leads')->where('admin_email',$admin->email)->whereDate('created_at', date('Y-m-d'))->count('*');
                    
                    $today_robo_text = DB::table('lead_chat')->where('ringless_voicemail',null)->where('mms_attachments',null)->where('admin_id',$admin->id)->where('sender_id',null)->where('type',null)->whereDate('created_at', date('Y-m-d'))->count('id');
                    $today_ninja_text = DB::table('lead_chat')->where('ringless_voicemail',null)->where('mms_attachments',null)->where('type','sent')->wherein('sender_id',[47,211])->whereDate('created_at', date('Y-m-d'))->count('id');
                    $total_agents = DB::table('users')->select()->where('parent_user_id', $admin->id)->get();
                    
                    foreach ($total_agents as $row) {
                        $total_agent_text = DB::table('lead_chat')->where('ringless_voicemail',null)->where('mms_attachments',null)->where('sender_id', $row->id)->whereDate('created_at', date('Y-m-d'))->count('id');
                        $total_agent_text_sent = $total_agent_text_sent + $total_agent_text;
                        
                        $total_agent_mms = DB::table('lead_chat')->where('ringless_voicemail',null)->where('mms_attachments','!=',null)->where('sender_id', $row->id)->whereDate('created_at', date('Y-m-d'))->count('id');
                        $total_agent_mms_sent = $total_agent_mms_sent + $total_agent_mms;
                    }
                  
                    //sms body
                    $smsBody = "Hi ".$admin->first_name.", today's snapshot report for ".$adminCompany->name.". Please check your CRM for detailed report.\n\nTotal Leads: ".$leadList."\nTotal Text Sent: ".$total_text."\nRobo Texts: ".$today_robo_text."\nNinja Texts: ".$today_ninja_text.
                        "\nAgents Texts: ".$total_agent_text_sent."\nTotal Text Received: ".$total_text_received.
                        "\nTotal MMS Sent: ".$total_mms."\nRobo MMS: ".$total_robo_mms."\nAgents MMS: ".$total_agent_mms_sent."\nTotal MMS Received: ".$total_mms_received.
                        "\nTotal Voicemail Sent: ".$total_voicemail."\nRobo Voicemail: ".$total_robo_voicemail.
                        "\nTotal Email Sent: ".$total_email."\nNinja Email Sent: 0\nTotal Email Received: ".$total_email_received."\nCall Made: ".$total_log."\nCall Received: ".$total_log_received.
                        "\nText Blast: ".$get_lead_blast."\nEmail Blast: ".$get_email_blast."\nMMS Blast: ".$today_mms_blast."\nVoicemail Blast: ".$today_voicemail_blast.
                        "\nAppointment Set: ".$appointment_set."\nSold: ".$today_sold;
    
                    //send sms to admin
                    if($admin->phone_number != '')
                    {
                        if($admin->activity_status == 'sms' || $admin->activity_status == 'yes')
                        {
                            $client->messages->create(
                                $admin->phone_number,
                                array(
                                    'from' => '+19796618415',
                                    'body' => $smsBody
                                )
                            );
                            if($reportingPhoneCompany->count() > 0)
                            {
                                foreach($reportingPhoneCompany as $reportingPhoneCompany)
                                {
                                    $client->messages->create(
                                        $reportingPhoneCompany->phone_number,
                                        array(
                                            'from' => '+19796618415',
                                            'body' => $smsBody
                                        )
                                    );
                                }
                                
                            }
                            
                            // Super admin section
                            $check_number = DB::table('lead_chat')->where('admin_id', 1)->where('lead_id',0)->where('to',$admin->phone_number)->first();
                            
                            if($check_number != null)
                    	    {
                                $send = [
                            		'admin_id' => 1,
                            		'lead_id' => 0,
                            		'ninja_id' => 0,
                            		'from' => "+19796618415",
                            		'to' => $admin->phone_number,
                            		'message' => $smsBody,
                            		'chat_id' =>$check_number->chat_id,
                            		'type' => 'sent',
                            		'sender_id' => 1,
                        		];
                            		
                        		$message_insert = DB::table('lead_chat')->insert($send);
                    	    }
                    	    else
                    	    {
                    	        $get_max_value = DB::table('lead_chat')->max('chat_id');
                    		
                                $count = $get_max_value + 1;
                            
                                $send = [
                            		'admin_id' => 1,
                            		'lead_id' => 0,
                            		'ninja_id' => 0,
                            		'from' => "+19796618415",
                            		'to' => $admin->phone_number,
                            		'message' => $smsBody,
                            		'chat_id' => $count,
                            		'type' => 'sent',
                            		'sender_id' => 1,
                        		];
                            		
                        		$message_insert = DB::table('lead_chat')->insert($send);
                    	    }
                        }
                    }
                    
                    if($admin->activity_status == 'email' || $admin->activity_status == 'yes')
                    {
                        // Email section   
                        $data = [
                            'first_name'=> $admin->first_name,
                            'last_name'=>$admin->last_name,
                            'company_name' => $adminCompany->name,
                            'total_text'=>$total_text,
                            'total_text_received'=>$total_text_received,
                            'total_log'=>$total_log,
                            'total_log_received'=>$total_log_received,
                            'total_email'=>$total_email,
                            'total_email_received'=>$total_email_received,
                            'get_lead_blast'=>$get_lead_blast,
                            'get_email_blast'=>$get_email_blast,
                            'appointment_set'=>$appointment_set,
                            'today_sold'=>$today_sold,
                            'leadList'=>$leadList,
                            'today_robo_text' => $today_robo_text,
                            'today_ninja_text' => $today_ninja_text,
                            'total_agent_text_sent' => $total_agent_text_sent,
                        ];
                        
                        Mail::send('email.today_reports',$data, function($message) use ($admin){
                            $message->to($admin->email, $admin->first_name." ".$admin->last_name)
                                ->subject("Today's Snapshot Report  (".date('m-d-Y').") - Text10X.ai");
                            $message->from('info@text10x.ai','Text10X');
                        });
                        
                        if($reportingEmailCompany->count() > 0)
                        {
                            $contactList = [];
                            $i=0;
                    
                            foreach($reportingEmailCompany as $reportingEmail){
                                $contactList[$i] = $reportingEmail->email;
                                $i++;
                            }
                            
                            Mail::send('email.today_reports',$data, function($message) use ($admin,$contactList){
                                $message->to($contactList)
                                    ->subject("Today's Snapshot Report  (".date('m-d-Y').") - Text10X.ai");
                                $message->from('info@text10x.ai','Text10X');
                            });
                        }
                    }
                }
            }

        }

    }

    
}
