<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Twilio\Rest\Client;
use Carbon\Carbon;
use DB;

class ReminderBlastCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'reminder:blast';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Message Send Successfull';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $curr_date =  date('Y-m-d H:i');
        $appointments = DB::table('lead_appointment')->where('status','no')->get();
        
        if($appointments->count() > 0)
        {
            $sid    = 'AC15298329064d30e708bdc83adb95dc54';
            $token  = '5b99af1b1a553786d497d3072c1e29ac'; 
            $client = new Client( $sid, $token );
        
            foreach($appointments as $list)
            {
                $reminder_date = date('Y-m-d H:i', strtotime("-60 minutes", strtotime($list->set_appointment)));
                
                if($curr_date >= $reminder_date)
                {
                    $success = DB::table('lead_appointment')->where('id',$list->id)->update(['status' => 'yes']);
    
                    $lead = DB::table('leads')->where('id',$list->lead_id)->first();
                    $user = DB::table('users')->where('email',$lead->admin_email)->first();
                    $admin_contact = DB::table('company_info')->where('user_id',$user->id)->first();

                    $message = $lead->sender_first_name.", don't forget about your appointment at ".date("h:i a",strtotime($list->set_appointment))." with ".$admin_contact->name."! Can I get confirmation? ADDR: ".$admin_contact->address.", ".$admin_contact->city.", ".$admin_contact->state." ".$admin_contact->zip_code;
                    
                    $check_number = DB::table('lead_chat')
                                            ->where('admin_id',$user->id)
                        					->where('from',$lead->contact)
                        					->orwhere('to',$lead->contact)
                        					->first();
                        					
                    if($check_number != null){
                        
                        $chat = [
                            'admin_id' => $user->id,
                            'lead_id' => $list->lead_id,
                            'from' => $admin_contact->phone_number,
                            'to' => $lead->contact,
                            'message' => $message,
                            'internal' => 0,
                            'chat_id' => $check_number->chat_id,
                            'type' => null,
                        ];
                        
                        $chatSent = DB::table('lead_chat')->insert($chat);
                        
                        if($chatSent)
                        {
            	     		$client->messages->create(
                								$lead->contact,
                								array(
                									'from' => $admin_contact->phone_number,
                									'body' => $message
                								)
                							);
                        }
                    }
                }
            }
        }
    }
}
